/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.function.Function;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;
import org.eclipse.store.storage.exceptions.StorageExceptionConsistency;
import org.eclipse.store.storage.exceptions.StorageExceptionIoReading;
import org.eclipse.store.storage.types.StorageDataInventoryFile;
import org.eclipse.store.storage.types.StorageEntity;
import org.eclipse.store.storage.types.StorageEntityCache;
import org.eclipse.store.storage.types.StorageEntityCacheEvaluator;
import org.eclipse.store.storage.types.StorageLiveDataFile;

public interface StorageEntityInitializer<D extends StorageLiveDataFile> {
    public D registerEntities(XGettingSequence<? extends StorageDataInventoryFile> var1, long var2);

    public static StorageEntityInitializer<StorageLiveDataFile.Default> New(StorageEntityCache.Default entityCache, Function<StorageDataInventoryFile, StorageLiveDataFile.Default> dataFileCreator) {
        return new Default((Function)X.notNull(dataFileCreator), (StorageEntityCache.Default)X.notNull((Object)entityCache));
    }

    public static final class Default
    implements StorageEntityInitializer<StorageLiveDataFile.Default> {
        private final Function<StorageDataInventoryFile, StorageLiveDataFile.Default> dataFileCreator;
        private final StorageEntityCache.Default entityCache;

        Default(Function<StorageDataInventoryFile, StorageLiveDataFile.Default> dataFileCreator, StorageEntityCache.Default entityCache) {
            this.dataFileCreator = dataFileCreator;
            this.entityCache = entityCache;
        }

        @Override
        public final StorageLiveDataFile.Default registerEntities(XGettingSequence<? extends StorageDataInventoryFile> files, long lastFileLength) {
            return Default.registerEntities(this.dataFileCreator, this.entityCache, (XGettingSequence<? extends StorageDataInventoryFile>)files.toReversed(), lastFileLength);
        }

        private static StorageLiveDataFile.Default registerEntities(Function<StorageDataInventoryFile, StorageLiveDataFile.Default> fileCreator, StorageEntityCache.Default entityCache, XGettingSequence<? extends StorageDataInventoryFile> reversedFiles, long lastFileLength) {
            ByteBuffer buffer = Default.allocateInitializationBuffer(reversedFiles);
            Iterator iterator = reversedFiles.iterator();
            int[] entityOffsets = Default.createAllFilesOffsetsArray(buffer.capacity());
            long initTime = System.currentTimeMillis();
            StorageLiveDataFile.Default headFile = Default.setupHeadFile(fileCreator.apply((StorageDataInventoryFile)iterator.next()));
            Default.registerFileEntities(entityCache, initTime, headFile, lastFileLength, buffer, entityOffsets);
            StorageLiveDataFile.Default dataFile = headFile;
            while (iterator.hasNext()) {
                dataFile = Default.linkTailFile(dataFile, fileCreator.apply((StorageDataInventoryFile)iterator.next()));
                Default.registerFileEntities(entityCache, initTime, dataFile, dataFile.size(), buffer, entityOffsets);
            }
            XMemory.deallocateDirectByteBuffer((ByteBuffer)buffer);
            return headFile;
        }

        static final void registerFileEntities(StorageEntityCache.Default entityCache, long initializationTime, StorageLiveDataFile.Default file, long fileActualLength, ByteBuffer buffer, int[] entityOffsets) {
            int entityCount = Default.indexEntities(file, fileActualLength, buffer, entityOffsets);
            StorageEntityCacheEvaluator entityCacheEvaluator = entityCache.entityCacheEvaluator;
            long bufferStartAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)buffer);
            long totalFileContentLength = 0L;
            int i = entityCount;
            while (i-- > 0) {
                if (entityCache.getEntry(Binary.getEntityObjectIdRawValue((long)(bufferStartAddress + (long)entityOffsets[i]))) != null) continue;
                long entityAddress = bufferStartAddress + (long)entityOffsets[i];
                long entityLength = Binary.getEntityLengthRawValue((long)entityAddress);
                StorageEntity.Default entity = entityCache.initialCreateEntity(entityAddress);
                entity.updateStorageInformation(XTypes.to_int((long)entityLength), entityOffsets[i]);
                file.prependEntry(entity);
                totalFileContentLength += entityLength;
                if (!entityCacheEvaluator.initiallyCacheEntity(entityCache.cacheSize(), initializationTime, entity)) continue;
                entity.putCacheData(entityAddress, entityLength);
                entityCache.modifyUsedCacheSize(entityLength);
            }
            file.increaseContentLength(totalFileContentLength);
            file.registerGapLength((long)buffer.limit() - totalFileContentLength);
        }

        private static int indexEntities(StorageLiveDataFile.Default file, long fileActualLength, ByteBuffer buffer, int[] entityOffsets) {
            int lastEntityIndex = -1;
            Default.fillBuffer(buffer, file, fileActualLength);
            long bufferStartAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)buffer);
            long bufferBoundAddress = bufferStartAddress + (long)buffer.limit();
            long address = bufferStartAddress;
            while (address < bufferBoundAddress) {
                long currentItemLength = Binary.getEntityLengthRawValue((long)address);
                if (currentItemLength > 0L) {
                    entityOffsets[++lastEntityIndex] = (int)(address - bufferStartAddress);
                    address += currentItemLength;
                    continue;
                }
                if (currentItemLength < 0L) {
                    address -= currentItemLength;
                    continue;
                }
                throw new StorageExceptionConsistency("Zero length data item.");
            }
            return lastEntityIndex + 1;
        }

        private static StorageLiveDataFile.Default setupHeadFile(StorageLiveDataFile.Default storageFile) {
            storageFile.next = storageFile.prev = storageFile;
            return storageFile;
        }

        private static StorageLiveDataFile.Default linkTailFile(StorageLiveDataFile.Default currentTailFile, StorageLiveDataFile.Default nextTailFile) {
            nextTailFile.next = currentTailFile;
            nextTailFile.prev = nextTailFile.next.prev;
            currentTailFile.prev = currentTailFile.prev.next = nextTailFile;
            return nextTailFile;
        }

        private static int[] createAllFilesOffsetsArray(int largestFileLength) {
            return new int[largestFileLength / Binary.entityHeaderLength()];
        }

        private static ByteBuffer allocateInitializationBuffer(Iterable<? extends StorageDataInventoryFile> files) {
            int largestFileSize = Default.determineLargestFileSize(files);
            ByteBuffer buffer = XMemory.allocateDirectNative((int)Math.max(largestFileSize, XMemory.defaultBufferSize()));
            return buffer;
        }

        private static void fillBuffer(ByteBuffer buffer, StorageLiveDataFile.Default file, long fileActualLength) {
            try {
                buffer.clear();
                buffer.limit(X.checkArrayRange((long)fileActualLength));
                file.readBytes(buffer, 0L, fileActualLength);
            }
            catch (Exception e) {
                throw new StorageExceptionIoReading(e);
            }
        }

        private static int determineLargestFileSize(Iterable<? extends StorageDataInventoryFile> files) {
            int largestFileSize = -1;
            for (StorageDataInventoryFile storageDataInventoryFile : files) {
                long fileLength = storageDataInventoryFile.size();
                if (fileLength > Integer.MAX_VALUE) {
                    throw new StorageExceptionIoReading("Storage file size exceeds Java technical IO limitations: " + storageDataInventoryFile.identifier());
                }
                if (fileLength <= (long)largestFileSize) continue;
                largestFileSize = (int)fileLength;
            }
            return largestFileSize;
        }
    }
}

