/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.serializer.afs.types.AFS;
import org.eclipse.serializer.afs.types.AFile;
import org.eclipse.serializer.afs.types.AReadableFile;
import org.eclipse.serializer.afs.types.AWritableFile;
import org.eclipse.serializer.chars.CharConversion_float;
import org.eclipse.serializer.chars.EscapeHandler;
import org.eclipse.serializer.chars.MemoryCharConversionIntegersUTF8;
import org.eclipse.serializer.chars.MemoryCharConversionUTF8;
import org.eclipse.serializer.chars.MemoryCharConversion_doubleUTF8;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.Constant;
import org.eclipse.serializer.collections.EqConstHashTable;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.types.XGettingMap;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.PersistenceTypeDefinition;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMember;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldGeneric;
import org.eclipse.serializer.persistence.types.PersistenceTypeDescriptionMemberFieldGenericComplex;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionary;
import org.eclipse.serializer.reference.Swizzling;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.xcsv.XCsvConfiguration;
import org.eclipse.store.storage.exceptions.StorageException;
import org.eclipse.store.storage.exceptions.StorageExceptionIo;
import org.eclipse.store.storage.exceptions.StorageExceptionIoWriting;
import org.eclipse.store.storage.types.StorageDataConverterCsvConfiguration;
import org.eclipse.store.storage.types.StorageDataFileItemIterator;
import org.eclipse.store.storage.types.StorageEntityTypeConversionFileProvider;

public interface StorageDataConverterTypeBinaryToCsv {
    public void convertDataFile(AReadableFile var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <I extends Iterable<AFile>> void convertDataFiles(I files) {
        for (AFile file : files) {
            try (AReadableFile dataFile = file.useReading();){
                this.convertDataFile(dataFile);
            }
        }
    }

    public static TypeNameMapper defaultTypeNameMapper(final XGettingMap<String, String> typeNameToCsvTypeNameMapping, final String referenceTypeName) {
        return new TypeNameMapper(){

            @Override
            public String mapTypeName(PersistenceTypeDescriptionMember columnType) {
                if (columnType.isReference()) {
                    return referenceTypeName;
                }
                String mappedTypeName = (String)typeNameToCsvTypeNameMapping.get((Object)columnType.typeName());
                if (mappedTypeName == null) {
                    throw new StorageException("Unmapped type: " + columnType.typeName());
                }
                return mappedTypeName;
            }
        };
    }

    public static final class UTF8
    implements StorageDataConverterTypeBinaryToCsv,
    StorageDataFileItemIterator.BufferProvider,
    StorageDataFileItemIterator.ItemProcessor {
        static final transient int FLUSH_BUFFER_RANGE = 100;
        static final transient int STRING_BYTE_SIZE_CHAR = XMemory.byteSize_char();
        static final transient int LITERAL_BYTE_SIZE_SINGLE_CHAR = 1 * XMemory.byteSize_byte();
        static final transient int LITERAL_BYTE_SIZE_HEXDEC_BYTE = 2 * XMemory.byteSize_byte();
        static final transient short[] BYTE_MAP = new short[256];
        private final String oidColumnName;
        private final String oidColumnType;
        private final XCsvConfiguration csvConfiguration;
        private final byte literalDelimiter;
        private final byte valueSeparator;
        private final byte lineSeparator;
        private final byte escaper;
        private final EscapeHandler escapeHandler;
        private final char controlCharsSeparator;
        private final TypeNameMapper typeNameMapper;
        private final byte listStarter;
        private final byte listTerminator;
        private final byte listSeparator;
        private final byte[] literalTrue;
        private final byte[] literalFalse;
        private final int literalByteLengthTrue;
        private final int literalByteLengthFalse;
        private final char[] decimalBuffer = new char[XChars.maxCharCount_double()];
        private final StorageEntityTypeConversionFileProvider fileProvider;
        private final PersistenceTypeDictionary typeDictionary;
        private AFile currentSourceFile;
        private final int readBufferSize;
        private final ByteBuffer readBufferNormal;
        private ByteBuffer readBufferLarge;
        private final int writeBufferSize;
        private final ByteBuffer writeBuffer;
        private final Constant<ByteBuffer> wrappedWriteBuffer;
        private final long writeStart;
        private final long writeBound;
        private final long flushBound;
        private long writeAddress;
        private final EqConstHashTable<String, ValueWriter> valueWriterMap = this.initializeValueWriterMapping();
        private final ValueWriter valueWriterRef = this.createValueWriterReference();
        private long typeId = -1L;
        private PersistenceTypeDefinition typeDescription;
        private ValueWriter[] valueWriters;
        private AWritableFile targetFile;

        public static final byte toHexadecimal(int b) throws IllegalArgumentException {
            switch (b) {
                case 0: {
                    return 48;
                }
                case 1: {
                    return 49;
                }
                case 2: {
                    return 50;
                }
                case 3: {
                    return 51;
                }
                case 4: {
                    return 52;
                }
                case 5: {
                    return 53;
                }
                case 6: {
                    return 54;
                }
                case 7: {
                    return 55;
                }
                case 8: {
                    return 56;
                }
                case 9: {
                    return 57;
                }
                case 10: {
                    return 65;
                }
                case 11: {
                    return 66;
                }
                case 12: {
                    return 67;
                }
                case 13: {
                    return 68;
                }
                case 14: {
                    return 69;
                }
                case 15: {
                    return 70;
                }
            }
            throw new IllegalArgumentException(b + " is no positive hexadecimal digit value");
        }

        private EqConstHashTable<String, ValueWriter> initializeValueWriterMapping() {
            EqHashTable map = EqHashTable.New();
            map.add((Object)Byte.TYPE.getName(), (Object)this.createValueWriter_byte());
            map.add((Object)Boolean.TYPE.getName(), (Object)this.createValueWriter_boolean());
            map.add((Object)Short.TYPE.getName(), (Object)this.createValueWriter_short());
            map.add((Object)Character.TYPE.getName(), (Object)this.createValueWriter_char());
            map.add((Object)Integer.TYPE.getName(), (Object)this.createValueWriter_int());
            map.add((Object)Float.TYPE.getName(), (Object)this.createValueWriter_float());
            map.add((Object)Long.TYPE.getName(), (Object)this.createValueWriter_long());
            map.add((Object)Double.TYPE.getName(), (Object)this.createValueWriter_double());
            map.add((Object)PersistenceTypeDictionary.Symbols.typeChars(), (Object)this.createValueWriter_chars());
            map.add((Object)PersistenceTypeDictionary.Symbols.typeBytes(), (Object)this.createValueWriter_bytes());
            return map.immure();
        }

        private static int writeBufferSize(int writeBufferSize) {
            return Math.max((writeBufferSize & 0xFFFFFFFC) == writeBufferSize ? writeBufferSize : (writeBufferSize & 0xFFFFFFFC) + 4, XMemory.defaultBufferSize());
        }

        public UTF8(StorageDataConverterCsvConfiguration configuration, StorageEntityTypeConversionFileProvider fileProvider, PersistenceTypeDictionary typeDictionary, TypeNameMapper typeNameMapper, int readBufferSize, int writeBufferSize) {
            XCsvConfiguration csvConfig = configuration.csvConfiguration();
            if (csvConfig.isControlCharacter(configuration.literalListStarter())) {
                throw new IllegalArgumentException("Conflicting list character: " + configuration.literalListStarter());
            }
            if (csvConfig.isControlCharacter(configuration.literalListTerminator())) {
                throw new IllegalArgumentException("Conflicting list character: " + configuration.literalListTerminator());
            }
            if (csvConfig.isControlCharacter(configuration.literalListSeparator())) {
                throw new IllegalArgumentException("Conflicting list character: " + configuration.literalListSeparator());
            }
            this.fileProvider = (StorageEntityTypeConversionFileProvider)X.notNull((Object)fileProvider);
            this.typeDictionary = (PersistenceTypeDictionary)X.notNull((Object)typeDictionary);
            this.csvConfiguration = csvConfig;
            this.literalDelimiter = MemoryCharConversionUTF8.toSingleByte((char)csvConfig.literalDelimiter());
            this.valueSeparator = MemoryCharConversionUTF8.toSingleByte((char)csvConfig.valueSeparator());
            this.lineSeparator = MemoryCharConversionUTF8.toSingleByte((char)csvConfig.lineSeparator());
            this.escaper = MemoryCharConversionUTF8.toSingleByte((char)csvConfig.escaper());
            this.escapeHandler = csvConfig.escapeHandler();
            this.oidColumnName = configuration.objectIdColumnName();
            this.oidColumnType = configuration.objectIdColumnTypeName();
            this.controlCharsSeparator = configuration.controlCharacterSeparator();
            this.typeNameMapper = typeNameMapper != null ? typeNameMapper : StorageDataConverterTypeBinaryToCsv.defaultTypeNameMapper(configuration.typeNameToCsvTypeNameMapping(), configuration.referenceTypeName());
            this.literalTrue = MemoryCharConversionUTF8.toUTF8((char[])XChars.readChars((String)configuration.literalBooleanTrue()));
            this.literalFalse = MemoryCharConversionUTF8.toUTF8((char[])XChars.readChars((String)configuration.literalBooleanFalse()));
            this.listStarter = MemoryCharConversionUTF8.toSingleByte((char)configuration.literalListStarter());
            this.listTerminator = MemoryCharConversionUTF8.toSingleByte((char)configuration.literalListTerminator());
            this.listSeparator = MemoryCharConversionUTF8.toSingleByte((char)configuration.literalListSeparator());
            this.literalByteLengthTrue = this.literalTrue.length;
            this.literalByteLengthFalse = this.literalFalse.length;
            this.readBufferSize = Math.max(readBufferSize, XMemory.defaultBufferSize());
            this.readBufferNormal = XMemory.allocateDirectNative((int)this.readBufferSize);
            this.readBufferLarge = XMemory.allocateDirectNative((int)0);
            this.writeBufferSize = UTF8.writeBufferSize(writeBufferSize);
            this.writeBuffer = XMemory.allocateDirectNative((int)this.writeBufferSize);
            this.writeStart = XMemory.getDirectByteBufferAddress((ByteBuffer)this.writeBuffer);
            this.writeBound = this.writeAddress + (long)this.writeBuffer.capacity();
            this.flushBound = this.writeBound - 100L;
            this.writeAddress = this.writeStart;
            this.wrappedWriteBuffer = X.Constant((Object)this.writeBuffer);
        }

        private ValueWriter[] createValueWriters(XGettingSequence<? extends PersistenceTypeDescriptionMember> members) {
            ValueWriter[] valueWriters = new ValueWriter[XTypes.to_int((long)members.size())];
            int i = 0;
            for (PersistenceTypeDescriptionMember member : members) {
                valueWriters[i++] = member.isReference() ? this.valueWriterRef : this.deriveOtherValueWriter(member);
            }
            return valueWriters;
        }

        private void openChannel() throws IOException {
            AWritableFile targetFile = this.fileProvider.provideConversionFile(this.typeDescription, this.currentSourceFile);
            targetFile.ensureExists();
            this.targetFile = targetFile;
        }

        private ValueWriter deriveOtherValueWriter(PersistenceTypeDescriptionMember field) {
            if (field instanceof PersistenceTypeDescriptionMemberFieldGenericComplex) {
                return this.deriveComplexValueWriter((PersistenceTypeDescriptionMemberFieldGenericComplex)field);
            }
            ValueWriter valueWriter = (ValueWriter)this.valueWriterMap.get((Object)field.typeName());
            if (valueWriter == null) {
                throw new StorageException("Unrecognized type: " + field.typeName());
            }
            return valueWriter;
        }

        private ValueWriter deriveComplexValueWriter(PersistenceTypeDescriptionMemberFieldGenericComplex field) {
            XGettingSequence members = field.members();
            if (XTypes.to_int((long)members.size()) == 1) {
                if (((PersistenceTypeDescriptionMemberFieldGeneric)members.first()).typeName().equals(Character.TYPE.getName())) {
                    return this.createValueWriter_chars();
                }
                final ValueWriter valueWriter = ((PersistenceTypeDescriptionMemberFieldGeneric)members.first()).isReference() ? this.valueWriterRef : this.deriveOtherValueWriter((PersistenceTypeDescriptionMember)members.first());
                return new ValueWriter(){

                    @Override
                    public long writeValue(long valueReadAddress) throws IOException {
                        return this.writeComplexSingle(valueWriter, valueReadAddress);
                    }
                };
            }
            final ValueWriter[] valueWriters = this.createValueWriters((XGettingSequence<? extends PersistenceTypeDescriptionMember>)members);
            return new ValueWriter(){

                @Override
                public long writeValue(long valueReadAddress) throws IOException {
                    return this.writeComplexMultiple(valueWriters, valueReadAddress);
                }
            };
        }

        private void processEntity(long entityAddress) throws IOException {
            this.checkType(Binary.getEntityTypeIdRawValue((long)entityAddress));
            byte valueSeparator = this.valueSeparator;
            this.checkForFlush();
            XMemory.set_byte((long)this.writeAddress, (byte)this.lineSeparator);
            this.writeAddress = MemoryCharConversionIntegersUTF8.put_long((long)Binary.getEntityObjectIdRawValue((long)entityAddress), (long)(this.writeAddress + 1L));
            XMemory.set_byte((long)this.writeAddress, (byte)valueSeparator);
            this.writeAddress += (long)LITERAL_BYTE_SIZE_SINGLE_CHAR;
            long address = Binary.toEntityContentOffset((long)entityAddress);
            for (ValueWriter writer : this.valueWriters) {
                address = writer.writeValue(address);
                this.write(valueSeparator);
            }
            this.writeAddress -= (long)LITERAL_BYTE_SIZE_SINGLE_CHAR;
        }

        private void checkType(long typeId) throws IOException {
            if (this.typeId < 0L) {
                this.typeDescription = this.typeDictionary.lookupTypeById(typeId);
                if (this.typeDescription == null) {
                    throw new StorageException("Unknown TypeId: " + typeId);
                }
                this.typeId = typeId;
                this.valueWriters = this.createValueWriters((XGettingSequence<? extends PersistenceTypeDescriptionMember>)this.typeDescription.instanceMembers());
                this.openChannel();
                this.writeCsvHeader();
            } else if (typeId != this.typeId) {
                throw new StorageException("Inconsistent TypeId: " + typeId + " != " + this.typeId);
            }
        }

        private void writeCsvHeader() throws IOException {
            VarString vs = VarString.New();
            boolean linePresent = this.writeCsvHeaderControlCharacterDefinition(vs);
            linePresent = this.writeCsvHeaderColumnNames(vs, linePresent);
            linePresent = this.writeCsvHeaderColumnTypes(vs, linePresent);
            if (this.writeAddress + (long)(vs.length() * MemoryCharConversionUTF8.maxCharacterLength()) > this.writeBound) {
                this.flushWriteBuffer();
            }
            this.writeAddress = MemoryCharConversionUTF8.writeUTF8((long)this.writeAddress, (VarString)vs);
        }

        private boolean writeCsvHeaderControlCharacterDefinition(VarString vs) {
            if (X.isNotTrue((Boolean)this.csvConfiguration.hasControlCharacterDefinitionHeader())) {
                return false;
            }
            vs.add(this.csvConfiguration.buildControlCharactersDefinition(this.controlCharsSeparator));
            return true;
        }

        private boolean writeCsvHeaderColumnNames(VarString vs, boolean linePresent) {
            if (linePresent) {
                vs.add((char)this.lineSeparator);
            }
            char valueSeparator = (char)this.valueSeparator;
            vs.add(this.oidColumnName);
            for (PersistenceTypeDescriptionMember column : this.typeDescription.instanceMembers()) {
                vs.add(valueSeparator).add(column.name());
            }
            return true;
        }

        private boolean writeCsvHeaderColumnTypes(VarString vs, boolean linePresent) {
            if (X.isFalse((Boolean)this.csvConfiguration.hasColumnTypesHeader())) {
                return false;
            }
            if (linePresent) {
                vs.add((char)this.lineSeparator);
            }
            char valueSeparator = (char)this.valueSeparator;
            vs.add(this.csvConfiguration.headerStarter()).add(this.oidColumnType);
            for (PersistenceTypeDescriptionMember column : this.typeDescription.instanceMembers()) {
                vs.add(valueSeparator).add(this.typeNameMapper.mapTypeName(column));
            }
            vs.add(this.csvConfiguration.headerTerminator());
            return true;
        }

        @Override
        public final void convertDataFile(AReadableFile file) {
            if (file.isEmpty()) {
                return;
            }
            try {
                WriteException suppressed = null;
                try {
                    StorageDataFileItemIterator.Default.processInputFile(file, this, this, 0L, file.size());
                    this.flushWriteBuffer();
                }
                catch (WriteException e) {
                    suppressed = e;
                    throw new StorageExceptionIoWriting(e.ioException);
                }
                finally {
                    this.reset(suppressed);
                }
            }
            catch (IOException e) {
                throw new StorageExceptionIo(e);
            }
            finally {
                this.currentSourceFile = null;
            }
        }

        private void flushWriteBuffer() throws IOException {
            this.writeAddress = this.flushWriteBuffer(this.writeAddress);
        }

        private long flushWriteBuffer(long writeAddress) throws IOException {
            if (writeAddress == this.writeStart) {
                return this.writeAddress;
            }
            this.writeBuffer.limit(X.checkArrayRange((long)(writeAddress - this.writeStart)));
            this.targetFile.writeBytes(this.wrappedWriteBuffer);
            this.writeBuffer.clear();
            return this.writeStart;
        }

        private void reset(Throwable suppressed) throws IOException {
            try {
                AFS.close((AReadableFile)this.targetFile, (Throwable)suppressed);
            }
            finally {
                this.typeId = -1L;
                this.typeDescription = null;
                this.valueWriters = null;
                this.targetFile = null;
            }
        }

        private void checkForFlush() throws IOException {
            if (this.writeAddress >= this.flushBound) {
                this.flushWriteBuffer();
            }
        }

        final void write(byte value) throws IOException {
            this.checkForFlush();
            XMemory.set_byte((long)this.writeAddress++, (byte)value);
        }

        final void write_byte(byte value) throws IOException {
            this.checkForFlush();
            this.writeAddress = MemoryCharConversionIntegersUTF8.put_byte((byte)value, (long)this.writeAddress);
        }

        final void write_boolean(boolean value) throws IOException {
            this.checkForFlush();
            if (value) {
                XMemory.copyArrayToAddress((byte[])this.literalTrue, (long)this.writeAddress);
                this.writeAddress += (long)this.literalByteLengthTrue;
            } else {
                XMemory.copyArrayToAddress((byte[])this.literalFalse, (long)this.writeAddress);
                this.writeAddress += (long)this.literalByteLengthFalse;
            }
        }

        final void write_short(short value) throws IOException {
            this.checkForFlush();
            this.writeAddress = MemoryCharConversionIntegersUTF8.put_short((short)value, (long)this.writeAddress);
        }

        final void write_char(char c) throws IOException {
            this.checkForFlush();
            XMemory.set_byte((long)this.writeAddress, (byte)this.literalDelimiter);
            if (c == this.literalDelimiter || c == this.escaper || this.escapeHandler.needsEscaping(c)) {
                XMemory.set_byte((long)(this.writeAddress + (long)LITERAL_BYTE_SIZE_SINGLE_CHAR), (byte)this.escaper);
                this.writeAddress = MemoryCharConversionUTF8.writeUTF8((long)(this.writeAddress + (long)(2 * LITERAL_BYTE_SIZE_SINGLE_CHAR)), (char)this.escapeHandler.transformEscapedChar(c)) + (long)LITERAL_BYTE_SIZE_SINGLE_CHAR;
            } else {
                this.writeAddress = MemoryCharConversionUTF8.writeUTF8((long)(this.writeAddress + (long)LITERAL_BYTE_SIZE_SINGLE_CHAR), (char)c) + (long)LITERAL_BYTE_SIZE_SINGLE_CHAR;
            }
            XMemory.set_byte((long)(this.writeAddress - (long)LITERAL_BYTE_SIZE_SINGLE_CHAR), (byte)this.literalDelimiter);
        }

        final void write_int(int value) throws IOException {
            this.checkForFlush();
            this.writeAddress = MemoryCharConversionIntegersUTF8.put_int((int)value, (long)this.writeAddress);
        }

        final void write_long(long value) throws IOException {
            this.checkForFlush();
            this.writeAddress = MemoryCharConversionIntegersUTF8.put_long((long)value, (long)this.writeAddress);
        }

        final void writeReference(long value) throws IOException {
            this.checkForFlush();
            if (value == Swizzling.nullId()) {
                XMemory.set_byte((long)this.writeAddress++, (byte)48);
                return;
            }
            this.writeAddress = MemoryCharConversionIntegersUTF8.put_long((long)value, (long)this.writeAddress);
        }

        final long writeComplexMultiple(ValueWriter[] valueWriters, long valueReadAddress) throws IOException {
            long elementCount = XMemory.get_long((long)Binary.toBinaryListElementCountOffset((long)valueReadAddress));
            long address = Binary.toBinaryListElementsOffset((long)valueReadAddress);
            byte listStarter = this.listStarter;
            byte listSeparator = this.listSeparator;
            this.write(listStarter);
            for (long a = 0L; a < elementCount; ++a) {
                this.write(listStarter);
                for (ValueWriter valueWriter : valueWriters) {
                    address = valueWriter.writeValue(address);
                    this.write(listSeparator);
                }
                XMemory.set_byte((long)(this.writeAddress - (long)LITERAL_BYTE_SIZE_SINGLE_CHAR), (byte)this.listTerminator);
                this.write(listSeparator);
            }
            this.closeComplexLiteral(elementCount);
            return valueReadAddress + Binary.getEntityLengthRawValue((long)valueReadAddress);
        }

        final long writeComplexSingle(ValueWriter valueWriter, long valueReadAddress) throws IOException {
            long elementCount = XMemory.get_long((long)Binary.toBinaryListElementCountOffset((long)valueReadAddress));
            long address = Binary.toBinaryListElementsOffset((long)valueReadAddress);
            byte listSeparator = this.listSeparator;
            this.write(this.listStarter);
            for (long a = 0L; a < elementCount; ++a) {
                address = valueWriter.writeValue(address);
                this.write(listSeparator);
            }
            this.closeComplexLiteral(elementCount);
            return valueReadAddress + Binary.getEntityLengthRawValue((long)valueReadAddress);
        }

        private void closeComplexLiteral(long elementCount) throws IOException {
            if (elementCount > 0L) {
                XMemory.set_byte((long)(this.writeAddress - (long)LITERAL_BYTE_SIZE_SINGLE_CHAR), (byte)this.listTerminator);
            } else {
                this.write(this.listTerminator);
            }
        }

        final void write_float(float value) throws IOException {
            int length = CharConversion_float.put((float)value, (char[])this.decimalBuffer, (int)0);
            this.checkForFlush();
            this.writeAddress = MemoryCharConversionUTF8.writeUTF8((long)this.writeAddress, (char[])this.decimalBuffer, (int)0, (int)length);
        }

        final void write_double(double value) throws IOException {
            this.checkForFlush();
            this.writeAddress = MemoryCharConversion_doubleUTF8.put((double)value, (long)this.writeAddress);
        }

        final void write_chars(long readStart, long readBound) throws IOException {
            long flushBound = this.flushBound;
            byte literalDelimiter = this.literalDelimiter;
            byte escaper = this.escaper;
            EscapeHandler escapeHandler = this.escapeHandler;
            this.write(literalDelimiter);
            long address = this.writeAddress;
            for (long readAddress = readStart; readAddress < readBound; readAddress += (long)STRING_BYTE_SIZE_CHAR) {
                char c = XMemory.get_char((long)readAddress);
                if (c == literalDelimiter || c == escaper || escapeHandler.needsEscaping(c)) {
                    XMemory.set_byte((long)address, (byte)escaper);
                    address = MemoryCharConversionUTF8.writeUTF8((long)(address + (long)LITERAL_BYTE_SIZE_SINGLE_CHAR), (char)escapeHandler.transformEscapedChar(c));
                } else {
                    address = MemoryCharConversionUTF8.writeUTF8((long)address, (char)c);
                }
                if (address < flushBound) continue;
                address = this.flushWriteBuffer(address);
            }
            XMemory.set_byte((long)address, (byte)literalDelimiter);
            this.writeAddress = address + (long)LITERAL_BYTE_SIZE_SINGLE_CHAR;
        }

        final void write_bytes(long readStart, long readBound) throws IOException {
            long flushBound = this.flushBound;
            this.checkForFlush();
            long address = this.writeAddress;
            for (long readAddress = readStart; readAddress < readBound; ++readAddress) {
                int value = XMemory.get_byte((long)readAddress);
                XMemory.set_short((long)address, (short)BYTE_MAP[value >= 0 ? value : 256 + value]);
                if ((address += (long)LITERAL_BYTE_SIZE_HEXDEC_BYTE) < flushBound) continue;
                address = this.flushWriteBuffer(address);
            }
            this.writeAddress = address;
        }

        final ValueWriter createValueWriter_byte() {
            return new ValueWriter(){

                @Override
                public long writeValue(long valueReadAddress) throws IOException {
                    this.write_byte(XMemory.get_byte((long)valueReadAddress));
                    return valueReadAddress + (long)XMemory.byteSize_byte();
                }
            };
        }

        final ValueWriter createValueWriter_boolean() {
            return new ValueWriter(){

                @Override
                public long writeValue(long valueReadAddress) throws IOException {
                    this.write_boolean(XMemory.get_boolean((long)valueReadAddress));
                    return valueReadAddress + (long)XMemory.byteSize_boolean();
                }
            };
        }

        final ValueWriter createValueWriter_short() {
            return new ValueWriter(){

                @Override
                public long writeValue(long valueReadAddress) throws IOException {
                    this.write_short(XMemory.get_short((long)valueReadAddress));
                    return valueReadAddress + (long)XMemory.byteSize_short();
                }
            };
        }

        final ValueWriter createValueWriter_char() {
            return new ValueWriter(){

                @Override
                public long writeValue(long valueReadAddress) throws IOException {
                    this.write_char(XMemory.get_char((long)valueReadAddress));
                    return valueReadAddress + (long)XMemory.byteSize_char();
                }
            };
        }

        final ValueWriter createValueWriter_int() {
            return new ValueWriter(){

                @Override
                public long writeValue(long valueReadAddress) throws IOException {
                    this.write_int(XMemory.get_int((long)valueReadAddress));
                    return valueReadAddress + (long)XMemory.byteSize_int();
                }
            };
        }

        final ValueWriter createValueWriter_float() {
            return new ValueWriter(){

                @Override
                public long writeValue(long valueReadAddress) throws IOException {
                    this.write_float(XMemory.get_float((long)valueReadAddress));
                    return valueReadAddress + 4L;
                }
            };
        }

        final ValueWriter createValueWriter_long() {
            return new ValueWriter(){

                @Override
                public long writeValue(long valueReadAddress) throws IOException {
                    this.write_long(XMemory.get_long((long)valueReadAddress));
                    return valueReadAddress + (long)XMemory.byteSize_long();
                }
            };
        }

        final ValueWriter createValueWriter_double() {
            return new ValueWriter(){

                @Override
                public long writeValue(long valueReadAddress) throws IOException {
                    this.write_double(XMemory.get_double((long)valueReadAddress));
                    return valueReadAddress + (long)XMemory.byteSize_double();
                }
            };
        }

        final ValueWriter createValueWriterReference() {
            return new ValueWriter(){

                @Override
                public long writeValue(long valueReadAddress) throws IOException {
                    this.writeReference(XMemory.get_long((long)valueReadAddress));
                    return valueReadAddress + (long)XMemory.byteSize_long();
                }
            };
        }

        final ValueWriter createValueWriter_chars() {
            return new ValueWriter(){

                @Override
                public long writeValue(long valueReadAddress) throws IOException {
                    long bound = valueReadAddress + XMemory.get_long((long)Binary.toBinaryListByteLengthOffset((long)valueReadAddress));
                    this.write_chars(Binary.toBinaryListElementsOffset((long)valueReadAddress), bound);
                    return bound;
                }
            };
        }

        final ValueWriter createValueWriter_bytes() {
            return new ValueWriter(){

                @Override
                public long writeValue(long valueReadAddress) throws IOException {
                    long bound = valueReadAddress + XMemory.get_long((long)Binary.toBinaryListByteLengthOffset((long)valueReadAddress));
                    this.write_bytes(Binary.toBinaryListElementsOffset((long)valueReadAddress), bound);
                    return bound;
                }
            };
        }

        @Override
        public boolean accept(long entityAddress, long availableEntityLength) {
            if (Binary.getEntityLengthRawValue((long)entityAddress) < 0L) {
                return true;
            }
            if (availableEntityLength < Binary.getEntityLengthRawValue((long)entityAddress)) {
                return false;
            }
            try {
                this.processEntity(entityAddress);
                return true;
            }
            catch (IOException e) {
                throw new WriteException(e);
            }
        }

        @Override
        public final ByteBuffer provideInitialBuffer() {
            return this.readBufferNormal;
        }

        @Override
        public ByteBuffer provideBuffer(ByteBuffer byteBuffer, long nextEntityLength) {
            if (nextEntityLength < (long)this.readBufferNormal.capacity()) {
                this.readBufferNormal.clear();
                return this.readBufferNormal;
            }
            if (nextEntityLength <= (long)this.readBufferLarge.capacity()) {
                this.readBufferLarge.clear().limit((int)nextEntityLength);
                return this.readBufferLarge;
            }
            XMemory.deallocateDirectByteBuffer((ByteBuffer)this.readBufferLarge);
            this.readBufferLarge = XMemory.allocateDirectNative((long)nextEntityLength);
            return this.readBufferLarge;
        }

        static {
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                for (int i = 0; i < BYTE_MAP.length; ++i) {
                    UTF8.BYTE_MAP[i] = (short)(UTF8.toHexadecimal((i & 0xF0) >> 4) + (UTF8.toHexadecimal(i & 0xF) << 8));
                }
            } else {
                for (int i = 0; i < BYTE_MAP.length; ++i) {
                    UTF8.BYTE_MAP[i] = (short)((UTF8.toHexadecimal((i & 0xF0) >> 4) << 8) + UTF8.toHexadecimal(i & 0xF));
                }
            }
        }

        static final class WriteException
        extends RuntimeException {
            final IOException ioException;

            public WriteException(IOException ioException) {
                this.ioException = ioException;
            }
        }

        static interface ValueWriter {
            public long writeValue(long var1) throws IOException;
        }
    }

    public static interface TypeNameMapper {
        public String mapTypeName(PersistenceTypeDescriptionMember var1);
    }
}

