/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.serializer.collections.EqConstHashTable;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.types.XGettingMap;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionary;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.xcsv.XCSV;
import org.eclipse.serializer.util.xcsv.XCsvConfiguration;
import org.eclipse.store.storage.exceptions.StorageException;

public interface StorageDataConverterCsvConfiguration {
    public XCsvConfiguration csvConfiguration();

    public XGettingMap<String, String> typeNameToCsvTypeNameMapping();

    public XGettingMap<String, String> csvTypeNameToActualTypeNameMapping();

    public String literalBooleanTrue();

    public String literalBooleanFalse();

    public char controlCharacterSeparator();

    public String objectIdColumnName();

    public String objectIdColumnTypeName();

    public String referenceTypeName();

    public char literalListStarter();

    public char literalListTerminator();

    public char literalListSeparator();

    default public String resolveActualTypeName(String csvTypeName) {
        return (String)X.coalesce((Object)((String)this.csvTypeNameToActualTypeNameMapping().get((Object)csvTypeName)), (Object)csvTypeName);
    }

    public static XGettingMap<String, String> createTypeNameToCsvTypeNameMapping(String typeNameChars, String typeNameBinary, String typeNameComplex) {
        EqConstHashTable map = EqConstHashTable.New((KeyValue[])new KeyValue[]{Defaults.transientEntry(Byte.TYPE), Defaults.transientEntry(Boolean.TYPE), Defaults.transientEntry(Short.TYPE), Defaults.transientEntry(Character.TYPE), Defaults.transientEntry(Integer.TYPE), Defaults.transientEntry(Float.TYPE), Defaults.transientEntry(Long.TYPE), Defaults.transientEntry(Double.TYPE), Defaults.mappedEntry(PersistenceTypeDictionary.Symbols.typeChars(), typeNameChars), Defaults.mappedEntry(PersistenceTypeDictionary.Symbols.typeBytes(), typeNameBinary), Defaults.mappedEntry(PersistenceTypeDictionary.Symbols.typeComplex(), typeNameComplex)});
        return map;
    }

    public static XGettingMap<String, String> deriveTypeNameToCsvTypeNameMapping(XGettingMap<String, String> typeNameToCsvTypeNameMapping) {
        EqHashTable csvTypeNameToTypeNameMapping = EqHashTable.New();
        for (KeyValue entry : typeNameToCsvTypeNameMapping) {
            csvTypeNameToTypeNameMapping.add((Object)((String)entry.value()), (Object)((String)entry.key()));
        }
        if (csvTypeNameToTypeNameMapping.size() != typeNameToCsvTypeNameMapping.size()) {
            throw new StorageException("Ambiguous csv type mapping entries.");
        }
        return csvTypeNameToTypeNameMapping;
    }

    public static Builder Builder() {
        return new Builder.Default();
    }

    public static StorageDataConverterCsvConfiguration New(XCsvConfiguration csvConfiguration, XGettingMap<String, String> typeNameToCsvTypeNameMapping, XGettingMap<String, String> csvTypeNameToTypeNameMapping, String literalBooleanTrue, String literalBooleanFalse, char controlCharacterSeparator, String objectIdColumnName, String objectIdColumnTypeName, String referenceTypeName, char literalListStarter, char literalListTerminator, char literalListSeparator) {
        return new Default((XCsvConfiguration)X.notNull((Object)csvConfiguration), (XGettingMap<String, String>)((XGettingMap)X.notNull(typeNameToCsvTypeNameMapping)), (XGettingMap<String, String>)((XGettingMap)X.notNull(csvTypeNameToTypeNameMapping)), (String)X.notNull((Object)literalBooleanTrue), (String)X.notNull((Object)literalBooleanFalse), controlCharacterSeparator, (String)X.notNull((Object)objectIdColumnName), (String)X.notNull((Object)objectIdColumnTypeName), (String)X.notNull((Object)referenceTypeName), literalListStarter, literalListTerminator, literalListSeparator);
    }

    public static StorageDataConverterCsvConfiguration defaultConfiguration() {
        return new Defaults();
    }

    public static interface Builder {
        public XCsvConfiguration csvConfiguration();

        public XGettingMap<String, String> typeNameToCsvTypeNameMapping();

        public XGettingMap<String, String> csvTypeNameToTypeNameMapping();

        public String literalBooleanTrue();

        public String literalBooleanFalse();

        public char controlCharacterSeparator();

        public String objectIdColumnName();

        public String objectIdColumnTypeName();

        public String referenceTypeName();

        public char literalListStarter();

        public char literalListTerminator();

        public char literalListSeparator();

        public Builder csvConfiguration(XCsvConfiguration var1);

        public Builder typeNameToCsvTypeNameMapping(XGettingMap<String, String> var1);

        public Builder csvTypeNameToTypeNameMapping(XGettingMap<String, String> var1);

        public Builder literalBooleanTrue(String var1);

        public Builder literalBooleanFalse(String var1);

        public Builder controlCharacterSeparator(char var1);

        public Builder objectIdColumnName(String var1);

        public Builder objectIdColumnTypeName(String var1);

        public Builder referenceTypeName(String var1);

        public Builder literalListStarter(char var1);

        public Builder literalListTerminator(char var1);

        public Builder literalListSeparator(char var1);

        public Builder reset();

        public StorageDataConverterCsvConfiguration build();

        public static final class Default
        implements Builder {
            XCsvConfiguration csvConfiguration;
            XGettingMap<String, String> typeNameToCsvTypeNameMapping;
            XGettingMap<String, String> csvTypeNameToTypeNameMapping;
            String literalBooleanTrue;
            String literalBooleanFalse;
            char controlCharacterSeparator;
            String objectIdColumnName;
            String objectIdColumnTypeName;
            String referenceTypeName;
            char literalListStarter;
            char literalListTerminator;
            char literalListSeparator;

            Default() {
                this.reset();
            }

            final void validate() {
            }

            @Override
            public final Builder reset() {
                StorageDataConverterCsvConfiguration defaultConfiguration = StorageDataConverterCsvConfiguration.defaultConfiguration();
                this.csvConfiguration = defaultConfiguration.csvConfiguration();
                this.typeNameToCsvTypeNameMapping = defaultConfiguration.typeNameToCsvTypeNameMapping();
                this.csvTypeNameToTypeNameMapping = defaultConfiguration.csvTypeNameToActualTypeNameMapping();
                this.literalBooleanTrue = defaultConfiguration.literalBooleanTrue();
                this.literalBooleanFalse = defaultConfiguration.literalBooleanFalse();
                this.controlCharacterSeparator = defaultConfiguration.controlCharacterSeparator();
                this.objectIdColumnName = defaultConfiguration.objectIdColumnName();
                this.objectIdColumnTypeName = defaultConfiguration.objectIdColumnTypeName();
                this.referenceTypeName = defaultConfiguration.referenceTypeName();
                this.literalListStarter = defaultConfiguration.literalListStarter();
                this.literalListTerminator = defaultConfiguration.literalListTerminator();
                this.literalListSeparator = defaultConfiguration.literalListSeparator();
                return this;
            }

            @Override
            public final XCsvConfiguration csvConfiguration() {
                return this.csvConfiguration;
            }

            @Override
            public final XGettingMap<String, String> typeNameToCsvTypeNameMapping() {
                return this.typeNameToCsvTypeNameMapping;
            }

            @Override
            public final XGettingMap<String, String> csvTypeNameToTypeNameMapping() {
                return this.csvTypeNameToTypeNameMapping;
            }

            @Override
            public final String literalBooleanTrue() {
                return this.literalBooleanTrue;
            }

            @Override
            public final String literalBooleanFalse() {
                return this.literalBooleanFalse;
            }

            @Override
            public final char controlCharacterSeparator() {
                return this.controlCharacterSeparator;
            }

            @Override
            public final String objectIdColumnName() {
                return this.objectIdColumnName;
            }

            @Override
            public final String objectIdColumnTypeName() {
                return this.objectIdColumnTypeName;
            }

            @Override
            public final String referenceTypeName() {
                return this.referenceTypeName;
            }

            @Override
            public final char literalListStarter() {
                return this.literalListStarter;
            }

            @Override
            public final char literalListTerminator() {
                return this.literalListTerminator;
            }

            @Override
            public final char literalListSeparator() {
                return this.literalListSeparator;
            }

            @Override
            public final Builder csvConfiguration(XCsvConfiguration csvConfiguration) {
                this.csvConfiguration = csvConfiguration;
                return this;
            }

            @Override
            public final Builder typeNameToCsvTypeNameMapping(XGettingMap<String, String> typeNameToCsvTypeNameMapping) {
                this.typeNameToCsvTypeNameMapping = typeNameToCsvTypeNameMapping;
                return this;
            }

            @Override
            public final Builder csvTypeNameToTypeNameMapping(XGettingMap<String, String> csvTypeNameToTypeNameMapping) {
                this.csvTypeNameToTypeNameMapping = csvTypeNameToTypeNameMapping;
                return this;
            }

            @Override
            public final Builder literalBooleanTrue(String literalBooleanTrue) {
                this.literalBooleanTrue = literalBooleanTrue;
                return this;
            }

            @Override
            public final Builder literalBooleanFalse(String literalBooleanFalse) {
                this.literalBooleanFalse = literalBooleanFalse;
                return this;
            }

            @Override
            public final Builder controlCharacterSeparator(char controlCharacterSeparator) {
                this.controlCharacterSeparator = controlCharacterSeparator;
                return this;
            }

            @Override
            public final Builder objectIdColumnName(String objectIdColumnName) {
                this.objectIdColumnName = objectIdColumnName;
                return this;
            }

            @Override
            public final Builder objectIdColumnTypeName(String objectIdColumnTypeName) {
                this.objectIdColumnTypeName = objectIdColumnTypeName;
                return this;
            }

            @Override
            public final Builder referenceTypeName(String referenceTypeName) {
                this.referenceTypeName = referenceTypeName;
                return this;
            }

            @Override
            public final Builder literalListStarter(char literalListStarter) {
                this.literalListStarter = literalListStarter;
                return this;
            }

            @Override
            public final Builder literalListTerminator(char literalListTerminator) {
                this.literalListTerminator = literalListTerminator;
                return this;
            }

            @Override
            public final Builder literalListSeparator(char literalListSeparator) {
                this.literalListSeparator = literalListSeparator;
                return this;
            }

            @Override
            public final StorageDataConverterCsvConfiguration build() {
                this.validate();
                return StorageDataConverterCsvConfiguration.New(this.csvConfiguration, this.typeNameToCsvTypeNameMapping, this.csvTypeNameToTypeNameMapping, this.literalBooleanTrue, this.literalBooleanFalse, this.controlCharacterSeparator, this.objectIdColumnName, this.objectIdColumnTypeName, this.referenceTypeName, this.literalListStarter, this.literalListTerminator, this.literalListSeparator);
            }
        }
    }

    public static final class Defaults
    implements StorageDataConverterCsvConfiguration {
        static final String DEFAULT_LITERAL_BOOLEAN_TRUE = "t";
        static final String DEFAULT_LITERAL_BOOLEAN_FALSE = "f";
        static final char DEFAULT_CONTROL_CHARACTER_SEPARATOR = ';';
        static final char DEFAULT_LITERAL_LIST_STARTER = '[';
        static final char DEFAULT_LITERAL_LIST_TERMINATOR = ']';
        static final char DEFAULT_LITERAL_LIST_SEPARATOR = ',';
        static final String DEFAULT_TYPE_NAME_CHARS = "string";
        static final String DEFAULT_TYPE_NAME_BYTES = "binary";
        static final String DEFAULT_TYPE_NAME_CMPLX = "complex";
        static final String DEFAULT_TYPE_NAME_REFERENCE = "reference";
        static final XGettingMap<String, String> DEFAULT_TYPE_MAPPING = StorageDataConverterCsvConfiguration.createTypeNameToCsvTypeNameMapping("string", "binary", "complex");
        static final XGettingMap<String, String> DEFAULT_TYPE_MAPPING_REVERSED = StorageDataConverterCsvConfiguration.deriveTypeNameToCsvTypeNameMapping(DEFAULT_TYPE_MAPPING);

        static final KeyValue<String, String> transientEntry(Class<?> type) {
            return X.KeyValue((Object)type.getName(), (Object)type.getName());
        }

        static final KeyValue<String, String> mappedEntry(String key, String value) {
            return X.KeyValue((Object)key, (Object)value);
        }

        @Override
        public final XCsvConfiguration csvConfiguration() {
            return XCSV.configurationDefault();
        }

        @Override
        public final XGettingMap<String, String> typeNameToCsvTypeNameMapping() {
            return DEFAULT_TYPE_MAPPING;
        }

        @Override
        public final XGettingMap<String, String> csvTypeNameToActualTypeNameMapping() {
            return DEFAULT_TYPE_MAPPING_REVERSED;
        }

        @Override
        public final String literalBooleanTrue() {
            return DEFAULT_LITERAL_BOOLEAN_TRUE;
        }

        @Override
        public final String literalBooleanFalse() {
            return DEFAULT_LITERAL_BOOLEAN_FALSE;
        }

        @Override
        public final char controlCharacterSeparator() {
            return ';';
        }

        @Override
        public final String objectIdColumnName() {
            return Persistence.objectIdLabel();
        }

        @Override
        public final String objectIdColumnTypeName() {
            return Persistence.objectIdType().getName();
        }

        @Override
        public final String referenceTypeName() {
            return DEFAULT_TYPE_NAME_REFERENCE;
        }

        @Override
        public final char literalListStarter() {
            return '[';
        }

        @Override
        public final char literalListTerminator() {
            return ']';
        }

        @Override
        public final char literalListSeparator() {
            return ',';
        }
    }

    public static final class Default
    implements StorageDataConverterCsvConfiguration {
        final XCsvConfiguration csvConfiguration;
        final XGettingMap<String, String> typeNameToCsvTypeNameMapping;
        final XGettingMap<String, String> csvTypeNameToTypeNameMapping;
        final String literalBooleanTrue;
        final String literalBooleanFalse;
        final char controlCharacterSeparator;
        final String objectIdColumnName;
        final String objectIdColumnTypeName;
        final String referenceTypeName;
        final char literalListStarter;
        final char literalListTerminator;
        final char literalListSeparator;

        public Default(XCsvConfiguration csvConfiguration, XGettingMap<String, String> typeNameToCsvTypeNameMapping, XGettingMap<String, String> csvTypeNameToTypeNameMapping, String literalBooleanTrue, String literalBooleanFalse, char controlCharacterSeparator, String objectIdColumnName, String objectIdColumnTypeName, String referenceTypeName, char literalListStarter, char literalListTerminator, char literalListSeparator) {
            this.csvConfiguration = csvConfiguration;
            this.typeNameToCsvTypeNameMapping = typeNameToCsvTypeNameMapping;
            this.csvTypeNameToTypeNameMapping = csvTypeNameToTypeNameMapping;
            this.literalBooleanTrue = literalBooleanTrue;
            this.literalBooleanFalse = literalBooleanFalse;
            this.controlCharacterSeparator = controlCharacterSeparator;
            this.objectIdColumnName = objectIdColumnName;
            this.objectIdColumnTypeName = objectIdColumnTypeName;
            this.referenceTypeName = referenceTypeName;
            this.literalListStarter = literalListStarter;
            this.literalListTerminator = literalListTerminator;
            this.literalListSeparator = literalListSeparator;
        }

        @Override
        public final XCsvConfiguration csvConfiguration() {
            return this.csvConfiguration;
        }

        @Override
        public final XGettingMap<String, String> typeNameToCsvTypeNameMapping() {
            return this.typeNameToCsvTypeNameMapping;
        }

        @Override
        public final XGettingMap<String, String> csvTypeNameToActualTypeNameMapping() {
            return this.csvTypeNameToTypeNameMapping;
        }

        @Override
        public final String literalBooleanTrue() {
            return this.literalBooleanTrue;
        }

        @Override
        public final String literalBooleanFalse() {
            return this.literalBooleanFalse;
        }

        @Override
        public final char controlCharacterSeparator() {
            return this.controlCharacterSeparator;
        }

        @Override
        public final String objectIdColumnName() {
            return this.objectIdColumnName;
        }

        @Override
        public final String objectIdColumnTypeName() {
            return this.objectIdColumnTypeName;
        }

        @Override
        public final String referenceTypeName() {
            return this.referenceTypeName;
        }

        @Override
        public final char literalListStarter() {
            return this.literalListStarter;
        }

        @Override
        public final char literalListTerminator() {
            return this.literalListTerminator;
        }

        @Override
        public final char literalListSeparator() {
            return this.literalListSeparator;
        }
    }
}

