/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import java.nio.ByteBuffer;
import java.util.function.Predicate;
import org.eclipse.serializer.afs.types.ADirectory;
import org.eclipse.serializer.afs.types.AFile;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.PersistenceManager;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionaryExporter;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionaryFileHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionaryStorer;
import org.eclipse.serializer.persistence.types.Persister;
import org.eclipse.serializer.persistence.types.Storer;
import org.eclipse.serializer.persistence.types.Unpersistable;
import org.eclipse.serializer.util.X;
import org.eclipse.store.storage.exceptions.StorageExceptionBackupFullBackupTargetNotEmpty;
import org.eclipse.store.storage.types.StorageEntityCacheEvaluator;
import org.eclipse.store.storage.types.StorageEntityTypeExportFileProvider;
import org.eclipse.store.storage.types.StorageEntityTypeExportStatistics;
import org.eclipse.store.storage.types.StorageEntityTypeHandler;
import org.eclipse.store.storage.types.StorageLiveFileProvider;
import org.eclipse.store.storage.types.StorageRawFileStatistics;
import org.eclipse.store.storage.types.StorageRequestAcceptor;

public interface StorageConnection
extends Persister {
    default public void issueFullGarbageCollection() {
        this.issueGarbageCollection(Long.MAX_VALUE);
    }

    public boolean issueGarbageCollection(long var1);

    default public void issueFullFileCheck() {
        this.issueFileCheck(Long.MAX_VALUE);
    }

    public boolean issueFileCheck(long var1);

    default public void issueFullCacheCheck() {
        this.issueFullCacheCheck(null);
    }

    default public void issueFullCacheCheck(StorageEntityCacheEvaluator entityEvaluator) {
        this.issueCacheCheck(Long.MAX_VALUE, entityEvaluator);
    }

    default public boolean issueCacheCheck(long nanoTimeBudget) {
        return this.issueCacheCheck(nanoTimeBudget, null);
    }

    public boolean issueCacheCheck(long var1, StorageEntityCacheEvaluator var3);

    default public void issueFullBackup(ADirectory targetDirectory) {
        if (targetDirectory.exists() && !targetDirectory.isEmpty()) {
            throw new StorageExceptionBackupFullBackupTargetNotEmpty(targetDirectory);
        }
        this.issueFullBackup(StorageLiveFileProvider.New(targetDirectory), PersistenceTypeDictionaryExporter.New((PersistenceTypeDictionaryStorer)PersistenceTypeDictionaryFileHandler.New((ADirectory)targetDirectory)));
    }

    public void issueFullBackup(StorageLiveFileProvider var1, PersistenceTypeDictionaryExporter var2);

    public void issueTransactionsLogCleanup();

    public StorageRawFileStatistics createStorageStatistics();

    public void exportChannels(StorageLiveFileProvider var1, boolean var2);

    default public void exportChannels(StorageLiveFileProvider fileProvider) {
        this.exportChannels(fileProvider, true);
    }

    public StorageEntityTypeExportStatistics exportTypes(StorageEntityTypeExportFileProvider var1, Predicate<? super StorageEntityTypeHandler> var2);

    default public StorageEntityTypeExportStatistics exportTypes(ADirectory targetDirectory) {
        return this.exportTypes(StorageEntityTypeExportFileProvider.New(targetDirectory));
    }

    default public StorageEntityTypeExportStatistics exportTypes(ADirectory targetDirectory, Predicate<? super StorageEntityTypeHandler> isExportType) {
        return this.exportTypes(StorageEntityTypeExportFileProvider.New(targetDirectory), isExportType);
    }

    default public StorageEntityTypeExportStatistics exportTypes(StorageEntityTypeExportFileProvider exportFileProvider) {
        return this.exportTypes(exportFileProvider, null);
    }

    public void importFiles(XGettingEnum<AFile> var1);

    public void importData(XGettingEnum<ByteBuffer> var1);

    public PersistenceManager<Binary> persistenceManager();

    default public long store(Object instance) {
        return this.persistenceManager().store(instance);
    }

    default public long[] storeAll(Object ... instances) {
        return this.persistenceManager().storeAll(instances);
    }

    default public void storeAll(Iterable<?> instances) {
        this.persistenceManager().storeAll(instances);
    }

    default public Storer createLazyStorer() {
        return this.persistenceManager().createLazyStorer();
    }

    default public Storer createStorer() {
        return this.persistenceManager().createStorer();
    }

    default public Storer createEagerStorer() {
        return this.persistenceManager().createEagerStorer();
    }

    default public Object getObject(long objectId) {
        return this.persistenceManager().getObject(objectId);
    }

    public static StorageConnection New(PersistenceManager<Binary> persistenceManager, StorageRequestAcceptor connectionRequestAcceptor) {
        return new Default((PersistenceManager<Binary>)((PersistenceManager)X.notNull(persistenceManager)), (StorageRequestAcceptor)X.notNull((Object)connectionRequestAcceptor));
    }

    public static final class Default
    implements StorageConnection,
    Unpersistable {
        private final PersistenceManager<Binary> persistenceManager;
        private final StorageRequestAcceptor connectionRequestAcceptor;

        Default(PersistenceManager<Binary> persistenceManager, StorageRequestAcceptor connectionRequestAcceptor) {
            this.persistenceManager = persistenceManager;
            this.connectionRequestAcceptor = connectionRequestAcceptor;
        }

        @Override
        public PersistenceManager<Binary> persistenceManager() {
            return this.persistenceManager;
        }

        @Override
        public final boolean issueGarbageCollection(long nanoTimeBudget) {
            try {
                this.persistenceManager().objectRegistry().consolidate();
                return this.connectionRequestAcceptor.issueGarbageCollection(nanoTimeBudget);
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        @Override
        public final boolean issueFileCheck(long nanoTimeBudget) {
            try {
                return this.connectionRequestAcceptor.issueFileCheck(nanoTimeBudget);
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        @Override
        public final boolean issueCacheCheck(long nanoTimeBudget, StorageEntityCacheEvaluator entityEvaluator) {
            try {
                return this.connectionRequestAcceptor.issueCacheCheck(nanoTimeBudget, entityEvaluator);
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        @Override
        public final void issueFullBackup(StorageLiveFileProvider targetFileProvider, PersistenceTypeDictionaryExporter typeDictionaryExporter) {
            this.exportChannels(targetFileProvider);
            typeDictionaryExporter.exportTypeDictionary(this.persistenceManager().typeDictionary());
        }

        @Override
        public void issueTransactionsLogCleanup() {
            try {
                this.connectionRequestAcceptor.issueTransactionsLogCleanup();
            }
            catch (InterruptedException e) {
                return;
            }
        }

        @Override
        public StorageRawFileStatistics createStorageStatistics() {
            try {
                return this.connectionRequestAcceptor.createStatistics();
            }
            catch (InterruptedException e) {
                return null;
            }
        }

        @Override
        public void exportChannels(StorageLiveFileProvider fileProvider, boolean performGarbageCollection) {
            try {
                this.connectionRequestAcceptor.exportChannels(fileProvider, performGarbageCollection);
            }
            catch (InterruptedException e) {
                return;
            }
        }

        @Override
        public StorageEntityTypeExportStatistics exportTypes(StorageEntityTypeExportFileProvider exportFileProvider, Predicate<? super StorageEntityTypeHandler> isExportType) {
            try {
                return this.connectionRequestAcceptor.exportTypes(exportFileProvider, isExportType);
            }
            catch (InterruptedException e) {
                return null;
            }
        }

        @Override
        public void importFiles(XGettingEnum<AFile> importFiles) {
            try {
                this.connectionRequestAcceptor.importFiles(importFiles);
            }
            catch (InterruptedException e) {
                return;
            }
        }

        @Override
        public void importData(XGettingEnum<ByteBuffer> importData) {
            try {
                this.connectionRequestAcceptor.importData(importData);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

