/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.monitoring.MetricMonitor;
import org.eclipse.serializer.monitoring.MonitoringManager;
import org.eclipse.serializer.persistence.types.ObjectIdsSelector;
import org.eclipse.serializer.persistence.types.PersistenceLiveStorerRegistry;
import org.eclipse.serializer.reference.Referencing;
import org.eclipse.serializer.util.BufferSizeProvider;
import org.eclipse.serializer.util.BufferSizeProviderIncremental;
import org.eclipse.store.storage.monitoring.EntityCacheMonitor;
import org.eclipse.store.storage.monitoring.EntityCacheSummaryMonitor;
import org.eclipse.store.storage.types.StorageBackupHandler;
import org.eclipse.store.storage.types.StorageChannel;
import org.eclipse.store.storage.types.StorageDataFileEvaluator;
import org.eclipse.store.storage.types.StorageEntityCache;
import org.eclipse.store.storage.types.StorageEntityCacheEvaluator;
import org.eclipse.store.storage.types.StorageEntityMarkMonitor;
import org.eclipse.store.storage.types.StorageEventLogger;
import org.eclipse.store.storage.types.StorageExceptionHandler;
import org.eclipse.store.storage.types.StorageFileManager;
import org.eclipse.store.storage.types.StorageFileWriter;
import org.eclipse.store.storage.types.StorageGCZombieOidHandler;
import org.eclipse.store.storage.types.StorageHousekeepingBroker;
import org.eclipse.store.storage.types.StorageHousekeepingController;
import org.eclipse.store.storage.types.StorageInitialDataFileNumberProvider;
import org.eclipse.store.storage.types.StorageLiveFileProvider;
import org.eclipse.store.storage.types.StorageObjectIdMarkQueue;
import org.eclipse.store.storage.types.StorageOperationController;
import org.eclipse.store.storage.types.StorageRootOidSelector;
import org.eclipse.store.storage.types.StorageTaskBroker;
import org.eclipse.store.storage.types.StorageTimestampProvider;
import org.eclipse.store.storage.types.StorageTypeDictionary;
import org.eclipse.store.storage.types.StorageWriteController;

public interface StorageChannelsCreator {
    public StorageChannel[] createChannels(int var1, StorageInitialDataFileNumberProvider var2, StorageExceptionHandler var3, StorageDataFileEvaluator var4, StorageLiveFileProvider var5, StorageEntityCacheEvaluator var6, StorageTypeDictionary var7, StorageTaskBroker var8, StorageOperationController var9, StorageHousekeepingBroker var10, StorageHousekeepingController var11, StorageTimestampProvider var12, StorageWriteController var13, StorageFileWriter.Provider var14, StorageGCZombieOidHandler var15, StorageRootOidSelector.Provider var16, StorageObjectIdMarkQueue.Creator var17, StorageEntityMarkMonitor.Creator var18, StorageBackupHandler var19, StorageEventLogger var20, ObjectIdsSelector var21, Referencing<PersistenceLiveStorerRegistry> var22, boolean var23, long var24, MonitoringManager var26);

    public static final class Default
    implements StorageChannelsCreator {
        public final StorageChannel.Default[] createChannels(int channelCount, StorageInitialDataFileNumberProvider initialDataFileNumberProvider, StorageExceptionHandler exceptionHandler, StorageDataFileEvaluator dataFileEvaluator, StorageLiveFileProvider liveFileProvider, StorageEntityCacheEvaluator entityCacheEvaluator, StorageTypeDictionary typeDictionary, StorageTaskBroker taskBroker, StorageOperationController operationController, StorageHousekeepingBroker housekeepingBroker, StorageHousekeepingController housekeepingController, StorageTimestampProvider timestampProvider, StorageWriteController writeController, StorageFileWriter.Provider writerProvider, StorageGCZombieOidHandler zombieOidHandler, StorageRootOidSelector.Provider rootOidSelectorProvider, StorageObjectIdMarkQueue.Creator oidMarkQueueCreator, StorageEntityMarkMonitor.Creator entityMarkMonitorCreator, StorageBackupHandler backupHandler, StorageEventLogger eventLogger, ObjectIdsSelector liveObjectIdChecker, Referencing<PersistenceLiveStorerRegistry> refStorerRegistry, boolean switchByteOrder, long rootTypeId, MonitoringManager monitorManager) {
            int markBufferLength = 10000;
            long markingWaitTimeMs = 10L;
            int loadingBufferSize = XMemory.defaultBufferSize();
            int readingDefaultBufferSize = XMemory.defaultBufferSize();
            StorageChannel.Default[] channels = new StorageChannel.Default[channelCount];
            StorageObjectIdMarkQueue[] markQueues = new StorageObjectIdMarkQueue[channels.length];
            for (int i = 0; i < markQueues.length; ++i) {
                markQueues[i] = oidMarkQueueCreator.createOidMarkQueue(10000);
            }
            StorageEntityMarkMonitor markMonitor = entityMarkMonitorCreator.createEntityMarkMonitor(markQueues, eventLogger, refStorerRegistry);
            BufferSizeProviderIncremental loadingBufferSizeProvider = BufferSizeProviderIncremental.New((long)loadingBufferSize);
            BufferSizeProvider readingDefaultBufferSizeProvider = BufferSizeProvider.New((long)readingDefaultBufferSize);
            EntityCacheMonitor[] cacheMonitors = new EntityCacheMonitor[channelCount];
            for (int i = 0; i < channels.length; ++i) {
                StorageEntityCache.Default entityCache = new StorageEntityCache.Default(i, channels.length, entityCacheEvaluator, typeDictionary, markMonitor, zombieOidHandler, rootOidSelectorProvider.provideRootOidSelector(i), rootTypeId, markQueues[i], eventLogger, liveObjectIdChecker, 10L, 10000);
                cacheMonitors[i] = new EntityCacheMonitor(entityCache);
                monitorManager.registerMonitor((MetricMonitor)cacheMonitors[i]);
                StorageFileManager.Default fileManager = new StorageFileManager.Default(i, initialDataFileNumberProvider, timestampProvider, liveFileProvider, dataFileEvaluator, entityCache, writeController, writerProvider.provideWriter(i), readingDefaultBufferSizeProvider, backupHandler);
                entityCache.initializeStorageManager(fileManager);
                channels[i] = new StorageChannel.Default(i, exceptionHandler, taskBroker, operationController, housekeepingBroker, housekeepingController, entityCache, switchByteOrder, loadingBufferSizeProvider, fileManager, eventLogger, monitorManager);
            }
            monitorManager.registerMonitor((MetricMonitor)new EntityCacheSummaryMonitor(cacheMonitors));
            return channels;
        }
    }
}

