/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.types;

import org.eclipse.store.storage.types.StorageChannel;

public interface StorageChannelHousekeepingResult {
    public long getDuration();

    public long getStartTime();

    public boolean getResult();

    public long getBudget();

    public static StorageChannelHousekeepingResult create(long nanoTimeBudget, StorageChannel.HousekeepingTask task) {
        long startTime = System.currentTimeMillis();
        long startTimeStamp = System.nanoTime();
        boolean result = task.perform();
        long duration = System.nanoTime() - startTimeStamp;
        return new Default(nanoTimeBudget, result, startTime, duration);
    }

    public static final class Default
    implements StorageChannelHousekeepingResult {
        private long nanoTimeBudget;
        private final boolean result;
        private final long startTime;
        private final long duration;

        private Default(long nanoTimeBudget, boolean result, long startTime, long duration) {
            this.nanoTimeBudget = nanoTimeBudget;
            this.result = result;
            this.startTime = startTime;
            this.duration = duration;
        }

        @Override
        public long getBudget() {
            return this.nanoTimeBudget;
        }

        @Override
        public boolean getResult() {
            return this.result;
        }

        @Override
        public long getStartTime() {
            return this.startTime;
        }

        @Override
        public long getDuration() {
            return this.duration;
        }
    }
}

