/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.publishing.detail;

import com.schneide.werp.domain.publishing.detail.FontStyle;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Item {
    private final Optional<String> title;
    private final String value;
    private final FontStyle style;

    public static Item just(String value) {
        return new Item(null, value);
    }

    public Item(String title, Supplier<String> value) {
        this(title, value.get());
    }

    public Item(String title, String value) {
        this(Optional.ofNullable(title), value, FontStyle.normal);
    }

    private Item(Optional<String> title, String value, FontStyle style) {
        this.title = title;
        this.value = value;
        this.style = style;
    }

    public FontStyle style() {
        return this.style;
    }

    public Item withStyle(FontStyle newStyle) {
        return new Item(this.title, this.value, newStyle);
    }

    public Stream<String> asParts() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.title.isPresent()) {
            result.add(Item.asTitle(this.title.get()));
        }
        result.add(this.value);
        return result.stream();
    }

    public static String asTitle(String titleText) {
        if (titleText.trim().isEmpty() || "=".equals(titleText)) {
            return titleText;
        }
        return titleText + ":";
    }

    public static Item empty() {
        return new Item("", "");
    }
}

