/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.publishing;

import com.schneide.werp.domain.publishing.ReportEntry;
import com.schneide.werp.domain.publishing.detail.FontStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReportTable
extends ReportEntry {
    private final List<String> columnTitles;
    private final List<Row> rows;
    private final List<ColumnAlignment> alignments;

    public ReportTable(String ... columnTitles) {
        this.columnTitles = Arrays.asList(columnTitles);
        this.rows = new ArrayList<Row>();
        this.alignments = new ArrayList<ColumnAlignment>(Stream.generate(() -> ColumnAlignment.right).limit(columnTitles.length).collect(Collectors.toList()));
    }

    public void add(Row row) {
        if (row.length() != this.columnTitles.size()) {
            throw new IllegalArgumentException("Cannot add table row with different length: " + row.length() + " instead of required " + this.columnTitles.size());
        }
        this.rows.add(row);
    }

    public void changeAlignmentOf(int columnIndex, ColumnAlignment newAlignment) {
        this.alignments.set(columnIndex, newAlignment);
    }

    public List<Cell> titles() {
        return this.columnTitles.stream().map(t -> new Cell((String)t, FontStyle.emphasized)).collect(Collectors.toList());
    }

    public List<ColumnAlignment> alignments() {
        return new ArrayList<ColumnAlignment>(this.alignments);
    }

    public List<List<Cell>> content() {
        ArrayList<List<Cell>> result = new ArrayList<List<Cell>>();
        this.rows.forEach(row -> {
            List rowContent = row.content().collect(Collectors.toList());
            result.add(rowContent);
        });
        return result;
    }

    public static class Row {
        private final List<Cell> content = new ArrayList<Cell>();

        public void addEmpty() {
            this.add(Optional.empty());
        }

        public void add(Supplier<String> cellContent) {
            this.add(cellContent.get());
        }

        public void add(String cellContent) {
            this.add(Optional.ofNullable(cellContent));
        }

        public void addEmphasized(String cellContent) {
            this.add(Optional.ofNullable(cellContent), FontStyle.emphasized);
        }

        public void add(Optional<String> cellContent) {
            this.add(cellContent, FontStyle.normal);
        }

        public void add(String cellContent, FontStyle style) {
            this.add(Optional.of(cellContent), style);
        }

        public void add(Optional<String> cellContent, FontStyle style) {
            this.content.add(new Cell(cellContent.orElse(""), style));
        }

        public Stream<Cell> content() {
            return this.content.stream();
        }

        public int length() {
            return this.content.size();
        }
    }

    public static class Cell {
        private final String content;
        private final FontStyle style;

        private Cell(String content, FontStyle style) {
            this.content = content;
            this.style = style;
        }

        public String text() {
            return this.content;
        }

        public FontStyle style() {
            return this.style;
        }
    }

    public static enum ColumnAlignment {
        left,
        centered,
        right;

    }
}

