/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.publishing;

import com.schneide.werp.domain.publishing.LineSection;
import com.schneide.werp.domain.publishing.ReportEntry;
import com.schneide.werp.domain.publishing.detail.FontStyle;
import com.schneide.werp.domain.publishing.detail.Item;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReportLine
extends ReportEntry {
    private final List<LineSection> sections = new ArrayList<LineSection>();
    private final boolean fitToPrevious;

    public ReportLine() {
        this(false);
    }

    public ReportLine(boolean fitToPrevious) {
        this.fitToPrevious = fitToPrevious;
    }

    public void add(LineSection section) {
        this.sections.add(section);
    }

    public boolean hasContent() {
        return !this.sections.isEmpty();
    }

    public void changeLineHeightTo(double newLineHeight) {
        this.sections.forEach(ls -> ls.changeLineHeightTo(newLineHeight));
    }

    public Stream<ReportLine> expanded() {
        if (!this.isMultiline()) {
            return Stream.of(this);
        }
        ArrayList<ReportLine> result = new ArrayList<ReportLine>();
        ReportLine current = new ReportLine(this.fitToPrevious);
        for (LineSection each : this.sections) {
            String[] lines;
            if (!each.isMultiLine()) {
                current.add(each);
                continue;
            }
            for (String line : lines = each.text().split("\\r?\\n")) {
                current.add(each.withText(line));
                result.add(current);
                current = new ReportLine(this.fitToPrevious);
            }
        }
        result.add(current);
        return result.stream().filter(ReportLine::hasContent);
    }

    public boolean wantsToFitToPreviousGrouping() {
        return this.fitToPrevious;
    }

    public boolean needsGrouping() {
        return this.sections.size() > 1 && !this.isMultiline();
    }

    public boolean isMultiline() {
        return this.sections.stream().filter(LineSection::isMultiLine).findAny().isPresent();
    }

    public Stream<LineSection> sections() {
        return this.sections.stream();
    }

    public ReportLine fittedToPrevious() {
        ReportLine result = new ReportLine(true);
        this.sections.forEach(result::add);
        return result;
    }

    public ReportLine withStyle(FontStyle newStyle) {
        ArrayList<LineSection> workedOn = new ArrayList<LineSection>(this.sections);
        this.sections.clear();
        for (LineSection each : workedOn) {
            this.sections.add(each.withStyle(newStyle));
        }
        return this;
    }

    public static ReportLine forItem(Item ... items) {
        ReportLine result = new ReportLine();
        for (Item each : items) {
            each.asParts().map(LineSection::new).map(section -> section.withStyle(each.style())).forEach(result::add);
        }
        return result;
    }

    public static ReportLine forParts(String ... sections) {
        return ReportLine.forParts(Arrays.asList(sections));
    }

    private static ReportLine forParts(Iterable<String> sections) {
        ReportLine result = new ReportLine();
        for (String each : sections) {
            result.add(new LineSection(each));
        }
        return result;
    }

    public String toString() {
        return "ReportLine [sections=" + String.valueOf(this.sections) + "]";
    }

    public static ReportEntry empty(int columns) {
        return ReportLine.forParts(Stream.generate(() -> "").limit(columns).collect(Collectors.toList()));
    }
}

