/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.publishing;

import com.schneide.werp.domain.publishing.detail.FontStyle;

public class LineSection {
    public static final LineSection empty = new LineSection("", FontStyle.normal);
    private final FontStyle style;
    private final String text;
    private final boolean strictMultiline;
    private double lineHeight;

    public LineSection(String text) {
        this(text, FontStyle.normal);
    }

    public LineSection(String text, FontStyle style) {
        this(text, style, false);
    }

    private LineSection(String text, FontStyle style, boolean strictMultiline) {
        this.style = style;
        this.text = text;
        this.strictMultiline = strictMultiline;
        this.lineHeight = 1.0;
    }

    public LineSection strictlyMultiline() {
        return new LineSection(this.text, this.style, true);
    }

    public LineSection withStyle(FontStyle newStyle) {
        return new LineSection(this.text, newStyle, this.strictMultiline);
    }

    public LineSection withText(String newText) {
        return new LineSection(newText, this.style, this.strictMultiline);
    }

    public boolean isMultiLine() {
        return this.strictMultiline || this.text.contains("\n");
    }

    public FontStyle style() {
        return this.style;
    }

    public String text() {
        return this.text;
    }

    public double lineHeight() {
        return this.lineHeight;
    }

    public void changeLineHeightTo(double newLineHeight) {
        this.lineHeight = newLineHeight;
    }

    public String toString() {
        return "LineSection [text=" + this.text + ", style=" + String.valueOf((Object)this.style) + "]";
    }
}

