/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.material;

import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.parsing.StringChunker;
import java.util.Optional;

public class Blechabmessung {
    private final Blechdicke dicke;
    private final int breite;
    private final int l\u00e4nge;

    public static boolean kommtInFrageF\u00fcr(String text) {
        StringChunker parts = Blechabmessung.teileVon(text);
        return 3 == parts.getAllChunksAsArray().length;
    }

    public static Optional<Blechabmessung> aus(String text) {
        StringChunker parts = Blechabmessung.teileVon(text);
        Blechdicke dicke = new Blechdicke(parts.next().trim());
        try {
            int breite = Integer.parseInt(parts.next().trim());
            int l\u00e4nge = Integer.parseInt(parts.next().trim());
            return Optional.of(new Blechabmessung(dicke, breite, l\u00e4nge));
        }
        catch (NumberFormatException e) {
            LoggedObject.getStaticLogger().error((Object)("Fehlerhafte Blech-Abmessung: " + text));
            return Optional.empty();
        }
    }

    private static StringChunker teileVon(String text) {
        StringChunker parts = new StringChunker(text, "x-");
        parts.setCanReturnNull(false);
        return parts;
    }

    public Blechabmessung(Blechdicke dicke, int breite, int l\u00e4nge) {
        this.dicke = dicke;
        this.breite = breite;
        this.l\u00e4nge = l\u00e4nge;
    }

    public Blechdicke dicke() {
        return this.dicke;
    }

    public int breite() {
        return this.breite;
    }

    public int l\u00e4nge() {
        return this.l\u00e4nge;
    }

    public record Blechdicke(String bezeichnung) {
    }
}

