/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.format.json;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import java.io.IOException;
import java.util.Optional;

public final class JsonMapper {
    private JsonMapper() {
    }

    public static <TYPE> Optional<? extends TYPE> ladeAus(VirtualFile jsonDatei, Class<TYPE> typ, String beschreibung) {
        try {
            Object result = JsonMapper.mapper().readValue(jsonDatei.allContent(), typ);
            return Optional.of(result);
        }
        catch (IOException | RuntimeException e) {
            LoggedObject.getStaticLogger().error((Object)("Konnte " + beschreibung + " aus " + String.valueOf(jsonDatei) + " nicht lesen."), (Throwable)e);
            return Optional.empty();
        }
    }

    public static void schreibeIn(VirtualFile jsonDatei, Object wert, String beschreibung) {
        try {
            String json = JsonMapper.mapper().writeValueAsString(wert);
            if (!jsonDatei.exists()) {
                jsonDatei.createAsFile();
            }
            jsonDatei.setContentTo(json);
        }
        catch (IOException | RuntimeException e) {
            LoggedObject.getStaticLogger().error((Object)("Konnte " + beschreibung + " nicht in " + String.valueOf(jsonDatei) + " schreiben."), (Throwable)e);
        }
    }

    private static ObjectMapper mapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new Jdk8Module());
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        mapper.setDefaultPrettyPrinter((PrettyPrinter)prettyPrinter);
        return mapper;
    }
}

