/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.erf\u00fcllung.zusammenfassung;

import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsartikel;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import com.schneide.werp.domain.erf\u00fcllung.zusammenfassung.Laufzettel;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class Vorzugslaufzettel
extends LoggedObject
implements Laufzettel {
    private final Produktionsnummer produktion;
    private final Arbeitsschritt t\u00e4tigkeit;
    private final List<Arbeitsauftrag> sortierteVorziehbareAuftr\u00e4ge;

    public Vorzugslaufzettel(Produktionsnummer produktion, Arbeitsschritt t\u00e4tigkeit, List<Arbeitsauftrag> vorziehbareAuftr\u00e4ge) {
        this.produktion = produktion;
        this.t\u00e4tigkeit = t\u00e4tigkeit;
        this.sortierteVorziehbareAuftr\u00e4ge = new ArrayList<Arbeitsauftrag>(vorziehbareAuftr\u00e4ge);
        Comparator<Produktionsartikel> artikelsortierung = Produktionsartikel.alphabetischNachArtikelnummer();
        Collections.sort(this.sortierteVorziehbareAuftr\u00e4ge, (left, right) -> artikelsortierung.compare(left.f\u00fcrArtikel(), right.f\u00fcrArtikel()));
    }

    @Override
    public String identifier() {
        return "Vorzug-" + this.produktion.alsText() + "-" + this.t\u00e4tigkeit.nummer();
    }

    @Override
    public String titel() {
        return "Vorgezogene " + this.t\u00e4tigkeit.nummerMitT\u00e4tigkeit() + " f\u00fcr " + this.produktion.alsText();
    }

    @Override
    public Iterable<Arbeitsauftrag> schritte() {
        return this.sortierteVorziehbareAuftr\u00e4ge;
    }

    @Override
    public Iterable<? extends Laufzettel> nachfolger() {
        return Collections.emptyList();
    }

    @Override
    public Iterable<? extends Laufzettel> vorg\u00e4nger() {
        return Collections.emptyList();
    }

    public static Iterable<Vorzugslaufzettel> erstellenF\u00fcr(Produktionsnummer produktion, Iterable<Arbeitsauftrag> arbeitsauftr\u00e4ge) {
        ArrayList<Vorzugslaufzettel> result = new ArrayList<Vorzugslaufzettel>();
        HashMap<Arbeitsschritt, List> vorziehbarNachT\u00e4tigkeit = new HashMap<Arbeitsschritt, List>();
        for (Arbeitsauftrag each : arbeitsauftr\u00e4ge) {
            if (!each.t\u00e4tigkeit().istVorziehbar()) continue;
            vorziehbarNachT\u00e4tigkeit.compute(each.t\u00e4tigkeit(), (as, bestehendeListe) -> {
                List liste = null == bestehendeListe ? new ArrayList() : bestehendeListe;
                liste.add(each);
                return liste;
            });
        }
        LoggedObject.getStaticLogger().debug((Object)("Vorziehbare Arbeitsauftr\u00e4ge: " + vorziehbarNachT\u00e4tigkeit.size()));
        LoggedObject.getStaticLogger().debug((Object)("Unterschiedliche Arbeitsschritte: " + vorziehbarNachT\u00e4tigkeit.keySet().size()));
        vorziehbarNachT\u00e4tigkeit.forEach((t\u00e4tigkeit, auftr\u00e4ge) -> {
            Vorzugslaufzettel vorzug = new Vorzugslaufzettel(produktion, (Arbeitsschritt)t\u00e4tigkeit, (List<Arbeitsauftrag>)auftr\u00e4ge);
            result.add(vorzug);
        });
        return result;
    }
}

