/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.erf\u00fcllung.weg;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Erf\u00fcllungsschritt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class Erf\u00fcllungsweg
extends LoggedObject {
    public static final String bezeichnung = "Erf\u00fcllungsweg";
    public static final String keiner = "";
    public static final String neukonstruktion = "Erf\u00fcllungsweg_SO_10";
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="beschaffungskategorie")
    private final String beschaffungskategorie;
    @JsonProperty(value="langschl\u00fcssel")
    private final String langschl\u00fcssel;
    @JsonProperty(value="beschreibung")
    private final String beschreibung;
    @JsonProperty(value="erf\u00fcllungsschritte")
    private final List<Erf\u00fcllungsschritt> ablauf;

    private Erf\u00fcllungsweg() {
        this(null, null, null, null, Collections.emptyList());
    }

    public Erf\u00fcllungsweg(String identifier, String beschaffungskategorie, String langschl\u00fcssel, String beschreibung, Iterable<Erf\u00fcllungsschritt> ablauf) {
        this.identifier = identifier;
        this.beschaffungskategorie = beschaffungskategorie;
        this.langschl\u00fcssel = langschl\u00fcssel;
        this.beschreibung = beschreibung;
        this.ablauf = new ArrayList<Erf\u00fcllungsschritt>();
        ablauf.forEach(this.ablauf::add);
    }

    public String identifier() {
        return this.identifier;
    }

    public String beschreibung() {
        return this.beschreibung;
    }

    public String beschaffungskategorie() {
        return this.beschaffungskategorie;
    }

    public String langschl\u00fcssel() {
        return this.langschl\u00fcssel;
    }

    public void arbeitsschritteNormalisierenMit(ArbeitsschrittRepository bekannteSchritte) {
        ArrayList<Erf\u00fcllungsschritt> normalisiert = new ArrayList<Erf\u00fcllungsschritt>();
        for (Erf\u00fcllungsschritt each : this.ablauf) {
            normalisiert.add(each.normalisiereMit(bekannteSchritte));
        }
        this.ablauf.clear();
        this.ablauf.addAll(normalisiert);
    }

    public Iterable<Erf\u00fcllungsschritt> inSchritten() {
        return this.ablauf;
    }

    public static Comparator<Erf\u00fcllungsweg> alphabetischNachIdentifier() {
        return (links, rechts) -> links.identifier().compareTo(rechts.identifier());
    }

    public Iterable<String> schritteAlsIdentifier() {
        return this.ablauf.stream().map(es -> es.arbeitsschrittIdentifier()).collect(Collectors.toList());
    }
}

