/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste;

import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.angebot.Angebotsdaten;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.artikel.ArtikelRepository;
import com.schneide.werp.domain.artikel.Artikelnummer;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fccklisteneintrag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class St\u00fcckliste<SE extends St\u00fccklisteneintrag> {
    public static final St\u00fcckliste<St\u00fccklisteneintrag> leer = new St\u00fcckliste();
    private final List<SE> eintr\u00e4ge = new ArrayList<SE>();

    public void f\u00fcgeEin(SE neuer) {
        this.eintr\u00e4ge.add(neuer);
    }

    public Iterable<SE> eintr\u00e4ge() {
        return List.copyOf(this.eintr\u00e4ge);
    }

    public int size() {
        return this.eintr\u00e4ge.size();
    }

    public static <SE extends St\u00fccklisteneintrag> EingeleseneSt\u00fcckliste<SE> aus(Iterable<Angebotsdaten.Angebotsposition> angebotspositionen, ArtikelRepository repository, St\u00fccklisteneintragerstellung<SE> erstellung) {
        St\u00fcckliste<SE> result = new St\u00fcckliste<SE>();
        ArrayList<NichtZugeordneterArtikel> nichtZugeordnet = new ArrayList<NichtZugeordneterArtikel>();
        int aktuellePosition = 1;
        for (Angebotsdaten.Angebotsposition each : angebotspositionen) {
            Artikelnummer artikel = each.artikelnummer().alsArtikelnummer();
            LoggedObject.getStaticLogger().debug((Object)("Importiere Angebotsposition mit Artikelnummer " + artikel.nummer()));
            Optional<Artikel<?>> maybeMitAktuellerRevision = repository.aktuelleRevisionF\u00fcr(artikel);
            if (maybeMitAktuellerRevision.isEmpty()) {
                nichtZugeordnet.add(new NichtZugeordneterArtikel(each, artikel));
                LoggedObject.getStaticLogger().debug((Object)("Artikel NICHT zugeordnet: " + artikel.nummer()));
                continue;
            }
            LoggedObject.getStaticLogger().debug((Object)("Artikel zugeordnet: " + String.valueOf(maybeMitAktuellerRevision)));
            Artikel<?> mitAktuellerRevision = maybeMitAktuellerRevision.get();
            SE neu = erstellung.erstelleAus(aktuellePosition, each.anzahl(), mitAktuellerRevision);
            LoggedObject.getStaticLogger().debug((Object)("St\u00fccklisteneintrag hinzugef\u00fcgt: " + ((St\u00fccklisteneintrag)neu).anzahl() + "x " + String.valueOf(((St\u00fccklisteneintrag)neu).artikelreferenz())));
            result.f\u00fcgeEin(neu);
            ++aktuellePosition;
        }
        return new EingeleseneSt\u00fcckliste<SE>(result, nichtZugeordnet);
    }

    public record NichtZugeordneterArtikel(Angebotsdaten.Angebotsposition position, Artikelnummer nichtZugeordnet) {
    }

    public static interface St\u00fccklisteneintragerstellung<SE extends St\u00fccklisteneintrag> {
        public SE erstelleAus(int var1, int var2, Artikel<?> var3);
    }

    public record EingeleseneSt\u00fcckliste<SE extends St\u00fccklisteneintrag>(St\u00fcckliste<SE> st\u00fcckliste, Iterable<NichtZugeordneterArtikel> nichtZugeordneteArtikel) {
    }
}

