/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.erf\u00fcllung.schritt;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fccklisteneintrag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public class Erf\u00fcllungsschritt
extends LoggedObject {
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="t\u00e4tigkeit")
    private final String arbeitsschritt;
    @JsonProperty(value="voraussetzungen")
    private final List<String> voraussetzungen;

    private Erf\u00fcllungsschritt() {
        this(null, (String)null);
    }

    public Erf\u00fcllungsschritt(String identifier, Arbeitsschritt t\u00e4tigkeit) {
        this(identifier, t\u00e4tigkeit.nummer());
    }

    protected Erf\u00fcllungsschritt(String identifier, String arbeitsschrittIdentifier) {
        this.identifier = identifier;
        this.arbeitsschritt = arbeitsschrittIdentifier;
        this.voraussetzungen = new ArrayList<String>();
    }

    public static Erf\u00fcllungsschritt f\u00fcrSt\u00fccklisteneintrag(St\u00fccklisteneintrag eintrag) {
        Erf\u00fcllungsschritt result = new Erf\u00fcllungsschritt(Arbeitsschritt.ausSt\u00fcckliste.t\u00e4tigkeit() + "-" + eintrag.position(), Arbeitsschritt.ausSt\u00fcckliste);
        return result;
    }

    public void h\u00e4ngtAbVon(Erf\u00fcllungsschritt voraussetzung) {
        this.h\u00e4ngtAbVon(voraussetzung.identifier());
    }

    public void h\u00e4ngtAbVon(String voraussetzungsidentifier) {
        this.voraussetzungen.add(voraussetzungsidentifier);
    }

    public String identifier() {
        return this.identifier;
    }

    public String arbeitsschrittIdentifier() {
        return this.arbeitsschritt;
    }

    public Erf\u00fcllungsschritt normalisiereMit(ArbeitsschrittRepository bekannteSchritte) {
        Optional<Arbeitsschritt> maybeNormalisiert = bekannteSchritte.f\u00fcrIdentifierOderT\u00e4tigkeit(this.arbeitsschritt);
        if (maybeNormalisiert.isEmpty()) {
            this.getLogger().warn((Object)("Kann den Arbeitsschritt " + this.arbeitsschritt + " nicht aufl\u00f6sen."));
            return this;
        }
        Erf\u00fcllungsschritt result = new Erf\u00fcllungsschritt(this.identifier, maybeNormalisiert.get().nummer());
        this.voraussetzungen.forEach(result::h\u00e4ngtAbVon);
        return result;
    }

    public Optional<Arbeitsschritt> getArbeitsschrittAus(ArbeitsschrittRepository bekannteSchritte) {
        return bekannteSchritte.f\u00fcrIdentifierOderT\u00e4tigkeit(this.arbeitsschritt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> voraussetzungen() {
        List<String> list = this.voraussetzungen;
        synchronized (list) {
            return List.copyOf(this.voraussetzungen);
        }
    }

    public Iterable<Erf\u00fcllungsschritt> voraussetzungen(Function<String, Optional<Erf\u00fcllungsschritt>> bekannteSchritte) {
        return Erf\u00fcllungsschritt.aufl\u00f6senF\u00fcr(this.voraussetzungen, bekannteSchritte, "als Voraussetzung f\u00fcr " + this.identifier);
    }

    public static Iterable<Erf\u00fcllungsschritt> aufl\u00f6senF\u00fcr(Iterable<String> schritte, Function<String, Optional<Erf\u00fcllungsschritt>> bekannteSchritte, String beschreibung) {
        ArrayList<Erf\u00fcllungsschritt> result = new ArrayList<Erf\u00fcllungsschritt>();
        for (String each : schritte) {
            Optional<Erf\u00fcllungsschritt> maybeSchritt = bekannteSchritte.apply(each);
            maybeSchritt.ifPresentOrElse(result::add, () -> LoggedObject.getStaticLogger().warn((Object)("Kann den Erf\u00fcllungsschritt " + each + " nicht " + beschreibung + " aufl\u00f6sen.")));
        }
        return result;
    }

    public static Iterable<Erf\u00fcllungsschritt> direkteSchrittfolgeAus(Iterable<Arbeitsschritt> schrittfolge, char ersteSpalte, String zeile) {
        ArrayList<Erf\u00fcllungsschritt> result = new ArrayList<Erf\u00fcllungsschritt>();
        Optional<Erf\u00fcllungsschritt> vorg\u00e4nger = Optional.empty();
        int index = 0;
        for (Arbeitsschritt schritt : schrittfolge) {
            char aktuell = (char)(ersteSpalte + index);
            Erf\u00fcllungsschritt erf\u00fcllung = new Erf\u00fcllungsschritt(String.valueOf(aktuell) + zeile, schritt);
            vorg\u00e4nger.ifPresent(erf\u00fcllung::h\u00e4ngtAbVon);
            result.add(erf\u00fcllung);
            ++index;
            vorg\u00e4nger = Optional.of(erf\u00fcllung);
        }
        return result;
    }

    public static Erf\u00fcllungsschritt ohneVoraussetzungenF\u00fcr(String arbeitsschrittIdentifier) {
        return new Erf\u00fcllungsschritt(UUID.randomUUID().toString(), arbeitsschrittIdentifier);
    }
}

