/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.erf\u00fcllung.schritt;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;

public class Arbeitsschritt {
    public static final String bezeichnung = "Arbeitsschritt";
    @JsonProperty(value="Nummer")
    private final String nummer;
    @JsonProperty(value="T\u00e4tigkeit")
    private final String t\u00e4tigkeit;
    @JsonProperty(value="Synonyme")
    private final Iterable<String> synonyme;
    @JsonProperty(value="Ist_Vorziehbar")
    private final boolean istVorziehbar;
    @JsonProperty(value="Beschreibung")
    private final String beschreibung;
    @JsonProperty(value="Bedingung")
    private final Optional<Bedingung> bedingung;
    public static final Arbeitsschritt keiner = Arbeitsschritt.nurPlatzhalter("");
    public static final Arbeitsschritt ausSt\u00fcckliste = Arbeitsschritt.nurPlatzhalter("St\u00fcckliste");

    private Arbeitsschritt() {
        this(null, null, Collections.emptyList(), false, null, Optional.empty());
    }

    public Arbeitsschritt(String nummer, String t\u00e4tigkeit, Iterable<String> synonyme, boolean istVorziehbar, String beschreibung, Optional<Bedingung> bedingung) {
        this.nummer = nummer;
        this.t\u00e4tigkeit = t\u00e4tigkeit;
        this.synonyme = synonyme;
        this.istVorziehbar = istVorziehbar;
        this.beschreibung = beschreibung;
        this.bedingung = bedingung;
    }

    private static Arbeitsschritt nurPlatzhalter(String t\u00e4tigkeit) {
        return new Arbeitsschritt("", t\u00e4tigkeit, (Iterable)Collections.emptyList(), false, "", Optional.empty()){

            @Override
            public boolean istPlatzhalter() {
                return true;
            }
        };
    }

    @JsonIgnore
    public boolean istPlatzhalter() {
        return false;
    }

    public String bedingungsbeschreibung() {
        return this.bedingung.map(b -> b.eigenschaft() + "=" + b.wert()).orElse("");
    }

    public boolean erf\u00fclltBedingungF\u00fcr(Map<String, String> eigenschaften) {
        return this.bedingung.map(b -> {
            Optional<String> verglichenerWert = Optional.ofNullable((String)eigenschaften.get(b.eigenschaft()));
            return verglichenerWert.filter(gw -> gw.equals(b.wert())).isPresent();
        }).orElse(true);
    }

    @JsonIgnore
    public boolean istVorziehbar() {
        return this.istVorziehbar;
    }

    public String nummer() {
        return this.nummer;
    }

    public String t\u00e4tigkeit() {
        return this.t\u00e4tigkeit;
    }

    public String nummerMitT\u00e4tigkeit() {
        return "(" + this.nummer() + ") " + this.t\u00e4tigkeit();
    }

    public String beschreibung() {
        if (this.beschreibung == null || this.beschreibung.isBlank()) {
            return this.t\u00e4tigkeit();
        }
        return this.beschreibung;
    }

    public boolean zugeordnetZu(String angefragteT\u00e4tigkeit) {
        if (this.t\u00e4tigkeit.equals(angefragteT\u00e4tigkeit)) {
            return true;
        }
        for (String each : this.synonyme) {
            if (!each.equals(angefragteT\u00e4tigkeit)) continue;
            return true;
        }
        return false;
    }

    public static Comparator<Arbeitsschritt> alphabetischNachNummer() {
        return (a0, a1) -> a0.nummer().compareTo(a1.nummer());
    }

    public String toString() {
        String synonymtext = IterableUtil.isEmpty(this.synonyme) ? "" : " (Synonyme: " + String.join((CharSequence)",", this.synonyme) + ")";
        return this.t\u00e4tigkeit + synonymtext + ": " + this.beschreibung;
    }

    public static class Bedingung {
        @JsonProperty(value="Eigenschaft")
        private final String eigenschaft;
        @JsonProperty(value="Wert")
        private final String wert;

        private Bedingung() {
            this(null, null);
        }

        public Bedingung(String eigenschaft, String wert) {
            this.eigenschaft = eigenschaft;
            this.wert = wert;
        }

        public String eigenschaft() {
            return this.eigenschaft;
        }

        public String wert() {
            return this.wert;
        }
    }
}

