/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.erf\u00fcllung.produktion;

import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsartikel;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionseigenschaften;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionskoordinate;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionslisteneintrag;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fccklistenbehaftet;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fccklisteneintrag;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import com.schneide.werp.domain.projekt.Projekt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public class Produktionsliste
extends LoggedObject {
    private final Produktionsnummer nummer;
    private final List<Produktionslisteneintrag> hauptbaugruppen;

    public static Produktionsliste f\u00fcr(Projekt projekt) {
        Produktionsnummer nummer = projekt.produktionsnummer();
        Produktionsliste result = new Produktionsliste(nummer);
        result.mit(Produktionsliste.f\u00fcrUntergeordnet(nummer, Optional.empty(), projekt, projekt));
        return result;
    }

    public static Produktionsliste f\u00fcr(Artikel<?> artikel, Produktionseigenschaften eigenschaften) {
        Produktionsnummer nummer = new Produktionsnummer(artikel.bezeichnung());
        Produktionsliste result = new Produktionsliste(nummer);
        Produktionsartikel zuProduzieren = new Produktionsartikel(new Produktionskoordinate(nummer, List.of(Integer.valueOf(1))), artikel);
        Produktionslisteneintrag selbst = new Produktionslisteneintrag(nummer, Optional.empty(), 1, 1, zuProduzieren);
        result.mit(List.of(selbst));
        Produktionsliste.f\u00fcrUntergeordnet(nummer, Optional.of(selbst), zuProduzieren, eigenschaften);
        return result;
    }

    private static List<Produktionslisteneintrag> f\u00fcrUntergeordnet(Produktionsnummer produktion, Optional<Produktionslisteneintrag> \u00fcbergeordnet, St\u00fccklistenbehaftet aktuell, Produktionseigenschaften eigenschaften) {
        ArrayList<Produktionslisteneintrag> result = new ArrayList<Produktionslisteneintrag>();
        for (St\u00fccklisteneintrag st\u00fccklisteneintrag : aktuell.st\u00fccklisteneintr\u00e4ge()) {
            Optional<Artikel<?>> maybeArtikel = st\u00fccklisteneintrag.artikel();
            if (maybeArtikel.isEmpty()) {
                LoggedObject.getStaticLogger().error((Object)("Ein Artikel aus der St\u00fcckliste kann nicht aufgel\u00f6st werden: " + st\u00fccklisteneintrag.artikelreferenz().artikelnummerMitRevisionAlsAnzeigetext()));
                continue;
            }
            Artikel<?> artikel = maybeArtikel.get();
            ArrayList<Integer> positionen = new ArrayList<Integer>();
            \u00fcbergeordnet.map(Produktionslisteneintrag::koordinate).map(Produktionskoordinate::alsZahlenfolge).ifPresent(p -> p.forEach(positionen::add));
            positionen.add(st\u00fccklisteneintrag.position());
            Produktionskoordinate koordinate = new Produktionskoordinate(produktion, positionen);
            Produktionsartikel zuProduzieren = new Produktionsartikel(koordinate, artikel);
            Produktionslisteneintrag eintrag = new Produktionslisteneintrag(produktion, \u00fcbergeordnet, st\u00fccklisteneintrag.position(), st\u00fccklisteneintrag.anzahl(), zuProduzieren);
            Produktionsliste.f\u00fcrUntergeordnet(produktion, Optional.of(eintrag), artikel, eigenschaften);
            result.add(eintrag);
        }
        return result;
    }

    protected Produktionsliste(Produktionsnummer nummer) {
        this.nummer = nummer;
        this.hauptbaugruppen = new ArrayList<Produktionslisteneintrag>();
    }

    public void eachDepthFirst(Consumer<Produktionslisteneintrag> aktion) {
        for (Produktionslisteneintrag each : this.hauptbaugruppen) {
            each.eachDepthFirst(aktion);
        }
    }

    public void eachHierarchically(Consumer<Produktionslisteneintrag> aktion) {
        for (Produktionslisteneintrag each : this.hauptbaugruppen) {
            each.eachHierarchically(aktion);
        }
    }

    protected void mit(List<Produktionslisteneintrag> eintr\u00e4gen) {
        this.hauptbaugruppen.addAll(eintr\u00e4gen);
    }

    public Produktionsnummer nummer() {
        return this.nummer;
    }

    public Iterable<Produktionslisteneintrag> hauptbaugruppen() {
        return this.hauptbaugruppen;
    }

    public Iterable<Produktionslisteneintrag> hierarchieAlsListe() {
        ArrayList<Produktionslisteneintrag> result = new ArrayList<Produktionslisteneintrag>();
        this.eachHierarchically(result::add);
        return result;
    }

    public Map<Produktionslisteneintrag, List<Arbeitsauftrag>> zuordnenVon(Iterable<Arbeitsauftrag> auftr\u00e4ge) {
        HashMap<Produktionslisteneintrag, List<Arbeitsauftrag>> result = new HashMap<Produktionslisteneintrag, List<Arbeitsauftrag>>();
        HashMap<Produktionskoordinate, Produktionslisteneintrag> koordinate2Eintrag = new HashMap<Produktionskoordinate, Produktionslisteneintrag>();
        for (Produktionslisteneintrag produktionslisteneintrag : this.hierarchieAlsListe()) {
            result.put(produktionslisteneintrag, new ArrayList());
            koordinate2Eintrag.put(produktionslisteneintrag.koordinate(), produktionslisteneintrag);
        }
        for (Arbeitsauftrag arbeitsauftrag : auftr\u00e4ge) {
            Optional.ofNullable((Produktionslisteneintrag)koordinate2Eintrag.get(arbeitsauftrag.listenkoordinate())).ifPresentOrElse(ple -> ((List)result.get(ple)).add(arbeitsauftrag), () -> this.getLogger().error((Object)("Kann den Arbeitsauftrag nicht einem Produktionslisteneintrag zuordnen: " + arbeitsauftrag.identifikation().alsText())));
        }
        return result;
    }
}

