/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.erf\u00fcllung.produktion;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.artikel.ArtikelRepository;
import com.schneide.werp.domain.artikel.Artikeleigenschaft;
import com.schneide.werp.domain.artikel.Artikelreferenz;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionskoordinate;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionslisteneintrag;
import com.schneide.werp.domain.erf\u00fcllung.schritt.AngewendeterErf\u00fcllungsschritt;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Erf\u00fcllungsschritt;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fccklistenbehaftet;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fccklisteneintrag;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungsweg;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungswegRepository;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Produktionsartikel
extends LoggedObject
implements St\u00fccklistenbehaftet {
    public static final String bezeichnung = "Produktionsartikel";
    private final Produktionskoordinate koordinate;
    private final Artikel<?> vorlage;
    private final Map<String, String> eigenschaften;

    public Produktionsartikel(Produktionskoordinate koordinate, Artikel<?> vorlage) {
        this.koordinate = koordinate;
        this.vorlage = vorlage;
        this.eigenschaften = new HashMap<String, String>();
    }

    public Iterable<AngewendeterErf\u00fcllungsschritt> erf\u00fcllungswegAus(Produktionslisteneintrag passendeProduktion, ArtikelRepository alleArtikel, Erf\u00fcllungswegRepository erf\u00fcllungswege, ArbeitsschrittRepository arbeitsschritte) {
        HashMap position2Eintrag = new HashMap();
        passendeProduktion.untergeordnet().forEach(ple -> position2Eintrag.put(ple.position(), ple));
        Optional<Erf\u00fcllungsweg> maybeErf\u00fcllungsweg = erf\u00fcllungswege.f\u00fcrIdentifierOderLangschl\u00fcssel(this.vorlage.erf\u00fcllungsweg());
        if (maybeErf\u00fcllungsweg.isEmpty()) {
            return Collections.emptyList();
        }
        Erf\u00fcllungsweg weg = maybeErf\u00fcllungsweg.get();
        ArrayList<AngewendeterErf\u00fcllungsschritt> result = new ArrayList<AngewendeterErf\u00fcllungsschritt>();
        AngewendeterErf\u00fcllungsschritt st\u00fccklisteZuerst = new AngewendeterErf\u00fcllungsschritt(passendeProduktion.koordinate(), passendeProduktion.gesamtanzahl(), this, Arbeitsschritt.ausSt\u00fcckliste, false, "St\u00fcckliste zuerst bearbeiten");
        this.vorlage.st\u00fccklisteneintr\u00e4ge().forEach(se -> {
            Optional<Produktionslisteneintrag> maybeProduktion = Optional.ofNullable((Produktionslisteneintrag)position2Eintrag.get(se.position()));
            if (maybeProduktion.isEmpty()) {
                this.getLogger().error((Object)("Kann den St\u00fccklisteneintrag " + se.artikelreferenz().revisionierteArtikelnummer() + " nicht einem Produktionslisteneintrag zuordnen."));
                return;
            }
            Produktionslisteneintrag produktion = maybeProduktion.get();
            Iterable<AngewendeterErf\u00fcllungsschritt> unterweg = produktion.artikel().erf\u00fcllungswegAus(produktion, alleArtikel, erf\u00fcllungswege, arbeitsschritte);
            unterweg.forEach(result::add);
            IterableUtil.maybeLastOf(unterweg).ifPresent(ae -> st\u00fccklisteZuerst.hatVoraussetzung((AngewendeterErf\u00fcllungsschritt)ae));
        });
        HashMap<String, Erf\u00fcllungsschritt> bekannteSchritte = new HashMap<String, Erf\u00fcllungsschritt>();
        HashMap<Erf\u00fcllungsschritt, AngewendeterErf\u00fcllungsschritt> zuordnung = new HashMap<Erf\u00fcllungsschritt, AngewendeterErf\u00fcllungsschritt>();
        List erf\u00fcllungsschritte = IterableUtil.asList(weg.inSchritten());
        HashMap<String, Iterable<String>> voraussetzungenF\u00fcrErf\u00fcllungsschritt = new HashMap<String, Iterable<String>>();
        HashSet<String> \u00fcbersprungeneErf\u00fcllungsschritte = new HashSet<String>();
        for (int i = 0; i < erf\u00fcllungsschritte.size(); ++i) {
            boolean istLetzter = i == erf\u00fcllungsschritte.size() - 1;
            Erf\u00fcllungsschritt aktuell = (Erf\u00fcllungsschritt)((Object)erf\u00fcllungsschritte.get(i));
            bekannteSchritte.put(aktuell.identifier(), aktuell);
            Optional<Arbeitsschritt> maybeT\u00e4tigkeit = aktuell.getArbeitsschrittAus(arbeitsschritte);
            if (maybeT\u00e4tigkeit.isEmpty()) {
                this.getLogger().error((Object)("Kann den Arbeitsschritt " + aktuell.arbeitsschrittIdentifier() + " nicht f\u00fcr " + aktuell.identifier() + " aufl\u00f6sen!"));
                continue;
            }
            voraussetzungenF\u00fcrErf\u00fcllungsschritt.put(aktuell.identifier(), aktuell.voraussetzungen());
            Arbeitsschritt schritt = maybeT\u00e4tigkeit.get();
            if (schritt.istPlatzhalter()) {
                this.getLogger().debug((Object)("Platzhalter " + schritt.beschreibung() + " \u00fcbersprungen."));
                \u00fcbersprungeneErf\u00fcllungsschritte.add(aktuell.identifier());
                continue;
            }
            if (!schritt.erf\u00fclltBedingungF\u00fcr(this.eigenschaften())) {
                this.getLogger().debug((Object)("Der Arbeitsschritt " + schritt.nummerMitT\u00e4tigkeit() + " wird \u00fcbersprungen, weil die Bedingung " + schritt.bedingungsbeschreibung() + " nicht zutrifft."));
                \u00fcbersprungeneErf\u00fcllungsschritte.add(aktuell.identifier());
                continue;
            }
            AngewendeterErf\u00fcllungsschritt angewendet = new AngewendeterErf\u00fcllungsschritt(passendeProduktion.koordinate(), passendeProduktion.gesamtanzahl(), this, schritt, istLetzter, " auf " + aktuell.identifier());
            ArrayList<String> gesammelteVoraussetzungen = new ArrayList<String>();
            ArrayList kandidaten = new ArrayList();
            aktuell.voraussetzungen().forEach(kandidaten::add);
            while (!kandidaten.isEmpty()) {
                String cursor = (String)kandidaten.removeLast();
                if (\u00fcbersprungeneErf\u00fcllungsschritte.contains(cursor)) {
                    Iterable dessenVorg\u00e4nger = (Iterable)voraussetzungenF\u00fcrErf\u00fcllungsschritt.get(cursor);
                    if (null == dessenVorg\u00e4nger) {
                        this.getLogger().error((Object)("Fehler: Keine Vorg\u00e4nger gefunden f\u00fcr " + cursor));
                        continue;
                    }
                    dessenVorg\u00e4nger.forEach(kandidaten::add);
                    continue;
                }
                gesammelteVoraussetzungen.add(cursor);
            }
            Iterable<Erf\u00fcllungsschritt> vorausgehendeSchritte = Erf\u00fcllungsschritt.aufl\u00f6senF\u00fcr(gesammelteVoraussetzungen, s -> Optional.ofNullable((Erf\u00fcllungsschritt)((Object)((Object)bekannteSchritte.get(s)))), "als Voraussetzung f\u00fcr " + aktuell.identifier());
            if (IterableUtil.isEmpty(vorausgehendeSchritte)) {
                st\u00fccklisteZuerst.etabliereAlsNachfolger(angewendet);
            } else {
                vorausgehendeSchritte.forEach(es -> Optional.ofNullable((AngewendeterErf\u00fcllungsschritt)zuordnung.get(es)).ifPresent(ae -> ae.etabliereAlsNachfolger(angewendet)));
            }
            zuordnung.put(aktuell, angewendet);
            result.add(angewendet);
        }
        return result;
    }

    public Produktionskoordinate koordinate() {
        return this.koordinate;
    }

    public Artikel<?> spezifikation() {
        return this.vorlage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> eigenschaften() {
        Map<String, String> map = this.eigenschaften;
        synchronized (map) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.putAll(this.eigenschaften);
            result.putAll(this.vorlage.alleEigenschaften());
            return result;
        }
    }

    public Optional<String> eigenschaft(Artikeleigenschaft definiert) {
        return this.eigenschaftF\u00fcr(definiert.bezeichnung());
    }

    public Optional<String> eigenschaftF\u00fcr(String eigenschaftschl\u00fcssel) {
        return Optional.ofNullable(this.eigenschaften().get(eigenschaftschl\u00fcssel));
    }

    public Produktionsartikel mitEigenschaft(Artikeleigenschaft eigenschaft, String wert) {
        return this.mitEigenschaftF\u00fcr(eigenschaft.bezeichnung(), wert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Produktionsartikel mitEigenschaftF\u00fcr(String name, String wert) {
        Map<String, String> map = this.eigenschaften;
        synchronized (map) {
            this.eigenschaften.put(name, wert);
        }
        return this;
    }

    @Override
    public Optional<Produktionsnummer> maybeProduktionsnummer() {
        return Optional.of(this.koordinate.nummer());
    }

    @Override
    public Iterable<? extends St\u00fccklisteneintrag> st\u00fccklisteneintr\u00e4ge() {
        return this.vorlage.st\u00fccklisteneintr\u00e4ge();
    }

    public Artikelreferenz artikel() {
        return this.vorlage.referenz();
    }

    public String artikelnummerMitRevision() {
        return this.vorlage.artikelnummerMitRevision();
    }

    @Override
    public String bezeichnung() {
        return this.vorlage.bezeichnung();
    }

    public String benennung() {
        return this.vorlage.benennung();
    }

    public static Comparator<Produktionsartikel> alphabetischNachArtikelnummer() {
        return (a0, a1) -> a0.vorlage.artikelnummer().alsText().compareTo(a1.vorlage.artikelnummer().alsText());
    }
}

