/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.artikel;

import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.artikel.Artikelnummer;
import com.schneide.werp.domain.artikel.Artikelreferenz;
import com.schneide.werp.domain.artikel.Artikelrevision;
import com.schneide.werp.domain.artikel.Einzelteil;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Erf\u00fcllungsschritt;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fcckliste;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fccklisteneintrag;
import com.schneide.werp.domain.erf\u00fcllung.weg.BeschreibbaresErf\u00fcllungswegRepository;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungsweg;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungswegRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Baugruppe
extends Artikel<Baugruppe> {
    public static final String standardErf\u00fcllungsweg = "baugruppe-standard";

    public Baugruppe(Artikelnummer artikelnummer, String benennung, Artikelrevision revision, String erf\u00fcllungsweg) {
        super(artikelnummer, benennung, revision, erf\u00fcllungsweg, new St\u00fcckliste<St\u00fccklisteneintrag>());
    }

    @Override
    protected Baugruppe erstelleKopieMit(Artikelnummer neueNummer, Artikelrevision neueRevision) {
        Baugruppe result = new Baugruppe(neueNummer, this.benennung(), neueRevision, this.erf\u00fcllungsweg());
        this.st\u00fccklisteneintr\u00e4ge().forEach(result::f\u00fcgeEin);
        return result;
    }

    @Override
    protected Baugruppe typsicher() {
        return this;
    }

    public void f\u00fcgeInSt\u00fccklisteEin(int position, int anzahl, Artikel<?> artikel) {
        St\u00fccklisteneintrag neuerEintrag = St\u00fccklisteneintrag.aufgel\u00f6st(position, anzahl, artikel);
        this.f\u00fcgeEin(neuerEintrag);
    }

    public void f\u00fcgeInSt\u00fccklisteEin(int position, int anzahl, Artikelreferenz artikelreferenz) {
        St\u00fccklisteneintrag neuerEintrag = St\u00fccklisteneintrag.unaufgel\u00f6st(position, anzahl, artikelreferenz);
        this.f\u00fcgeEin(neuerEintrag);
    }

    protected void f\u00fcgeEin(St\u00fccklisteneintrag neuerEintrag) {
        this.inSt\u00fcckliste(s -> s.f\u00fcgeEin(neuerEintrag));
    }

    @Override
    public boolean istEinzelteil() {
        return false;
    }

    @Override
    public Optional<Baugruppe> alsBaugruppe() {
        return Optional.of(this);
    }

    @Override
    public Optional<Einzelteil> alsEinzelteil() {
        return Optional.empty();
    }

    public static void erstelleStandardErf\u00fcllungswegIn(BeschreibbaresErf\u00fcllungswegRepository erf\u00fcllungswege) {
        Erf\u00fcllungsweg standard = new Erf\u00fcllungsweg(standardErf\u00fcllungsweg, "", standardErf\u00fcllungsweg, standardErf\u00fcllungsweg, List.of(Erf\u00fcllungsschritt.ohneVoraussetzungenF\u00fcr("Werksmontage")));
        erf\u00fcllungswege.f\u00fcgeHinzu(standard);
    }

    @Override
    protected Iterable<Erf\u00fcllungsschritt> voraussetzendeErf\u00fcllungsschritteAus(Erf\u00fcllungswegRepository erf\u00fcllungswege, ArbeitsschrittRepository arbeitsschritte) {
        ArrayList<Erf\u00fcllungsschritt> result = new ArrayList<Erf\u00fcllungsschritt>();
        this.f\u00fcrAlleSt\u00fccklisteneintr\u00e4ge(se -> {
            Erf\u00fcllungsschritt erstSt\u00fccklisteneintrag = Erf\u00fcllungsschritt.f\u00fcrSt\u00fccklisteneintrag(se);
            result.add(erstSt\u00fccklisteneintrag);
        });
        return result;
    }
}

