/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.artikel;

import com.schneide.base.logging.LoggedObject;
import com.schneide.werp.domain.artikel.Artikeleigenschaft;
import com.schneide.werp.domain.artikel.Artikelnummer;
import com.schneide.werp.domain.artikel.Artikelreferenz;
import com.schneide.werp.domain.artikel.Artikelrevision;
import com.schneide.werp.domain.artikel.Baugruppe;
import com.schneide.werp.domain.artikel.Einzelteil;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Erf\u00fcllungsschritt;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fcckliste;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fccklistenbehaftet;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fccklisteneintrag;
import com.schneide.werp.domain.erf\u00fcllung.weg.Erf\u00fcllungswegRepository;
import com.schneide.werp.domain.material.Abmessung;
import com.schneide.werp.domain.material.Masse;
import com.schneide.werp.domain.material.Material;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class Artikel<A extends Artikel<A>>
extends LoggedObject
implements St\u00fccklistenbehaftet {
    private final Artikelnummer artikelnummer;
    private final Artikelrevision revision;
    private final String benennung;
    private final Map<String, String> eigenschaften;
    private String erf\u00fcllungsweg;
    private final St\u00fcckliste<St\u00fccklisteneintrag> st\u00fcckliste;

    public Artikel(Artikelnummer artikelnummer, String benennung, Artikelrevision revision, String erf\u00fcllungsweg, St\u00fcckliste<St\u00fccklisteneintrag> st\u00fcckliste) {
        this.artikelnummer = artikelnummer;
        this.benennung = benennung;
        this.revision = revision;
        this.erf\u00fcllungsweg = erf\u00fcllungsweg;
        this.st\u00fcckliste = st\u00fcckliste;
        this.eigenschaften = new HashMap<String, String>();
    }

    public A kopieMit(Artikelnummer neu) {
        Object result = this.erstelleKopieMit(neu, Artikelrevision.erste);
        this.alleEigenschaften().forEach((key, value) -> result.mitEigenschaftF\u00fcr((String)key, (String)value));
        ((Artikel)result).mitEigenschaftF\u00fcr("Basiert auf", this.artikelnummerMitRevision());
        return result;
    }

    protected abstract A erstelleKopieMit(Artikelnummer var1, Artikelrevision var2);

    protected abstract A typsicher();

    public A mitEigenschaft(Artikeleigenschaft eigenschaft, String wert) {
        return this.mitEigenschaftF\u00fcr(eigenschaft.bezeichnung(), wert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public A mitEigenschaftF\u00fcr(String name, String wert) {
        Map<String, String> map = this.eigenschaften;
        synchronized (map) {
            this.eigenschaften.put(name, wert);
        }
        return this.typsicher();
    }

    public Artikelreferenz referenz() {
        return new Artikelreferenz(this.artikelnummer, this.revision);
    }

    public Artikelnummer artikelnummer() {
        return this.artikelnummer;
    }

    public Artikelrevision revision() {
        return this.revision;
    }

    public String revisionierteArtikelnummer() {
        return this.referenz().revisionierteArtikelnummer();
    }

    public String erf\u00fcllungsweg() {
        return this.erf\u00fcllungsweg;
    }

    public String benennung() {
        return this.benennung;
    }

    @Override
    public Optional<Produktionsnummer> maybeProduktionsnummer() {
        return Optional.empty();
    }

    @Override
    public String bezeichnung() {
        return this.benennung();
    }

    public Optional<Masse> masse() {
        return this.eigenschaft(Artikeleigenschaft.Masse).flatMap(Masse::ausKilogrammangabe);
    }

    public Optional<Abmessung> abmessung() {
        return this.eigenschaft(Artikeleigenschaft.Abmessung).map(Abmessung::new);
    }

    public Optional<Material> material() {
        return this.eigenschaft(Artikeleigenschaft.Material).map(Material::new);
    }

    public Optional<String> eigenschaft(Artikeleigenschaft definiert) {
        return this.eigenschaftF\u00fcr(definiert.bezeichnung());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> eigenschaftF\u00fcr(String eigenschaftschl\u00fcssel) {
        Map<String, String> map = this.eigenschaften;
        synchronized (map) {
            return Optional.ofNullable(this.eigenschaften.get(eigenschaftschl\u00fcssel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> alleEigenschaften() {
        Map<String, String> map = this.eigenschaften;
        synchronized (map) {
            return Map.copyOf(this.eigenschaften);
        }
    }

    public Iterable<St\u00fccklisteneintrag> st\u00fccklisteneintr\u00e4ge() {
        return this.st\u00fcckliste.eintr\u00e4ge();
    }

    protected void inSt\u00fcckliste(Consumer<St\u00fcckliste<St\u00fccklisteneintrag>> aktion) {
        aktion.accept(this.st\u00fcckliste);
    }

    protected void f\u00fcrAlleSt\u00fccklisteneintr\u00e4ge(Consumer<St\u00fccklisteneintrag> aktion) {
        this.inSt\u00fcckliste(sl -> sl.eintr\u00e4ge().forEach(aktion));
    }

    protected abstract Iterable<Erf\u00fcllungsschritt> voraussetzendeErf\u00fcllungsschritteAus(Erf\u00fcllungswegRepository var1, ArbeitsschrittRepository var2);

    public abstract boolean istEinzelteil();

    public boolean istBaugruppe() {
        return !this.istEinzelteil();
    }

    public abstract Optional<Baugruppe> alsBaugruppe();

    public abstract Optional<Einzelteil> alsEinzelteil();

    public Iterable<Artikelreferenz> st\u00fccklistenreferenzenAufl\u00f6senMit(Function<Artikelreferenz, Optional<Artikel<?>>> repository) {
        ArrayList<Artikelreferenz> gescheitert = new ArrayList<Artikelreferenz>();
        for (St\u00fccklisteneintrag each : this.st\u00fcckliste.eintr\u00e4ge()) {
            Optional<Artikel<?>> maybeArtikel = each.artikelAufgel\u00f6stMit(repository);
            if (!maybeArtikel.isEmpty()) continue;
            gescheitert.add(each.artikelreferenz());
        }
        return gescheitert;
    }

    public String toString() {
        return this.druckbareBeschreibung();
    }

    public String druckbareBeschreibung() {
        return String.valueOf(this.artikelnummer()) + " Rev. " + String.valueOf(this.revision()) + ": " + this.benennung();
    }

    public int hashCode() {
        return Objects.hash(this.artikelnummer, this.revision);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Artikel other = (Artikel)obj;
        return Objects.equals(this.artikelnummer, other.artikelnummer) && this.revision == other.revision;
    }

    public String debugtext() {
        StringBuilder builder = new StringBuilder();
        builder.append("Artikel [artikelnummer=");
        builder.append(this.artikelnummer);
        builder.append(", benennung=");
        builder.append(this.benennung);
        builder.append(", revision=");
        builder.append(this.revision);
        builder.append(", erf\u00fcllungsweg = " + this.erf\u00fcllungsweg + ", st\u00fcckliste = " + this.st\u00fcckliste.size() + "]");
        return builder.toString();
    }

    public static Comparator<Artikel<?>> alphabetischNachArtikelnummer() {
        return (a0, a1) -> a0.artikelnummer().alsText().compareTo(a1.artikelnummer().alsText());
    }

    public String artikelnummerMitRevision() {
        return this.referenz().artikelnummerMitRevisionAlsAnzeigetext();
    }

    public void \u00e4ndereErf\u00fcllungswegAuf(String neuerWeg) {
        this.erf\u00fcllungsweg = neuerWeg;
    }
}

