/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.angebot;

import com.schneide.werp.domain.artikel.Artikelnummer;

public interface Angebotsdaten {
    public Auftragnummer auftrag();

    public Angebotsnummer nummer();

    public Angebotsversion version();

    public Angebotskunde kunde();

    public Projektbeschreibung beschreibung();

    public Iterable<String> weitereAngaben();

    public Iterable<Angebotsposition> positionen();

    public static interface Angebotspositionsnummer {
        public String alsText();

        default public boolean istHauptposition() {
            return !this.alsText().isBlank() && !this.alsText().contains(".");
        }
    }

    public static interface Angebotsartikelnummer {
        public String alsText();

        default public Artikelnummer alsArtikelnummer() {
            return new Artikelnummer(this.alsText());
        }
    }

    public static interface Angebotsposition {
        public Angebotspositionsnummer position();

        public boolean anpassung();

        public int anzahl();

        public Angebotsartikelnummer artikelnummer();

        public String beschreibung();

        public String kundennummer();
    }

    public static interface Projektbeschreibung {
        public String alsText();
    }

    public static interface Angebotskunde {
        public String alsText();
    }

    public static interface Angebotsversion {
        public int alsInteger();

        default public String alsText() {
            return String.valueOf(this.alsInteger());
        }
    }

    public static interface Angebotsnummer {
        public String alsText();
    }

    public static interface Auftragnummer {
        public String alsText();
    }
}

