/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.embedded.types;

import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.persistence.types.PersistenceTypeManager;
import org.eclipse.store.storage.exceptions.StorageExceptionInitialization;
import org.eclipse.store.storage.types.StorageRootTypeIdProvider;

public interface EmbeddedStorageRootTypeIdProvider
extends StorageRootTypeIdProvider {
    public void initialize(PersistenceTypeManager var1);

    public static EmbeddedStorageRootTypeIdProvider New(Class<?> rootType) {
        return new Default(rootType);
    }

    public static final class Default
    implements EmbeddedStorageRootTypeIdProvider {
        private final Class<?> rootType;
        private transient Long cachedRootTypeId;

        Default(Class<?> rootType) {
            this.rootType = rootType;
        }

        public final long provideRootTypeId() {
            if (this.cachedRootTypeId == null) {
                throw new StorageExceptionInitialization("not initialized");
            }
            return this.cachedRootTypeId;
        }

        @Override
        public final void initialize(PersistenceTypeManager typeIdResolver) {
            long typeId = typeIdResolver.ensureTypeId(this.rootType);
            this.cachedRootTypeId = XMath.positive((long)typeId);
        }
    }
}

