/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.embedded.types;

import org.eclipse.serializer.persistence.types.ObjectIdsProcessor;
import org.eclipse.serializer.persistence.types.ObjectIdsSelector;
import org.eclipse.serializer.persistence.types.PersistenceObjectRegistry;

public interface EmbeddedStorageObjectRegistryCallback
extends ObjectIdsSelector {
    public void initializeObjectRegistry(PersistenceObjectRegistry var1);

    public static EmbeddedStorageObjectRegistryCallback New() {
        return new Default();
    }

    public static final class Default
    implements EmbeddedStorageObjectRegistryCallback {
        private PersistenceObjectRegistry objectRegistry;

        Default() {
        }

        @Override
        public synchronized void initializeObjectRegistry(PersistenceObjectRegistry objectRegistry) {
            if (this.objectRegistry != null) {
                if (this.objectRegistry == objectRegistry) {
                    return;
                }
                throw new RuntimeException("ObjectRegistry already initialized.");
            }
            this.objectRegistry = objectRegistry;
        }

        public synchronized boolean processSelected(ObjectIdsProcessor processor) {
            if (this.objectRegistry == null) {
                processor.processObjectIdsByFilter(objectId -> false);
                return true;
            }
            return this.objectRegistry.processLiveObjectIds(processor);
        }
    }
}

