/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.embedded.types;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Predicate;
import org.eclipse.serializer.afs.types.AFile;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.XSort;
import org.eclipse.serializer.collections.types.XGettingEnum;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.monitoring.MetricMonitor;
import org.eclipse.serializer.monitoring.MonitoringManager;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceManager;
import org.eclipse.serializer.persistence.types.PersistenceRootReference;
import org.eclipse.serializer.persistence.types.PersistenceRoots;
import org.eclipse.serializer.persistence.types.PersistenceRootsProvider;
import org.eclipse.serializer.persistence.types.PersistenceRootsView;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionaryExporter;
import org.eclipse.serializer.persistence.types.Storer;
import org.eclipse.serializer.persistence.types.Unpersistable;
import org.eclipse.serializer.reference.LazyReferenceManager;
import org.eclipse.serializer.reference.Swizzling;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.logging.Logging;
import org.eclipse.store.storage.embedded.types.EmbeddedStorageConnectionFoundation;
import org.eclipse.store.storage.exceptions.StorageExceptionConsistency;
import org.eclipse.store.storage.monitoring.ObjectRegistryMonitor;
import org.eclipse.store.storage.monitoring.StorageManagerMonitor;
import org.eclipse.store.storage.types.Database;
import org.eclipse.store.storage.types.StorageConfiguration;
import org.eclipse.store.storage.types.StorageConnection;
import org.eclipse.store.storage.types.StorageEntityCacheEvaluator;
import org.eclipse.store.storage.types.StorageEntityTypeExportFileProvider;
import org.eclipse.store.storage.types.StorageEntityTypeExportStatistics;
import org.eclipse.store.storage.types.StorageEntityTypeHandler;
import org.eclipse.store.storage.types.StorageIdAnalysis;
import org.eclipse.store.storage.types.StorageKillable;
import org.eclipse.store.storage.types.StorageLiveFileProvider;
import org.eclipse.store.storage.types.StorageManager;
import org.eclipse.store.storage.types.StorageRawFileStatistics;
import org.eclipse.store.storage.types.StorageSystem;
import org.eclipse.store.storage.types.StorageTypeDictionary;
import org.slf4j.Logger;

public interface EmbeddedStorageManager
extends StorageManager {
    public EmbeddedStorageManager start();

    public static Default New(Database database, StorageConfiguration configuration, EmbeddedStorageConnectionFoundation<?> connectionFoundation, PersistenceRootsProvider<?> rootsProvider, MonitoringManager monitorManager) {
        return new Default((Database)X.notNull((Object)database), (StorageConfiguration)X.notNull((Object)configuration), (EmbeddedStorageConnectionFoundation)X.notNull(connectionFoundation), (PersistenceRootsProvider)X.notNull(rootsProvider), monitorManager);
    }

    public static final class Default
    implements EmbeddedStorageManager,
    Unpersistable,
    LazyReferenceManager.Controller {
        private static final Logger logger = Logging.getLogger(EmbeddedStorageManager.class);
        private final Database database;
        private final StorageConfiguration configuration;
        private final StorageSystem storageSystem;
        private final EmbeddedStorageConnectionFoundation<?> connectionFoundation;
        private final PersistenceRootsProvider<?> rootsProvider;
        private StorageConnection singletonConnection;
        private final MonitoringManager monitorManager;

        Default(Database database, StorageConfiguration configuration, EmbeddedStorageConnectionFoundation<?> connectionFoundation, PersistenceRootsProvider<?> rootsProvider, MonitoringManager monitorManager) {
            this.database = database;
            this.configuration = configuration;
            this.storageSystem = connectionFoundation.getStorageSystem();
            this.connectionFoundation = connectionFoundation;
            this.rootsProvider = rootsProvider;
            this.monitorManager = monitorManager;
        }

        private synchronized StorageConnection singletonConnection() {
            if (this.singletonConnection == null) {
                this.singletonConnection = this.createConnection();
            }
            return this.singletonConnection;
        }

        public final Database database() {
            return this.database;
        }

        public final Object root() {
            return this.rootReference().get();
        }

        public final Object setRoot(Object newRoot) {
            this.rootReference().setRoot(newRoot);
            return newRoot;
        }

        final PersistenceRootReference rootReference() {
            return this.rootsProvider.provideRoots().rootReference();
        }

        public long storeRoot() {
            PersistenceRootReference rootReference = this.rootReference();
            Object root = rootReference.get();
            if (root == null) {
                this.store(rootReference);
                return Swizzling.nullId();
            }
            return this.storeAll(new Object[]{rootReference, root})[1];
        }

        public final PersistenceRootsView viewRoots() {
            return this.rootsProvider.provideRoots();
        }

        public PersistenceManager<Binary> persistenceManager() {
            return this.singletonConnection().persistenceManager();
        }

        public final Storer createStorer() {
            return this.singletonConnection().createStorer();
        }

        public boolean mayRun() {
            return this.isRunning();
        }

        private void ensureActiveLazyReferenceManager(LazyReferenceManager lazyReferenceManager, boolean lazyReferenceManagerIsRunning) {
            lazyReferenceManager.addController((LazyReferenceManager.Controller)this);
            if (lazyReferenceManagerIsRunning) {
                return;
            }
            lazyReferenceManager.start();
        }

        private void rollbackLazyReferenceManager(LazyReferenceManager lazyReferenceManager) {
            lazyReferenceManager.removeController((LazyReferenceManager.Controller)this);
        }

        @Override
        public final Default start() {
            logger.info("Starting embedded storage manager");
            LazyReferenceManager lazyReferenceManager = LazyReferenceManager.get();
            boolean lazyReferenceManagerIsRunning = lazyReferenceManager.isRunning();
            this.storageSystem.start();
            try {
                this.ensureRequiredTypeHandlers();
                this.initialize();
                logger.info("Embedded storage manager initialized");
                this.ensureActiveLazyReferenceManager(lazyReferenceManager, lazyReferenceManagerIsRunning);
            }
            catch (Throwable t) {
                try {
                    this.rollbackLazyReferenceManager(lazyReferenceManager);
                    this.monitorManager.shutdown();
                    if (this.storageSystem instanceof StorageKillable) {
                        ((StorageKillable)this.storageSystem).killStorage(t);
                    } else {
                        this.storageSystem.shutdown();
                    }
                }
                catch (Throwable t1) {
                    t1.addSuppressed(t);
                    throw t1;
                }
                throw t;
            }
            this.monitorManager.registerMonitor((MetricMonitor)new StorageManagerMonitor((StorageManager)this));
            return this;
        }

        static final boolean isEqualRootEntry(KeyValue<String, Object> e1, KeyValue<String, Object> e2) {
            if (!((String)e1.key()).equals(e2.key())) {
                return false;
            }
            if (Persistence.isEnumRootIdentifier((String)((String)e1.key()))) {
                return Arrays.equals((Object[])e1.value(), (Object[])e2.value());
            }
            return e1.value() == e2.value();
        }

        private static EqHashTable<String, Object> normalize(XGettingTable<String, Object> entries) {
            EqHashTable preparedEntries = EqHashTable.New(entries);
            preparedEntries.keys().sort(XSort::compare);
            return preparedEntries;
        }

        private void synchronizeRoots(PersistenceRoots loadedRoots) {
            EqHashTable<String, Object> definedEntries;
            EqHashTable<String, Object> loadedEntries = Default.normalize((XGettingTable<String, Object>)loadedRoots.entries());
            boolean match = loadedEntries.equalsContent(definedEntries = Default.normalize((XGettingTable<String, Object>)this.rootsProvider.provideRoots().entries()), Default::isEqualRootEntry);
            if (!match) {
                loadedRoots.updateEntries(definedEntries);
            }
            this.rootsProvider.updateRuntimeRoots(loadedRoots);
        }

        private void ensureRequiredTypeHandlers() {
            StorageIdAnalysis idAnalysis = this.storageSystem.initializationIdAnalysis();
            XGettingEnum occuringTypeIds = idAnalysis.occuringTypeIds();
            this.connectionFoundation.getTypeHandlerManager().ensureTypeHandlersByTypeIds(occuringTypeIds);
        }

        private PersistenceRoots loadExistingRoots(StorageConnection initConnection) {
            return initConnection.persistenceManager().createLoader().loadRoots();
        }

        private PersistenceRoots validateEmptyDatabaseAndReturnDefinedRoots(StorageConnection initConnection) {
            StorageRawFileStatistics statistics = initConnection.createStorageStatistics();
            if (statistics.liveDataLength() != 0L) {
                throw new StorageExceptionConsistency("No roots found for existing data.");
            }
            return this.rootsProvider.provideRoots();
        }

        private void initialize() {
            try {
                StorageConnection initConnection = this.createConnection();
                this.monitorManager.registerMonitor((MetricMonitor)new ObjectRegistryMonitor(initConnection.persistenceManager().objectRegistry()));
                PersistenceRoots loadedRoots = this.loadExistingRoots(initConnection);
                if (loadedRoots == null) {
                    loadedRoots = this.validateEmptyDatabaseAndReturnDefinedRoots(initConnection);
                } else {
                    this.synchronizeRoots(loadedRoots);
                    if (!loadedRoots.hasChanged()) {
                        return;
                    }
                }
                logger.debug("Storing required root objects and constants");
                initConnection.store((Object)loadedRoots);
            }
            catch (Exception e) {
                logger.error("Exception occurred while initializing embedded storage manager", (Throwable)e);
                throw e;
            }
        }

        public final boolean shutdown() {
            LazyReferenceManager.get().removeController((LazyReferenceManager.Controller)this);
            return this.storageSystem.shutdown();
        }

        public final boolean isAcceptingTasks() {
            return this.storageSystem.isAcceptingTasks();
        }

        public final boolean isRunning() {
            return this.storageSystem.isRunning();
        }

        public final boolean isActive() {
            return this.storageSystem.isActive();
        }

        public final boolean isStartingUp() {
            return this.storageSystem.isStartingUp();
        }

        public final boolean isShuttingDown() {
            return this.storageSystem.isShuttingDown();
        }

        public final void checkAcceptingTasks() {
            this.storageSystem.checkAcceptingTasks();
        }

        public final StorageConfiguration configuration() {
            return this.configuration;
        }

        public final StorageTypeDictionary typeDictionary() {
            return this.storageSystem.typeDictionary();
        }

        public final StorageConnection createConnection() {
            return this.connectionFoundation.createStorageConnection();
        }

        public final long initializationTime() {
            return this.storageSystem.initializationTime();
        }

        public final long operationModeTime() {
            return this.storageSystem.operationModeTime();
        }

        public final void issueFullGarbageCollection() {
            this.singletonConnection().issueFullGarbageCollection();
        }

        public final boolean issueGarbageCollection(long nanoTimeBudget) {
            return this.singletonConnection().issueGarbageCollection(nanoTimeBudget);
        }

        public final void issueFullFileCheck() {
            this.singletonConnection().issueFullFileCheck();
        }

        public final boolean issueFileCheck(long nanoTimeBudget) {
            return this.singletonConnection().issueFileCheck(nanoTimeBudget);
        }

        public final void issueFullCacheCheck() {
            this.singletonConnection().issueFullCacheCheck();
        }

        public final void issueFullCacheCheck(StorageEntityCacheEvaluator entityEvaluator) {
            this.singletonConnection().issueFullCacheCheck(entityEvaluator);
        }

        public final boolean issueCacheCheck(long nanoTimeBudget) {
            return this.singletonConnection().issueCacheCheck(nanoTimeBudget);
        }

        public final boolean issueCacheCheck(long nanoTimeBudget, StorageEntityCacheEvaluator entityEvaluator) {
            return this.singletonConnection().issueCacheCheck(nanoTimeBudget, entityEvaluator);
        }

        public final void issueFullBackup(StorageLiveFileProvider targetFileProvider, PersistenceTypeDictionaryExporter typeDictionaryExporter) {
            this.singletonConnection().issueFullBackup(targetFileProvider, typeDictionaryExporter);
        }

        public void issueTransactionsLogCleanup() {
            this.singletonConnection().issueTransactionsLogCleanup();
        }

        public final StorageRawFileStatistics createStorageStatistics() {
            return this.singletonConnection().createStorageStatistics();
        }

        public final void exportChannels(StorageLiveFileProvider fileProvider, boolean performGarbageCollection) {
            this.singletonConnection().exportChannels(fileProvider, performGarbageCollection);
        }

        public final StorageEntityTypeExportStatistics exportTypes(StorageEntityTypeExportFileProvider exportFileProvider, Predicate<? super StorageEntityTypeHandler> isExportType) {
            return this.singletonConnection().exportTypes(exportFileProvider, isExportType);
        }

        public final void importFiles(XGettingEnum<AFile> importFiles) {
            this.singletonConnection().importFiles(importFiles);
        }

        public void importData(XGettingEnum<ByteBuffer> importData) {
            this.singletonConnection().importData(importData);
        }
    }
}

