/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.store.storage.embedded.types;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import org.eclipse.serializer.afs.types.ADirectory;
import org.eclipse.serializer.persistence.types.Persistence;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionaryFileHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionaryIoHandler;
import org.eclipse.serializer.persistence.types.PersistenceTypeDictionaryStorer;
import org.eclipse.serializer.persistence.types.PersistenceTypeEvaluator;
import org.eclipse.store.afs.nio.types.NioFileSystem;
import org.eclipse.store.storage.embedded.types.EmbeddedStorageConnectionFoundation;
import org.eclipse.store.storage.embedded.types.EmbeddedStorageFoundation;
import org.eclipse.store.storage.embedded.types.EmbeddedStorageManager;
import org.eclipse.store.storage.types.Storage;
import org.eclipse.store.storage.types.StorageBackupSetup;
import org.eclipse.store.storage.types.StorageConfiguration;
import org.eclipse.store.storage.types.StorageLiveFileProvider;

public final class EmbeddedStorage {
    public static final EmbeddedStorageFoundation<?> createFoundation() {
        return EmbeddedStorageFoundation.New();
    }

    public static final EmbeddedStorageConnectionFoundation<?> ConnectionFoundation(PersistenceTypeDictionaryIoHandler typeDictionaryIoHandler) {
        return EmbeddedStorage.ConnectionFoundation(typeDictionaryIoHandler, Persistence::isPersistable);
    }

    public static final EmbeddedStorageConnectionFoundation<?> ConnectionFoundation(StorageConfiguration configuration, PersistenceTypeEvaluator typeEvaluatorPersistable) {
        StorageBackupSetup backupSetup = configuration.backupSetup();
        PersistenceTypeDictionaryIoHandler btdih = backupSetup != null ? backupSetup.backupFileProvider().provideTypeDictionaryIoHandler() : null;
        StorageLiveFileProvider fileProvider = configuration.fileProvider();
        PersistenceTypeDictionaryIoHandler tdih = fileProvider.provideTypeDictionaryIoHandler((PersistenceTypeDictionaryStorer)btdih);
        return EmbeddedStorage.ConnectionFoundation(tdih, typeEvaluatorPersistable);
    }

    public static final EmbeddedStorageConnectionFoundation<?> ConnectionFoundation(ADirectory directory) {
        return EmbeddedStorage.ConnectionFoundation((PersistenceTypeDictionaryIoHandler)PersistenceTypeDictionaryFileHandler.New((ADirectory)directory));
    }

    public static final EmbeddedStorageConnectionFoundation<?> ConnectionFoundation(PersistenceTypeDictionaryIoHandler typeDictionaryIoHandler, PersistenceTypeEvaluator typeEvaluatorPersistable) {
        return (EmbeddedStorageConnectionFoundation)((EmbeddedStorageConnectionFoundation)EmbeddedStorageConnectionFoundation.New().setTypeDictionaryIoHandler(typeDictionaryIoHandler)).setTypeEvaluatorPersistable(typeEvaluatorPersistable);
    }

    public static final EmbeddedStorageFoundation<?> Foundation() {
        return EmbeddedStorage.Foundation(Storage.defaultStorageDirectory());
    }

    public static final EmbeddedStorageFoundation<?> Foundation(Path directory) {
        return EmbeddedStorage.Foundation(NioFileSystem.New((FileSystem)directory.getFileSystem()).ensureDirectory((Object)directory));
    }

    public static final EmbeddedStorageFoundation<?> Foundation(ADirectory directory) {
        return EmbeddedStorage.Foundation(Storage.Configuration((StorageLiveFileProvider)Storage.FileProvider((ADirectory)directory)));
    }

    public static final EmbeddedStorageFoundation<?> Foundation(StorageConfiguration configuration) {
        return (EmbeddedStorageFoundation)EmbeddedStorage.createFoundation().setConfiguration(configuration);
    }

    public static final EmbeddedStorageFoundation<?> Foundation(StorageConfiguration.Builder<?> configuration) {
        return EmbeddedStorage.Foundation(configuration.createConfiguration());
    }

    public static final EmbeddedStorageFoundation<?> Foundation(StorageConfiguration configuration, EmbeddedStorageConnectionFoundation<?> connectionFoundation) {
        return EmbeddedStorage.Foundation(configuration).setConnectionFoundation(connectionFoundation);
    }

    public static final EmbeddedStorageManager start() {
        return EmbeddedStorage.start(null);
    }

    public static final EmbeddedStorageManager start(Path directory) {
        return EmbeddedStorage.start(null, directory);
    }

    public static final EmbeddedStorageManager start(ADirectory directory) {
        return EmbeddedStorage.start(null, directory);
    }

    public static final EmbeddedStorageManager start(StorageConfiguration configuration) {
        return EmbeddedStorage.start(null, configuration);
    }

    public static final EmbeddedStorageManager start(StorageConfiguration.Builder<?> configuration) {
        return EmbeddedStorage.start(null, configuration);
    }

    public static final EmbeddedStorageManager start(StorageConfiguration configuration, EmbeddedStorageConnectionFoundation<?> connectionFoundation) {
        return EmbeddedStorage.start(null, configuration, connectionFoundation);
    }

    public static final EmbeddedStorageManager start(Object root) {
        return EmbeddedStorage.createAndStartStorageManager(EmbeddedStorage.Foundation(), root);
    }

    public static final EmbeddedStorageManager start(Object root, Path directory) {
        return EmbeddedStorage.createAndStartStorageManager(EmbeddedStorage.Foundation(directory), root);
    }

    public static final EmbeddedStorageManager start(Object root, ADirectory directory) {
        return EmbeddedStorage.createAndStartStorageManager(EmbeddedStorage.Foundation(directory), root);
    }

    public static final EmbeddedStorageManager start(Object root, StorageConfiguration configuration) {
        return EmbeddedStorage.createAndStartStorageManager(EmbeddedStorage.Foundation(configuration), root);
    }

    public static final EmbeddedStorageManager start(Object root, StorageConfiguration.Builder<?> configuration) {
        return EmbeddedStorage.createAndStartStorageManager(EmbeddedStorage.Foundation(configuration), root);
    }

    public static final EmbeddedStorageManager start(Object root, StorageConfiguration configuration, EmbeddedStorageConnectionFoundation<?> connectionFoundation) {
        return EmbeddedStorage.createAndStartStorageManager(EmbeddedStorage.Foundation(configuration, connectionFoundation), root);
    }

    private static final EmbeddedStorageManager createAndStartStorageManager(EmbeddedStorageFoundation<?> foundation, Object root) {
        EmbeddedStorageManager esm = foundation.createEmbeddedStorageManager(root);
        esm.start();
        return esm;
    }

    private EmbeddedStorage() {
        throw new UnsupportedOperationException();
    }
}

