/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.xcsv;

import org.eclipse.serializer.chars.EscapeHandler;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.exceptions.XCsvException;
import org.eclipse.serializer.functional._charRangeProcedure;
import org.eclipse.serializer.util.xcsv.XCsvConfiguration;

public interface XCsvRecordParserCharArray {
    public int parseRecord(char[] var1, int var2, int var3, char var4, char var5, char var6, char var7, char var8, XCsvConfiguration var9, VarString var10, EscapeHandler var11, _charRangeProcedure var12);

    public static interface Provider {
        public XCsvRecordParserCharArray provideRecordParser();
    }

    public static final class Static {
        public static boolean isTrailingSeparator(char[] input, int iLowBound, int index, char separator) {
            int i = index;
            while (i-- > iLowBound) {
                if (input[i] == separator) {
                    return true;
                }
                if (!XChars.isNonWhitespace(input[i])) continue;
                return false;
            }
            return false;
        }

        public static final int skipSkippable(char[] input, int iStart, int iBound, char commentStarter, XCsvConfiguration config) {
            int lastCharIndex = iBound - 1;
            int i = iStart;
            while (i < iBound) {
                if (XChars.isWhitespace(input[i])) {
                    ++i;
                    continue;
                }
                if (input[i] != commentStarter) {
                    return i;
                }
                if (i >= lastCharIndex) {
                    return i;
                }
                if (input[i + 1] == config.commentSimpleStarter()) {
                    i = Static.skipCommentSimple(input, i + 2, iBound, config.lineSeparator());
                    continue;
                }
                if (input[i + 1] == config.commentFullStarter()) {
                    char[] commentFullTerminator = config.commentFullTerminatorArray();
                    i = Static.skipCommentFull(input, i + 2, iBound, commentFullTerminator[0], commentFullTerminator);
                    continue;
                }
                return i - 1;
            }
            return iBound;
        }

        public static final int skipDataComments(char[] input, int iStart, int iBound, char terminator, char valueSeparator, char lineSeparator, char commentSignal, XCsvConfiguration config) {
            int i = iStart;
            while (i < iBound) {
                if (input[i] == terminator || input[i] == valueSeparator || input[i] == lineSeparator) {
                    return i;
                }
                if (XChars.isWhitespace(input[i])) {
                    ++i;
                    continue;
                }
                if (input[i] != config.commentSignal()) {
                    return i;
                }
                if (++i >= iBound || input[i] == terminator || input[i] == valueSeparator || input[i] == lineSeparator) {
                    return i - 1;
                }
                if (input[i] == commentSignal) {
                    i = Static.skipCommentSimple(input, i + 1, iBound, config.lineSeparator());
                    continue;
                }
                if (input[i] != config.commentFullStarter()) continue;
                char[] commentFullTerminator = config.commentFullTerminatorArray();
                i = Static.skipCommentFull(input, i + 1, iBound, commentFullTerminator[0], commentFullTerminator);
            }
            return i;
        }

        public static final int skipCommentSimple(char[] input, int iStart, int iBound, char terminator) {
            int i = iStart;
            while (i < iBound) {
                if (input[i] == terminator) {
                    return i;
                }
                if (input[i] == '\n') {
                    return i + 1;
                }
                ++i;
            }
            return i;
        }

        public static final int skipCommentFull(char[] input, int iStart, int iBound, char commentFullTerminatorFirst, char[] commentFullTerminator) {
            int i = iStart;
            while (i < iBound) {
                if (input[i] == commentFullTerminatorFirst && Static.containsString(input, i, iBound, commentFullTerminator)) {
                    return i + commentFullTerminator.length;
                }
                ++i;
            }
            throw new XCsvException("Incomplete trailing full comment at index " + i);
        }

        private static boolean containsString(char[] input, int iStart, int iBound, char[] string) {
            int i = 0;
            while (i < string.length) {
                if (iStart + i == iBound || input[iStart + i] != string[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private Static() {
            throw new UnsupportedOperationException();
        }
    }
}

