/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.xcsv;

import java.util.function.Consumer;
import org.eclipse.serializer.chars.StringTable;
import org.eclipse.serializer.chars.XCsvParserCharArray;
import org.eclipse.serializer.chars._charArrayRange;
import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.collections.types.XAddingEnum;
import org.eclipse.serializer.collections.types.XAddingList;
import org.eclipse.serializer.collections.types.XGettingList;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.util.Substituter;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.xcsv.XCSV;
import org.eclipse.serializer.util.xcsv.XCsvConfiguration;
import org.eclipse.serializer.util.xcsv.XCsvContent;
import org.eclipse.serializer.util.xcsv.XCsvDataType;
import org.eclipse.serializer.util.xcsv.XCsvParser;
import org.eclipse.serializer.util.xcsv.XCsvRowCollector;

public final class XCsvContentBuilderCharArray
implements XCsvContent.Builder<_charArrayRange> {
    private final XCsvDataType dataType;
    private final XCsvConfiguration configuration;
    private final Substituter<String> stringCache;
    private final XCsvParser<_charArrayRange> parser;
    private final StringTable.Creator tableCreator;

    public static final XCsvContentBuilderCharArray New() {
        return XCsvContentBuilderCharArray.New(XCSV.configurationDefault());
    }

    public static final XCsvContentBuilderCharArray New(XCsvDataType dataType) {
        return XCsvContentBuilderCharArray.New(null, dataType);
    }

    public static final XCsvContentBuilderCharArray New(XCsvConfiguration csvConfiguration) {
        return XCsvContentBuilderCharArray.New(csvConfiguration, null);
    }

    public static final XCsvContentBuilderCharArray New(XCsvConfiguration csvConfiguration, XCsvDataType dataType) {
        return new XCsvContentBuilderCharArray(X.mayNull(dataType), X.mayNull(csvConfiguration), Substituter.New(), XCsvParserCharArray.New(), new StringTable.Default.Creator());
    }

    private XCsvContentBuilderCharArray(XCsvDataType dataType, XCsvConfiguration configuration, Substituter<String> stringCache, XCsvParser<_charArrayRange> parser, StringTable.Creator tableCreator) {
        this.dataType = dataType;
        this.configuration = configuration;
        this.stringCache = stringCache;
        this.parser = parser;
        this.tableCreator = tableCreator;
    }

    @Override
    public XCsvContent build(String name, _charArrayRange data) {
        BulkList<StringTable> tables = BulkList.New();
        TableCollector tableCollector = new TableCollector(tables, this.tableCreator, this.stringCache);
        XCsvConfiguration effectiveConfig = this.parser.parseCsvData(this.dataType, this.configuration, data, (XCsvRowCollector)tableCollector);
        return XCsvContent.Default.NewTranslated(name, tables, effectiveConfig);
    }

    static final class ColumnNamesCollector
    implements Consumer<String> {
        private final XAddingEnum<String> columnNames;

        public ColumnNamesCollector(XAddingEnum<String> columnNames) {
            this.columnNames = X.notNull(columnNames);
        }

        @Override
        public final void accept(String columnName) {
            this.columnNames.add(columnName);
        }
    }

    static final class ColumnTypesCollector
    implements Consumer<String> {
        private final XAddingList<String> columnTypes;

        public ColumnTypesCollector(XAddingList<String> columnTypes) {
            this.columnTypes = X.notNull(columnTypes);
        }

        @Override
        public final void accept(String columnName) {
            this.columnTypes.add(columnName);
        }
    }

    public final class TableCollector
    implements XCsvRowCollector {
        private final Substituter<String> stringCache;
        private final Consumer<StringTable> tableCollector;
        private final StringTable.Creator tableCreator;
        private final BulkList<String[]> rows;
        private final BulkList<String> row;
        private String tableName;
        private XGettingSequence<String> columnNames;
        private XGettingList<String> columnTypes;

        public TableCollector(Consumer<StringTable> tableCollector, StringTable.Creator tableCreator, Substituter<String> stringCache) {
            this.stringCache = X.notNull(stringCache);
            this.tableCollector = X.notNull(tableCollector);
            this.tableCreator = X.notNull(tableCreator);
            this.rows = new BulkList();
            this.row = new BulkList();
        }

        @Override
        public void beginTable(String tableName, XGettingSequence<String> columnNames, XGettingList<String> columnTypes) {
            this.tableName = tableName;
            this.columnNames = columnNames;
            this.columnTypes = columnTypes;
        }

        @Override
        public final void accept(char[] data, int offset, int length) {
            this.row.add(this.stringCache.substitute(data == null ? null : new String(data, offset, length)));
        }

        @Override
        public final void completeRow() {
            if (this.row.isEmpty()) {
                return;
            }
            this.rows.add(this.row.toArray(String.class));
            this.row.clear();
        }

        @Override
        public final void completeTable() {
            this.tableCollector.accept(this.tableCreator.createStringTable(this.tableName, this.columnNames, this.columnTypes, this.rows));
            this.row.clear();
            this.rows.clear();
        }
    }
}

