/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.traversing;

import org.eclipse.serializer.collections.HashTable;
import org.eclipse.serializer.collections.types.XGettingMap;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.traversing.TypeTraverser;

public interface TypeTraverserProvider {
    default public boolean isUnhandled(Object instance) {
        return this.provide(instance) == null;
    }

    public <T> TypeTraverser<T> provide(T var1);

    public static Default New(TypeTraverser.Creator traverserCreator, XGettingMap<Object, TypeTraverser<?>> traversersPerInstance, XGettingMap<Class<?>, TypeTraverser<?>> traversersPerConcreteType, XGettingTable<Class<?>, TypeTraverser<?>> traversersPerPolymorphType) {
        return new Default(X.notNull(traverserCreator), traversersPerInstance, X.notNull(traversersPerConcreteType), X.notNull(traversersPerPolymorphType));
    }

    public static final class Default
    implements TypeTraverserProvider {
        private final XGettingMap<Object, TypeTraverser<?>> traversersPerInstance;
        private final HashTable<Class<?>, TypeTraverser<?>> traversersPerConcreteType;
        private final XGettingTable<Class<?>, TypeTraverser<?>> traversersPerPolymorphType;
        private final TypeTraverser.Creator traverserCreator;

        Default(TypeTraverser.Creator traverserCreator, XGettingMap<Object, TypeTraverser<?>> traversersPerInstance, XGettingMap<Class<?>, TypeTraverser<?>> traversersPerConcreteType, XGettingTable<Class<?>, TypeTraverser<?>> traversersPerPolymorphType) {
            this.traverserCreator = traverserCreator;
            this.traversersPerInstance = traversersPerInstance;
            this.traversersPerPolymorphType = traversersPerPolymorphType;
            this.traversersPerConcreteType = Default.initializeHandlersPerConcreteType(traversersPerConcreteType);
        }

        private static HashTable<Class<?>, TypeTraverser<?>> initializeHandlersPerConcreteType(XGettingMap<Class<?>, TypeTraverser<?>> traversersPerConcreteType) {
            HashTable<Class<?>, TypeTraverser<?>> localMap = HashTable.New(traversersPerConcreteType);
            return localMap;
        }

        private TypeTraverser<?> handleNewType(Class<?> type) {
            for (KeyValue keyValue : this.traversersPerPolymorphType) {
                if (!((Class)keyValue.key()).isAssignableFrom(type)) continue;
                this.traversersPerConcreteType.add(type, (TypeTraverser)keyValue.value());
                return (TypeTraverser)keyValue.value();
            }
            TypeTraverser<?> typeTraverser = this.traverserCreator.createTraverser(type);
            if (typeTraverser != null) {
                this.traversersPerConcreteType.add(type, typeTraverser);
                return typeTraverser;
            }
            throw new IllegalArgumentException("Untraversable type: " + type.getName());
        }

        protected final TypeTraverser<?> internalProvideTraversalHandler(Object instance) {
            TypeTraverser<?> perInstanceHandler;
            if (this.traversersPerInstance != null && (perInstanceHandler = this.traversersPerInstance.get(instance)) != null) {
                return perInstanceHandler;
            }
            TypeTraverser<?> perTypeHandler = this.traversersPerConcreteType.get(instance.getClass());
            if (perTypeHandler != null) {
                return perTypeHandler;
            }
            return this.handleNewType(instance.getClass());
        }

        @Override
        public <T> TypeTraverser<T> provide(T instance) {
            return this.internalProvideTraversalHandler(instance);
        }
    }
}

