/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.traversing;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.util.traversing.TraversalHandler;

public interface TraversalAcceptor
extends TraversalHandler {
    public boolean acceptReference(Object var1, Object var2);

    public static TraversalAcceptor New(Consumer<Object> logic) {
        return new Default(logic);
    }

    public static TraversalAcceptor New(Predicate<Object> condition, Consumer<Object> logic) {
        return new Conditional(condition, logic);
    }

    public static final class Conditional
    implements TraversalAcceptor {
        private final Predicate<Object> condition;
        private final Consumer<Object> logic;

        Conditional(Predicate<Object> condition, Consumer<Object> logic) {
            this.condition = condition;
            this.logic = logic;
        }

        @Override
        public final boolean acceptReference(Object instance, Object parent) {
            if (this.condition.test(instance)) {
                this.logic.accept(instance);
            }
            return true;
        }
    }

    public static final class Default
    implements TraversalAcceptor {
        private final Consumer<Object> logic;

        Default(Consumer<Object> logic) {
            this.logic = logic;
        }

        @Override
        public final boolean acceptReference(Object instance, Object parent) {
            this.logic.accept(instance);
            return true;
        }
    }
}

