/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.traversing;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.CapacityExceededException;
import org.eclipse.serializer.collections.interfaces.CapacityExtendable;
import org.eclipse.serializer.collections.old.OldCollection;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XImmutableSet;
import org.eclipse.serializer.collections.types.XSet;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.meta.NotImplementedYetError;

public final class OpenAdressingMiniSet<E>
implements XSet<E> {
    private static final int DEFAULT_INITIAL_CAPACITY = 32;
    private static final float DEFAULT_HASH_DENSITY = 1.0f;
    private final float hashDensity;
    private int size = 0;
    private int hashRange;
    private int capacity;
    private E[] hashtable;

    private static int padHashLength(int minimalHashLength) {
        if (XMath.isGreaterThanHighestPowerOf2(minimalHashLength)) {
            return Integer.MAX_VALUE;
        }
        int capacity = 1;
        while (capacity < minimalHashLength) {
            capacity <<= 1;
        }
        return capacity;
    }

    private static int calculateHashRange(int slotLength) {
        return slotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : slotLength - 1;
    }

    private static <E> E[] newArray(int length) {
        return new Object[length];
    }

    public static <E> OpenAdressingMiniSet<E> New() {
        return new OpenAdressingMiniSet<E>(32, 1.0f);
    }

    public static <E> OpenAdressingMiniSet<E> New(int initialCapacity) {
        return new OpenAdressingMiniSet<E>(initialCapacity, 1.0f);
    }

    public static <E> OpenAdressingMiniSet<E> New(XGettingCollection<? extends E> elements) {
        OpenAdressingMiniSet<E> set = OpenAdressingMiniSet.New(elements.intSize());
        for (E element : elements) {
            set.add(element);
        }
        return set;
    }

    OpenAdressingMiniSet(int initialCapacity, float hashDensity) {
        this.hashtable = OpenAdressingMiniSet.newArray(OpenAdressingMiniSet.padHashLength(initialCapacity));
        this.hashRange = OpenAdressingMiniSet.calculateHashRange(this.hashtable.length);
        this.hashDensity = hashDensity;
        this.capacity = this.calculateCapacity(this.hashtable.length);
    }

    private int calculateCapacity(int slotLength) {
        return slotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)((float)slotLength * this.hashDensity);
    }

    private final void rebuildStorage(int newSlotLength) {
        int newHashRange = OpenAdressingMiniSet.calculateHashRange(newSlotLength);
        E[] newHashTable = OpenAdressingMiniSet.newArray(newSlotLength);
        E[] EArray = this.hashtable;
        int n = this.hashtable.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                E element = EArray[n2];
                int i = (System.identityHashCode(element) & newHashRange) + 1;
                while (--i >= 0) {
                    if (newHashTable[i] != null) continue;
                    newHashTable[i] = element;
                    break block3;
                }
                i = (System.identityHashCode(element) & newHashRange) - 1;
                while (++i < newSlotLength) {
                    if (newHashTable[i] != null) continue;
                    newHashTable[i] = element;
                    break block3;
                }
                throw new Error("Rebuilding Error");
            }
            ++n2;
        }
        this.capacity = this.calculateCapacity(newSlotLength);
        this.hashtable = newHashTable;
        this.hashRange = newHashRange;
    }

    private void increaseStorage() {
        this.rebuildStorage((int)((float)this.hashtable.length * 2.0f));
    }

    private void guaranteedAddNew(E element) {
        E[] hashtable = this.hashtable;
        int i = (System.identityHashCode(element) & this.hashRange) + 1;
        while (--i >= 0) {
            if (hashtable[i] != null) continue;
            this.addnew(hashtable, i, element);
            return;
        }
        i = (System.identityHashCode(element) & this.hashRange) - 1;
        int length = hashtable.length;
        while (++i < length) {
            if (hashtable[i] != null) continue;
            this.addnew(hashtable, i, element);
            return;
        }
    }

    private void enlargeForNewElement(E element) {
        this.increaseStorage();
        this.guaranteedAddNew(element);
    }

    private void addnew(E[] hashtable, int i, E element) {
        hashtable[i] = element;
        if (++this.size >= this.capacity) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new CapacityExceededException();
            }
            this.increaseStorage();
        }
    }

    @Override
    public final boolean add(E element) {
        E[] hashtable = this.hashtable;
        int i = (System.identityHashCode(element) & this.hashRange) + 1;
        while (--i >= 0) {
            if (hashtable[i] == element) {
                return false;
            }
            if (hashtable[i] != null) continue;
            this.addnew(hashtable, i, element);
            return true;
        }
        i = (System.identityHashCode(element) & this.hashRange) - 1;
        int length = hashtable.length;
        while (++i < length) {
            if (hashtable[i] == element) {
                return false;
            }
            if (hashtable[i] != null) continue;
            this.addnew(hashtable, i, element);
            return true;
        }
        this.enlargeForNewElement(element);
        return true;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public E get() {
        throw new NotImplementedYetError();
    }

    @Override
    public Iterator<E> iterator() {
        throw new NotImplementedYetError();
    }

    @Override
    public Object[] toArray() {
        throw new NotImplementedYetError();
    }

    @Override
    public E[] toArray(Class<E> type) {
        throw new NotImplementedYetError();
    }

    @Override
    public OldCollection<E> old() {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean hasVolatileElements() {
        throw new NotImplementedYetError();
    }

    @Override
    public Equalator<? super E> equality() {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        throw new NotImplementedYetError();
    }

    @Override
    public XGettingCollection<E> view() {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean nullContained() {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean containsId(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean contains(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean containsSearched(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean containsAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean applies(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public long count(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public long countBy(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public E search(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public E seek(E sample) {
        throw new NotImplementedYetError();
    }

    @Override
    public E max(Comparator<? super E> comparator) {
        throw new NotImplementedYetError();
    }

    @Override
    public E min(Comparator<? super E> comparator) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T distinct(T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T distinct(T target, Equalator<? super E> equalator) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T copyTo(T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T filterTo(T target, Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public <P extends Consumer<? super E>> P iterate(P procedure) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean nullAllowed() {
        throw new NotImplementedYetError();
    }

    @Override
    public long maximumCapacity() {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean nullAdd() {
        throw new NotImplementedYetError();
    }

    @Override
    public CapacityExtendable ensureCapacity(long minimalCapacity) {
        throw new NotImplementedYetError();
    }

    @Override
    public CapacityExtendable ensureFreeCapacity(long minimalFreeCapacity) {
        throw new NotImplementedYetError();
    }

    @Override
    public long currentCapacity() {
        throw new NotImplementedYetError();
    }

    @Override
    public long optimize() {
        throw new NotImplementedYetError();
    }

    @Override
    public void accept(E t) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean put(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean nullPut() {
        throw new NotImplementedYetError();
    }

    @Override
    public E fetch() {
        throw new NotImplementedYetError();
    }

    @Override
    public E pinch() {
        throw new NotImplementedYetError();
    }

    @Override
    public E retrieve(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public E retrieveBy(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public long removeDuplicates(Equalator<? super E> equalator) {
        throw new NotImplementedYetError();
    }

    @Override
    public long removeBy(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public <P extends Consumer<? super E>> P process(P processor) {
        throw new NotImplementedYetError();
    }

    @Override
    public void clear() {
        throw new NotImplementedYetError();
    }

    @Override
    public void truncate() {
        throw new NotImplementedYetError();
    }

    @Override
    public long consolidate() {
        throw new NotImplementedYetError();
    }

    @Override
    public long nullRemove() {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean removeOne(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public long remove(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public long removeAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public long retainAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public long removeDuplicates() {
        throw new NotImplementedYetError();
    }

    @Override
    public E addGet(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public E deduplicate(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public E putGet(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public E replace(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public XImmutableSet<E> immure() {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final XSet<E> putAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public XSet<E> putAll(E[] elements, int srcStartIndex, int srcLength) {
        throw new NotImplementedYetError();
    }

    @Override
    public XSet<E> putAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final XSet<E> addAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public XSet<E> addAll(E[] elements, int srcStartIndex, int srcLength) {
        throw new NotImplementedYetError();
    }

    @Override
    public XSet<E> addAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public XSet<E> copy() {
        throw new NotImplementedYetError();
    }

    public String toString() {
        return super.toString();
    }
}

