/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.traversing;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XSet;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.traversing.AbstractReferenceHandler;
import org.eclipse.serializer.util.traversing.MutationListener;
import org.eclipse.serializer.util.traversing.ObjectGraphTraverserBuilder;
import org.eclipse.serializer.util.traversing.OpenAdressingMiniSet;
import org.eclipse.serializer.util.traversing.TraversalAcceptor;
import org.eclipse.serializer.util.traversing.TraversalMode;
import org.eclipse.serializer.util.traversing.TraversalMutator;
import org.eclipse.serializer.util.traversing.TraversalPredicateFull;
import org.eclipse.serializer.util.traversing.TraversalPredicateLeaf;
import org.eclipse.serializer.util.traversing.TraversalPredicateNode;
import org.eclipse.serializer.util.traversing.TraversalPredicateSkip;
import org.eclipse.serializer.util.traversing.TraversalReferenceHandlerProvider;
import org.eclipse.serializer.util.traversing.TraversalSignalAbort;
import org.eclipse.serializer.util.traversing.TypeTraverserProvider;

public interface ObjectGraphTraverser {
    public void traverse();

    default public void traverse(Object instance) {
        this.traverseAll(X.array(instance));
    }

    public void traverseAll(Object[] var1);

    public <A extends TraversalAcceptor> A traverse(A var1);

    public <M extends TraversalMutator> M traverse(M var1);

    default public <A extends TraversalAcceptor> A traverse(Object instance, A acceptor) {
        this.traverseAll(X.array(instance), (TraversalMutator)((Object)acceptor));
        return acceptor;
    }

    default public <C extends Consumer<Object>> C traverse(Object instance, C logic) {
        this.traverse(instance, (Function)((Object)TraversalAcceptor.New(logic)));
        return logic;
    }

    default public <M extends TraversalMutator> M traverse(Object instance, M acceptor) {
        this.traverseAll(X.array(instance), acceptor);
        return acceptor;
    }

    default public <F extends Function<Object, Object>> F traverse(Object instance, F logic) {
        this.traverse(instance, (F)((Object)TraversalMutator.New(logic)));
        return logic;
    }

    public <A extends TraversalAcceptor> A traverseAll(Object[] var1, A var2);

    public <M extends TraversalMutator> M traverseAll(Object[] var1, M var2);

    public static void signalAbortTraversal() throws TraversalSignalAbort {
        TraversalSignalAbort.fire();
    }

    public static ObjectGraphTraverserBuilder Builder() {
        return new ObjectGraphTraverserBuilder.Default();
    }

    public static ObjectGraphTraverser New(Object[] roots, XGettingCollection<Object> skipped, Function<XGettingCollection<Object>, XSet<Object>> alreadyHandledProvider, TraversalReferenceHandlerProvider referenceHandlerProvider, TypeTraverserProvider traverserProvider, TraversalPredicateSkip predicateSkip, TraversalPredicateNode predicateNode, TraversalPredicateLeaf predicateLeaf, TraversalPredicateFull predicateFull, Predicate<Object> predicateHandle, TraversalAcceptor traversalAcceptor, TraversalMutator traversalMutator, MutationListener mutationListener, TraversalMode traversalMode, Runnable initializerLogic, Runnable finalizerLogic) {
        return new Default(roots, ((XGettingCollection)X.coalesce(skipped, X.empty())).immure(), X.coalesce(alreadyHandledProvider, s -> OpenAdressingMiniSet.New(s)), referenceHandlerProvider, X.notNull(traverserProvider), predicateSkip, predicateNode, predicateLeaf, predicateFull, predicateHandle, traversalAcceptor, traversalMutator, mutationListener, traversalMode, initializerLogic, finalizerLogic);
    }

    public static final class Default
    implements ObjectGraphTraverser {
        private final Object[] roots;
        private final XGettingCollection<Object> skipped;
        private final Function<XGettingCollection<Object>, XSet<Object>> alreadyHandledProvider;
        private final TraversalPredicateSkip predicateSkip;
        private final TraversalPredicateNode predicateNode;
        private final TraversalPredicateLeaf predicateLeaf;
        private final TraversalPredicateFull predicateFull;
        private final Predicate<Object> predicateHandle;
        private final TraversalAcceptor traversalAcceptor;
        private final TraversalMutator traversalMutator;
        private final TraversalReferenceHandlerProvider referenceHandlerProvider;
        private final TypeTraverserProvider traverserProvider;
        private final MutationListener mutationListener;
        private final TraversalMode traversalMode;
        private final Runnable initializerLogic;
        private final Runnable finalizerLogic;
        static final int SEGMENT_SIZE = 500;
        static final int SEGMENT_LAST_INDEX = 499;
        static final int SEGMENT_LENGTH = 501;

        Default(Object[] roots, XGettingCollection<Object> skipped, Function<XGettingCollection<Object>, XSet<Object>> alreadyHandledProvider, TraversalReferenceHandlerProvider referenceHandlerProvider, TypeTraverserProvider traverserProvider, TraversalPredicateSkip predicateSkip, TraversalPredicateNode predicateNode, TraversalPredicateLeaf predicateLeaf, TraversalPredicateFull predicateFull, Predicate<Object> predicateHandle, TraversalAcceptor traversalAcceptor, TraversalMutator traversalMutator, MutationListener mutationListener, TraversalMode traversalMode, Runnable initializerLogic, Runnable finalizerLogic) {
            this.roots = roots;
            this.skipped = skipped;
            this.alreadyHandledProvider = alreadyHandledProvider;
            this.predicateSkip = predicateSkip;
            this.predicateNode = predicateNode;
            this.predicateLeaf = predicateLeaf;
            this.predicateFull = predicateFull;
            this.predicateHandle = predicateHandle;
            this.traversalAcceptor = traversalAcceptor;
            this.traversalMutator = traversalMutator;
            this.referenceHandlerProvider = referenceHandlerProvider;
            this.traverserProvider = traverserProvider;
            this.mutationListener = mutationListener;
            this.traversalMode = traversalMode;
            this.initializerLogic = initializerLogic;
            this.finalizerLogic = finalizerLogic;
        }

        protected final synchronized void internalTraverseAll(Object[] instances, TraversalAcceptor traversalAcceptor, TraversalMutator traversalMutator, MutationListener mutationListener) {
            if (this.initializerLogic != null) {
                this.initializerLogic.run();
            }
            AbstractReferenceHandler referenceHandler = this.referenceHandlerProvider.provideReferenceHandler(this.alreadyHandledProvider.apply(this.skipped), this.traverserProvider, this.predicateSkip, this.predicateNode, this.predicateLeaf, this.predicateFull, this.predicateHandle, traversalAcceptor, traversalMutator, mutationListener);
            this.traversalMode.handle(instances, referenceHandler);
            if (this.finalizerLogic != null) {
                this.finalizerLogic.run();
            }
        }

        @Override
        public void traverse() {
            this.internalTraverseAll(this.roots, this.traversalAcceptor, this.traversalMutator, this.mutationListener);
        }

        @Override
        public void traverseAll(Object[] instances) {
            this.internalTraverseAll(instances, this.traversalAcceptor, this.traversalMutator, this.mutationListener);
        }

        @Override
        public <A extends TraversalAcceptor> A traverse(A acceptor) {
            this.internalTraverseAll(this.roots, acceptor, null, null);
            return acceptor;
        }

        @Override
        public <M extends TraversalMutator> M traverse(M mutator) {
            this.internalTraverseAll(this.roots, null, mutator, null);
            return mutator;
        }

        @Override
        public <A extends TraversalAcceptor> A traverseAll(Object[] instances, A acceptor) {
            this.internalTraverseAll(instances, acceptor, null, null);
            return acceptor;
        }

        @Override
        public <M extends TraversalMutator> M traverseAll(Object[] instances, M mutator) {
            this.internalTraverseAll(instances, null, mutator, null);
            return mutator;
        }

        static final Object[] createIterationSegment() {
            return new Object[501];
        }
    }
}

