/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.traversing;

import java.util.function.Predicate;
import org.eclipse.serializer.collections.types.XSet;
import org.eclipse.serializer.util.traversing.ObjectGraphTraverser;
import org.eclipse.serializer.util.traversing.TraversalPredicateFull;
import org.eclipse.serializer.util.traversing.TraversalPredicateLeaf;
import org.eclipse.serializer.util.traversing.TraversalPredicateNode;
import org.eclipse.serializer.util.traversing.TraversalPredicateSkip;
import org.eclipse.serializer.util.traversing.TraversalReferenceHandler;
import org.eclipse.serializer.util.traversing.TraversalSignalAbort;
import org.eclipse.serializer.util.traversing.TypeTraverser;
import org.eclipse.serializer.util.traversing.TypeTraverserProvider;

public abstract class AbstractReferenceHandlerOld
implements TraversalReferenceHandler {
    final TypeTraverserProvider traverserProvider;
    final XSet<Object> alreadyHandled;
    final TraversalPredicateSkip predicateSkip;
    final TraversalPredicateNode predicateNode;
    final TraversalPredicateLeaf predicateLeaf;
    final TraversalPredicateFull predicateFull;
    final Predicate<Object> predicateHandle;
    Object[] iterationTail = ObjectGraphTraverser.Default.createIterationSegment();
    Object[] iterationHead = this.iterationTail;
    boolean tailIsHead = true;
    int iterationTailIndex;
    int iterationHeadIndex;

    AbstractReferenceHandlerOld(TypeTraverserProvider traverserProvider, XSet<Object> alreadyHandled, TraversalPredicateSkip predicateSkip, TraversalPredicateNode predicateNode, TraversalPredicateLeaf predicateLeaf, TraversalPredicateFull predicateFull, Predicate<Object> predicateHandle) {
        this.traverserProvider = traverserProvider;
        this.alreadyHandled = alreadyHandled;
        this.predicateSkip = predicateSkip;
        this.predicateNode = predicateNode;
        this.predicateLeaf = predicateLeaf;
        this.predicateFull = predicateFull;
        this.predicateHandle = predicateHandle;
    }

    @Override
    public final boolean skip(Object instance) {
        return this.alreadyHandled.add(instance);
    }

    final void increaseIterationQueue() {
        Object[] nextIterationSegment;
        this.iterationHead[500] = nextIterationSegment = ObjectGraphTraverser.Default.createIterationSegment();
        this.iterationHead = nextIterationSegment;
        this.iterationHeadIndex = 0;
        this.tailIsHead = false;
    }

    @Override
    public final void enqueue(Object instance) {
        if (instance == null) {
            return;
        }
        if (!this.alreadyHandled.add(instance)) {
            return;
        }
        if (this.predicateSkip != null && this.predicateSkip.skip(instance)) {
            return;
        }
        if (this.iterationHeadIndex >= 500) {
            this.increaseIterationQueue();
        }
        this.iterationHead[this.iterationHeadIndex++] = instance;
    }

    private Object dequeue() {
        if (this.tailIsHead) {
            this.checkForCompletion();
        }
        if (this.iterationTailIndex >= 500) {
            this.advanceSegment();
        }
        return this.iterationTail[this.iterationTailIndex++];
    }

    final void checkForCompletion() {
        if (this.iterationTailIndex >= this.iterationHeadIndex) {
            ObjectGraphTraverser.signalAbortTraversal();
        }
    }

    final void advanceSegment() {
        this.iterationTail = (Object[])this.iterationTail[500];
        this.iterationTailIndex = 0;
        this.tailIsHead = this.iterationTail == this.iterationHead;
    }

    private void enqueueAll(Object[] instances) {
        Object[] objectArray = instances;
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            Object instance = objectArray[n2];
            this.enqueue(instance);
            ++n2;
        }
    }

    @Override
    public final void handleAsFull(Object[] instances) {
        this.enqueueAll(instances);
        try {
            while (true) {
                Object instance = this.dequeue();
                if (this.predicateHandle != null && !this.predicateHandle.test(instance)) continue;
                TypeTraverser<Object> traverser = this.traverserProvider.provide(instance);
                if (this.predicateLeaf != null && this.predicateLeaf.isLeaf(instance)) {
                    this.handleLeaf(instance, traverser);
                    continue;
                }
                if (this.predicateNode != null && this.predicateNode.isNode(instance)) {
                    this.handleNode(instance, traverser);
                    continue;
                }
                this.handleFull(instance, traverser);
            }
        }
        catch (TraversalSignalAbort s) {
            return;
        }
    }

    @Override
    public final void handleAsNode(Object[] instances) {
        this.enqueueAll(instances);
        try {
            while (true) {
                Object instance = this.dequeue();
                if (this.predicateHandle != null && !this.predicateHandle.test(instance)) continue;
                TypeTraverser<Object> traverser = this.traverserProvider.provide(instance);
                if (this.predicateFull != null && this.predicateFull.isFull(instance)) {
                    this.handleFull(instance, traverser);
                    continue;
                }
                if (this.predicateLeaf != null && this.predicateLeaf.isLeaf(instance)) {
                    this.handleLeaf(instance, traverser);
                    continue;
                }
                this.handleNode(instance, traverser);
            }
        }
        catch (TraversalSignalAbort s) {
            return;
        }
    }

    @Override
    public final void handleAsLeaf(Object[] instances) {
        this.enqueueAll(instances);
        try {
            while (true) {
                Object instance = this.dequeue();
                if (this.predicateHandle != null && !this.predicateHandle.test(instance)) continue;
                TypeTraverser<Object> traverser = this.traverserProvider.provide(instance);
                if (this.predicateFull != null && this.predicateFull.isFull(instance)) {
                    this.handleFull(instance, traverser);
                    continue;
                }
                if (this.predicateNode != null && this.predicateNode.isNode(instance)) {
                    this.handleNode(instance, traverser);
                    continue;
                }
                this.handleLeaf(instance, traverser);
            }
        }
        catch (TraversalSignalAbort s) {
            return;
        }
    }

    abstract <T> void handleFull(T var1, TypeTraverser<T> var2);

    abstract <T> void handleLeaf(T var1, TypeTraverser<T> var2);

    final <T> void handleNode(T instance, TypeTraverser<T> traverser) {
        traverser.traverseReferences(instance, this);
    }
}

