/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.traversing;

import java.util.function.Predicate;
import org.eclipse.serializer.collections.types.XSet;
import org.eclipse.serializer.util.traversing.ObjectGraphTraverser;
import org.eclipse.serializer.util.traversing.TraversalPredicateFull;
import org.eclipse.serializer.util.traversing.TraversalPredicateLeaf;
import org.eclipse.serializer.util.traversing.TraversalPredicateNode;
import org.eclipse.serializer.util.traversing.TraversalPredicateSkip;
import org.eclipse.serializer.util.traversing.TraversalReferenceHandler;
import org.eclipse.serializer.util.traversing.TraversalSignalAbort;
import org.eclipse.serializer.util.traversing.TypeTraverser;
import org.eclipse.serializer.util.traversing.TypeTraverserProvider;

public abstract class AbstractReferenceHandler
implements TraversalReferenceHandler {
    static final int SEGMENT_SIZE = 50;
    final TypeTraverserProvider traverserProvider;
    final XSet<Object> alreadyHandled;
    final TraversalPredicateSkip predicateSkip;
    final TraversalPredicateNode predicateNode;
    final TraversalPredicateLeaf predicateLeaf;
    final TraversalPredicateFull predicateFull;
    final Predicate<Object> predicateHandle;
    Object[] head;
    Object[] lastHead;
    Object[] enqueueSegment;
    int enqueueIndex;
    int dequeueIndex;

    static final Object[] createIterationSegment() {
        return new Object[51];
    }

    AbstractReferenceHandler(TypeTraverserProvider traverserProvider, XSet<Object> alreadyHandled, TraversalPredicateSkip predicateSkip, TraversalPredicateNode predicateNode, TraversalPredicateLeaf predicateLeaf, TraversalPredicateFull predicateFull, Predicate<Object> predicateHandle) {
        this.traverserProvider = traverserProvider;
        this.alreadyHandled = alreadyHandled;
        this.predicateSkip = predicateSkip;
        this.predicateNode = predicateNode;
        this.predicateLeaf = predicateLeaf;
        this.predicateFull = predicateFull;
        this.predicateHandle = predicateHandle;
        this.head = AbstractReferenceHandler.createIterationSegment();
        this.enqueueSegment = this.head;
        this.lastHead = AbstractReferenceHandler.createIterationSegment();
        AbstractReferenceHandler.setNextSegment(this.enqueueSegment, this.lastHead);
        this.enqueueIndex = -1;
        this.dequeueIndex = 50;
    }

    @Override
    public final boolean skip(Object instance) {
        return this.alreadyHandled.add(instance);
    }

    private static void setNextSegment(Object[] previousSegment, Object[] nextSegment) {
        previousSegment[50] = nextSegment;
    }

    private static Object[] getNextSegment(Object[] previousSegment) {
        return (Object[])previousSegment[50];
    }

    @Override
    public final void enqueue(Object instance) {
        if (instance == null) {
            return;
        }
        if (!this.alreadyHandled.add(instance)) {
            return;
        }
        if (this.predicateSkip != null && this.predicateSkip.skip(instance)) {
            return;
        }
        if (++this.enqueueIndex >= 50) {
            this.addEnqueuingSegment();
        }
        this.enqueueSegment[this.enqueueIndex] = instance;
    }

    final void addEnqueuingSegment() {
        Object[] newSegment = AbstractReferenceHandler.createIterationSegment();
        if (this.lastHead == null) {
            this.lastHead = this.head;
            this.head = newSegment;
            this.dequeueIndex = 50;
        } else {
            AbstractReferenceHandler.setNextSegment(this.enqueueSegment, newSegment);
        }
        AbstractReferenceHandler.setNextSegment(newSegment, this.lastHead);
        this.enqueueSegment = newSegment;
        this.enqueueIndex = 0;
    }

    private void scrollToNextDequeueItem() {
        Object[] seg = this.head;
        int i = this.dequeueIndex;
        while (++i < 50) {
            if (seg[i] == null) continue;
            this.dequeueIndex = i;
            return;
        }
        this.advanceHeadSegment(AbstractReferenceHandler.getNextSegment(this.head));
    }

    private Object dequeue() {
        if (++this.dequeueIndex >= 50) {
            this.updateDequeueSegment();
        }
        if (this.head[this.dequeueIndex] == null) {
            this.scrollToNextDequeueItem();
        }
        Object next = this.head[this.dequeueIndex];
        this.head[this.dequeueIndex] = null;
        return next;
    }

    private void updateDequeueSegment() {
        if (this.lastHead != null) {
            this.dequeueIndex = 0;
            this.lastHead = null;
            this.enqueueIndex = 50;
            this.enqueueSegment = null;
        } else {
            this.advanceHeadSegment(AbstractReferenceHandler.getNextSegment(this.head));
        }
    }

    final void advanceHeadSegment(Object[] passed) {
        Object[] seg = passed;
        block0: while (true) {
            if (seg == null) {
                ObjectGraphTraverser.signalAbortTraversal();
                return;
            }
            if (seg[0] != null) {
                this.dequeueIndex = 0;
                break;
            }
            int i = 0;
            while (++i < 50) {
                if (seg[i] == null) continue;
                this.dequeueIndex = i;
                break block0;
            }
            seg = AbstractReferenceHandler.getNextSegment(seg);
        }
        this.head = seg;
    }

    private void enqueueAll(Object[] instances) {
        Object[] objectArray = instances;
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            Object instance = objectArray[n2];
            this.enqueue(instance);
            ++n2;
        }
    }

    @Override
    public final void handleAsFull(Object[] instances) {
        this.enqueueAll(instances);
        try {
            while (true) {
                Object instance = this.dequeue();
                if (this.predicateHandle != null && !this.predicateHandle.test(instance)) continue;
                TypeTraverser<Object> traverser = this.traverserProvider.provide(instance);
                if (this.predicateLeaf != null && this.predicateLeaf.isLeaf(instance)) {
                    this.handleLeaf(instance, traverser);
                    continue;
                }
                if (this.predicateNode != null && this.predicateNode.isNode(instance)) {
                    this.handleNode(instance, traverser);
                    continue;
                }
                this.handleFull(instance, traverser);
            }
        }
        catch (TraversalSignalAbort s) {
            return;
        }
    }

    @Override
    public final void handleAsNode(Object[] instances) {
        this.enqueueAll(instances);
        try {
            while (true) {
                Object instance = this.dequeue();
                if (this.predicateHandle != null && !this.predicateHandle.test(instance)) continue;
                TypeTraverser<Object> traverser = this.traverserProvider.provide(instance);
                if (this.predicateFull != null && this.predicateFull.isFull(instance)) {
                    this.handleFull(instance, traverser);
                    continue;
                }
                if (this.predicateLeaf != null && this.predicateLeaf.isLeaf(instance)) {
                    this.handleLeaf(instance, traverser);
                    continue;
                }
                this.handleNode(instance, traverser);
            }
        }
        catch (TraversalSignalAbort s) {
            return;
        }
    }

    @Override
    public final void handleAsLeaf(Object[] instances) {
        this.enqueueAll(instances);
        try {
            while (true) {
                Object instance = this.dequeue();
                if (this.predicateHandle != null && !this.predicateHandle.test(instance)) continue;
                TypeTraverser<Object> traverser = this.traverserProvider.provide(instance);
                if (this.predicateFull != null && this.predicateFull.isFull(instance)) {
                    this.handleFull(instance, traverser);
                    continue;
                }
                if (this.predicateNode != null && this.predicateNode.isNode(instance)) {
                    this.handleNode(instance, traverser);
                    continue;
                }
                this.handleLeaf(instance, traverser);
            }
        }
        catch (TraversalSignalAbort s) {
            return;
        }
    }

    abstract <T> void handleFull(T var1, TypeTraverser<T> var2);

    abstract <T> void handleLeaf(T var1, TypeTraverser<T> var2);

    final <T> void handleNode(T instance, TypeTraverser<T> traverser) {
        traverser.traverseReferences(instance, this);
    }
}

