/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.similarity;

import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.util.similarity.MatchValidator;
import org.eclipse.serializer.util.similarity.MultiMatch;
import org.eclipse.serializer.util.similarity.Similator;

public interface MultiMatcher<E> {
    public double similarityThreshold();

    public double singletonPrecedenceThreshold();

    public double singletonPrecedenceBonus();

    public double noiseFactor();

    public Equalator<? super E> equalator();

    public Similator<? super E> similator();

    public MatchValidator<? super E> validator();

    public MultiMatcher<E> setSimilarityThreshold(double var1);

    public MultiMatcher<E> setSingletonPrecedenceThreshold(double var1);

    public MultiMatcher<E> setSingletonPrecedenceBonus(double var1);

    public MultiMatcher<E> setNoisefactor(double var1);

    public MultiMatcher<E> setSimilator(Similator<? super E> var1);

    public MultiMatcher<E> setEqualator(Equalator<? super E> var1);

    public MultiMatcher<E> setValidator(MatchValidator<? super E> var1);

    public MultiMatch<E> match(XGettingCollection<? extends E> var1, XGettingCollection<? extends E> var2);

    public static double defaultSimilarityThreshold() {
        return 0.5;
    }

    public static double defaultSingletonPrecedenceThreshold() {
        return 0.9;
    }

    public static double defaultSingletonPrecedenceBonus() {
        return 0.75;
    }

    public static double defaultNoiseFactor() {
        return 0.5;
    }

    public static <E> MultiMatcher<E> New() {
        return new Default();
    }

    public static class Default<E>
    implements MultiMatcher<E> {
        private Equalator<? super E> equalator;
        private Similator<? super E> similator;
        private MatchValidator<? super E> validator;
        private double similarityThreshold = MultiMatcher.defaultSimilarityThreshold();
        private double singletonPrecedenceThreshold = MultiMatcher.defaultSingletonPrecedenceThreshold();
        private double singletonPrecedenceBonus = MultiMatcher.defaultSingletonPrecedenceBonus();
        private double noiseFactor = MultiMatcher.defaultNoiseFactor();

        protected Default() {
        }

        @Override
        public double similarityThreshold() {
            return this.similarityThreshold;
        }

        @Override
        public double singletonPrecedenceThreshold() {
            return this.singletonPrecedenceThreshold;
        }

        @Override
        public double singletonPrecedenceBonus() {
            return this.singletonPrecedenceBonus;
        }

        @Override
        public double noiseFactor() {
            return this.noiseFactor;
        }

        @Override
        public Equalator<? super E> equalator() {
            return this.equalator;
        }

        @Override
        public Similator<? super E> similator() {
            return this.similator;
        }

        @Override
        public MatchValidator<? super E> validator() {
            return this.validator;
        }

        @Override
        public MultiMatcher<E> setSimilarityThreshold(double similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
            return this;
        }

        @Override
        public MultiMatcher<E> setSingletonPrecedenceThreshold(double singletonPrecedenceThreshold) {
            this.singletonPrecedenceThreshold = singletonPrecedenceThreshold;
            return this;
        }

        @Override
        public MultiMatcher<E> setSingletonPrecedenceBonus(double singletonPrecedenceBonus) {
            this.singletonPrecedenceBonus = singletonPrecedenceBonus;
            return this;
        }

        @Override
        public MultiMatcher<E> setNoisefactor(double noiseFactor) {
            this.noiseFactor = noiseFactor;
            return this;
        }

        @Override
        public MultiMatcher<E> setSimilator(Similator<? super E> similator) {
            this.similator = similator;
            return this;
        }

        @Override
        public MultiMatcher<E> setEqualator(Equalator<? super E> equalator) {
            this.equalator = equalator;
            return this;
        }

        @Override
        public MultiMatcher<E> setValidator(MatchValidator<? super E> validator) {
            this.validator = validator;
            return this;
        }

        @Override
        public MultiMatch<E> match(XGettingCollection<? extends E> source, XGettingCollection<? extends E> target) {
            return new MultiMatch.Default<Object>(this, source.toArray(), target.toArray()).match();
        }
    }
}

