/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.iterables;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.exceptions.IndexBoundsException;
import org.eclipse.serializer.typing.XTypes;

public class ReadOnlyListIterator<E>
implements ListIterator<E> {
    private final XGettingSequence<E> subject;
    private int index;

    public ReadOnlyListIterator(XGettingSequence<E> list) throws IndexBoundsException {
        this.subject = list;
        this.index = 0;
    }

    public ReadOnlyListIterator(XGettingSequence<E> list, int index) throws IndexBoundsException {
        this.subject = list;
        if (index < 0 || index >= XTypes.to_int(list.size())) {
            throw new IndexBoundsException((long)XTypes.to_int(list.size()), index);
        }
        this.index = index;
    }

    @Override
    public void add(E e) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.index < XTypes.to_int(this.subject.size());
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0 && this.index <= XTypes.to_int(this.subject.size());
    }

    @Override
    public E next() throws NoSuchElementException {
        try {
            int i = this.index;
            E e = this.subject.at(i);
            this.index = i + 1;
            return e;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public E previous() throws NoSuchElementException {
        try {
            return this.subject.at(--this.index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void remove() throws NoSuchElementException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E e) throws NoSuchElementException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

