/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.cql;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.types.XIterable;
import org.eclipse.serializer.collections.types.XSequence;
import org.eclipse.serializer.util.cql.CQL;
import org.eclipse.serializer.util.cql.CqlIteration;
import org.eclipse.serializer.util.cql.CqlQuery;
import org.eclipse.serializer.util.cql.CqlResultor;

public interface CqlTransfer<I, R extends XIterable<I>>
extends CqlIteration<I, I, R> {
    @Override
    default public CqlTransfer<I, R> skip(Number count) {
        return CqlTransfer.New(this.getSource(), CQL.asLong(count), this.getLimit(), this.getSelector(), this.getOrder(), this.getResultor());
    }

    @Override
    default public CqlTransfer<I, R> limit(Number count) {
        return CqlTransfer.New(this.getSource(), this.getSkip(), CQL.asLong(count), this.getSelector(), this.getOrder(), this.getResultor());
    }

    default public CqlTransfer<I, R> from(XIterable<? extends I> source) {
        return CqlTransfer.New(source, this.getSkip(), this.getLimit(), this.getSelector(), this.getOrder(), this.getResultor());
    }

    default public CqlTransfer<I, R> orderBy(Comparator<? super I> order) {
        return CqlTransfer.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), order, this.getResultor());
    }

    default public CqlTransfer<I, R> select(Predicate<? super I> selector) {
        return CqlTransfer.New(this.getSource(), this.getSkip(), this.getLimit(), selector, this.getOrder(), this.getResultor());
    }

    @Override
    default public R execute() {
        return (R)this.executeOn(CQL.prepareSource(this.getSource()));
    }

    @Override
    default public <P extends Consumer<? super I>> P iterate(P procedure) {
        this.execute().iterate(procedure);
        return procedure;
    }

    @Override
    default public R executeOn(XIterable<? extends I> source) {
        return (R)((XIterable)CQL.executeQuery(source, this.getSkip(), this.getLimit(), this.getSelector(), this.getResultor(), this.getOrder()));
    }

    @Override
    default public <P extends Consumer<I>> P executeInto(XIterable<? extends I> source, P target) {
        return this.executeSelection(source, target);
    }

    public static <I> CqlTransfer<I, XSequence<I>> New() {
        return new Default(null, null, null, null, null, null);
    }

    public static <I> CqlTransfer<I, XSequence<I>> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Comparator<? super I> order) {
        return new Default(source, skip, limit, selector, order, CqlResultor.New());
    }

    public static <I, T extends Consumer<I> & XIterable<I>> CqlTransfer<I, T> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Comparator<? super I> order, T target) {
        return new Default<I, T>(source, skip, limit, selector, order, CqlResultor.New(target));
    }

    public static <I, R extends XIterable<I>> CqlTransfer<I, R> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Comparator<? super I> order, CqlResultor<I, R> resultor) {
        return new Default<I, R>(source, skip, limit, selector, order, resultor);
    }

    public static final class Default<I, R extends XIterable<I>>
    extends CqlQuery.Abstract<I, I, R>
    implements CqlTransfer<I, R> {
        Default(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Comparator<? super I> order, CqlResultor<I, R> resultor) {
            super(source, skip, limit, selector, Function.identity(), order, resultor);
        }
    }
}

