/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.cql;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.types.XIterable;
import org.eclipse.serializer.collections.types.XSequence;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.cql.CQL;
import org.eclipse.serializer.util.cql.CqlAggregation;
import org.eclipse.serializer.util.cql.CqlProjection;
import org.eclipse.serializer.util.cql.CqlQuery;
import org.eclipse.serializer.util.cql.CqlResultor;
import org.eclipse.serializer.util.cql.CqlTransfer;

public interface CqlSelection<I>
extends CqlProjection<I, I>,
CqlTransfer<I, XSequence<I>> {
    @Override
    default public CqlSelection<I> skip(Number count) {
        return CqlSelection.New(this.getSource(), CQL.asLong(count), this.getLimit(), this.getSelector(), this.getOrder(), this.getResultor());
    }

    @Override
    default public CqlSelection<I> limit(Number count) {
        return CqlSelection.New(this.getSource(), this.getSkip(), CQL.asLong(count), this.getSelector(), this.getOrder(), this.getResultor());
    }

    default public CqlSelection<I> select(Predicate<? super I> selector) {
        return CqlSelection.New(this.getSource(), this.getSkip(), this.getLimit(), selector, this.getOrder(), this.getResultor());
    }

    default public CqlSelection<I> from(XIterable<? extends I> source) {
        return CqlSelection.New(source, this.getSkip(), this.getLimit(), this.getSelector(), this.getOrder(), this.getResultor());
    }

    default public CqlSelection<I> orderBy(Comparator<? super I> order) {
        return CqlSelection.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), order, this.getResultor());
    }

    default public <P extends Consumer<I> & XIterable<I>> CqlTransfer<I, P> into(P target) {
        return CqlTransfer.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getOrder(), CqlResultor.New(target));
    }

    default public <X extends XIterable<I>> CqlTransfer<I, X> into(CqlResultor<I, X> resultor) {
        return CqlTransfer.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getOrder(), X.notNull(resultor));
    }

    default public <R1> CqlAggregation<I, R1> over(CqlResultor<I, R1> resultor) {
        return CqlAggregation.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getOrder(), X.notNull(resultor));
    }

    @Override
    default public <P extends Consumer<? super I>> P iterate(P procedure) {
        ((XSequence)this.execute()).iterate(procedure);
        return procedure;
    }

    public static <I> CqlSelection<I> New() {
        return new Default(null, null, null, null, null, null);
    }

    public static <I> CqlSelection<I> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Comparator<? super I> comparator) {
        return new Default<I>(source, skip, limit, selector, comparator, CqlResultor.New());
    }

    public static <I> CqlSelection<I> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Comparator<? super I> comparator, XSequence<I> target) {
        return new Default<I>(source, skip, limit, selector, comparator, CqlResultor.New(target));
    }

    public static <I> CqlSelection<I> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Comparator<? super I> comparator, CqlResultor<I, XSequence<I>> resultor) {
        return new Default<I>(source, skip, limit, selector, comparator, resultor);
    }

    public static final class Default<I>
    extends CqlQuery.Abstract<I, I, XSequence<I>>
    implements CqlSelection<I> {
        Default(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Comparator<? super I> comparator, CqlResultor<I, XSequence<I>> resultor) {
            super(source, skip, limit, selector, null, comparator, resultor);
        }
    }
}

