/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.cql;

import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.serializer.collections.sorting.Sortable;
import org.eclipse.serializer.collections.sorting.SortableProcedure;
import org.eclipse.serializer.collections.types.XIterable;
import org.eclipse.serializer.collections.types.XSequence;
import org.eclipse.serializer.functional.Aggregator;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.cql.CQL;
import org.eclipse.serializer.util.cql.CqlWrapperCollectorLinkingFinalizing;
import org.eclipse.serializer.util.cql.CqlWrapperCollectorLinkingSorting;
import org.eclipse.serializer.util.cql.CqlWrapperCollectorProcedure;
import org.eclipse.serializer.util.cql.CqlWrapperCollectorSequenceSorting;

@FunctionalInterface
public interface CqlResultor<O, R> {
    public Aggregator<O, R> prepareCollector(XIterable<?> var1);

    public static <O> CqlResultor<O, XSequence<O>> New() {
        return e -> new CqlWrapperCollectorProcedure(CQL.prepareTargetCollection(e));
    }

    public static <O, T extends Consumer<O> & XIterable<O>> CqlResultor<O, T> New(T target) {
        X.notNull(target);
        return e -> new CqlWrapperCollectorProcedure(target);
    }

    public static <O, R> CqlResultor<O, R> NewFromAggregator(Aggregator<O, R> collector) {
        X.notNull(collector);
        return e -> collector;
    }

    public static <O, T extends Consumer<O>> CqlResultor<O, T> NewFromSupplier(Supplier<T> supplier) {
        return e -> new CqlWrapperCollectorProcedure((Consumer)supplier.get());
    }

    public static <O, T extends SortableProcedure<O> & XIterable<O>> CqlResultor<O, T> NewFromSupplier(Supplier<T> supplier, Comparator<? super O> order) {
        X.notNull(supplier);
        return order == null ? CqlResultor.NewFromSupplier(supplier) : e -> new CqlWrapperCollectorSequenceSorting((SortableProcedure)supplier.get(), order);
    }

    public static <O, T> CqlResultor<O, T> NewFromSupplier(Supplier<T> supplier, final BiConsumer<O, T> linker) {
        final T target = supplier.get();
        return new CqlResultor<O, T>(){

            @Override
            public Aggregator<O, T> prepareCollector(XIterable<?> source) {
                return new Aggregator<O, T>(){

                    @Override
                    public void accept(O element) {
                        linker.accept(element, target);
                    }

                    @Override
                    public T yield() {
                        return target;
                    }
                };
            }
        };
    }

    public static <O, T extends Sortable<O>> CqlResultor<O, T> NewFromSupplier(Supplier<T> supplier, BiConsumer<O, T> linker, Comparator<? super O> order) {
        X.notNull(supplier);
        return order == null ? CqlResultor.NewFromSupplier(supplier, linker) : e -> new CqlWrapperCollectorLinkingSorting((Sortable)supplier.get(), linker, order);
    }

    public static <O, T> CqlResultor<O, T> NewFromSupplier(Supplier<T> supplier, BiConsumer<O, T> linker, Consumer<? super T> finalizer) {
        X.notNull(supplier);
        return finalizer == null ? CqlResultor.NewFromSupplier(supplier, linker) : e -> new CqlWrapperCollectorLinkingFinalizing(supplier.get(), linker, finalizer);
    }
}

