/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.cql;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.serializer.collections.ArrayCollector;
import org.eclipse.serializer.collections.types.XIterable;
import org.eclipse.serializer.collections.types.XSequence;
import org.eclipse.serializer.functional.Aggregator;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.cql.CQL;
import org.eclipse.serializer.util.cql.CqlIteration;
import org.eclipse.serializer.util.cql.CqlProjection;
import org.eclipse.serializer.util.cql.CqlResultor;

public interface CqlQuery<I, O, R> {
    default public CqlQuery<I, O, R> skip(Number count) {
        return CqlQuery.New(this.getSource(), CQL.asLong(count), this.getLimit(), this.getSelector(), this.getProjector(), this.getOrder(), this.getResultor());
    }

    default public CqlQuery<I, O, R> limit(Number count) {
        return CqlQuery.New(this.getSource(), this.getSkip(), CQL.asLong(count), this.getSelector(), this.getProjector(), this.getOrder(), this.getResultor());
    }

    default public CqlQuery<I, O, R> select(Predicate<? super I> selector) {
        return CqlQuery.New(this.getSource(), this.getSkip(), this.getLimit(), selector, this.getProjector(), this.getOrder(), this.getResultor());
    }

    default public CqlQuery<I, O, R> orderBy(Comparator<? super O> order) {
        return CqlQuery.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getProjector(), order, this.getResultor());
    }

    default public CqlQuery<I, O, R> from(XIterable<? extends I> source) {
        return CqlQuery.New(source, this.getSkip(), this.getLimit(), this.getSelector(), this.getProjector(), this.getOrder(), this.getResultor());
    }

    default public <P> CqlProjection<I, P> project(Function<? super I, P> projector) {
        return CqlProjection.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), projector, null);
    }

    default public <P extends Consumer<O> & XIterable<O>> CqlIteration<I, O, P> into(Supplier<P> supplier) {
        return CqlIteration.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getProjector(), this.getOrder(), CqlResultor.NewFromSupplier(supplier));
    }

    default public <P extends Consumer<O> & XIterable<O>> CqlIteration<I, O, P> into(P target) {
        return CqlIteration.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getProjector(), this.getOrder(), CqlResultor.New(target));
    }

    default public <X extends XIterable<O>> CqlIteration<I, O, X> into(CqlResultor<O, X> resultor) {
        return CqlIteration.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getProjector(), this.getOrder(), X.notNull(resultor));
    }

    default public <R1> CqlQuery<I, O, R1> over(CqlResultor<O, R1> resultor) {
        return CqlQuery.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getProjector(), this.getOrder(), X.notNull(resultor));
    }

    default public <R1> CqlQuery<I, O, R1> targeting(Aggregator<O, R1> collector) {
        return CqlQuery.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getProjector(), this.getOrder(), CqlResultor.NewFromAggregator(collector));
    }

    default public Long getSkip() {
        return null;
    }

    default public Long getLimit() {
        return null;
    }

    default public XIterable<? extends I> getSource() {
        return null;
    }

    default public Predicate<? super I> getSelector() {
        return null;
    }

    public Function<? super I, O> getProjector();

    public CqlResultor<O, R> getResultor();

    default public Comparator<? super O> getOrder() {
        return null;
    }

    default public R execute() {
        return this.executeOn(CQL.prepareSource(this.getSource()));
    }

    default public R executeOn(XIterable<? extends I> source) {
        return (R)CQL.executeQuery(source, this.getSkip(), this.getLimit(), this.getSelector(), this.getProjector(), this.getResultor(), this.getOrder());
    }

    default public <P extends Consumer<O>> P executeInto(P target) {
        return this.executeInto(CQL.prepareSource(this.getSource()), target);
    }

    default public O[] executeInto(O[] target) {
        return this.executeInto(target, 0);
    }

    default public O[] executeInto(O[] target, int size) {
        return this.executeInto(CQL.prepareSource(this.getSource()), new ArrayCollector<O>(target, size)).getArray();
    }

    default public <P extends Consumer<I>> P executeSelection(XIterable<? extends I> source, P target) {
        return CQL.executeQuery(source, this.getSkip(), this.getLimit(), this.getSelector(), target);
    }

    default public <P extends Consumer<O>> P executeInto(XIterable<? extends I> source, P target) {
        return CQL.executeQuery(source, this.getSkip(), this.getLimit(), this.getSelector(), this.getProjector(), target, this.getOrder());
    }

    public static <I, O, R> CqlQuery<I, O, R> New() {
        return new Default(null, null, null, null, null, null, null);
    }

    public static <I, O> CqlQuery<I, O, XSequence<O>> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator) {
        return new Default(source, skip, limit, selector, X.notNull(projector), comparator, CqlResultor.New());
    }

    public static <I, O, R> CqlQuery<I, O, R> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator, Aggregator<O, R> aggregator, R target) {
        return new Default<I, O, R>(source, skip, limit, selector, projector, comparator, CqlResultor.NewFromAggregator(aggregator));
    }

    public static <I, O, R extends Consumer<O> & XIterable<O>> CqlQuery<I, O, R> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator, R target) {
        return new Default<I, O, R>(source, skip, limit, selector, projector, comparator, CqlResultor.New(target));
    }

    public static <I, O, R> CqlQuery<I, O, R> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator, CqlResultor<O, R> resultor) {
        return new Default<I, O, R>(source, skip, limit, selector, projector, comparator, resultor);
    }

    public static abstract class Abstract<I, O, R>
    implements CqlQuery<I, O, R> {
        final XIterable<? extends I> source;
        final Long skip;
        final Long limit;
        final Predicate<? super I> selector;
        final Function<? super I, O> projector;
        final CqlResultor<O, R> resultor;
        final Comparator<? super O> comparator;

        Abstract(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator, CqlResultor<O, R> resultor) {
            this.source = source;
            this.skip = skip;
            this.limit = limit;
            this.selector = selector;
            this.projector = projector;
            this.resultor = resultor;
            this.comparator = comparator;
        }

        @Override
        public final Long getSkip() {
            return this.skip;
        }

        @Override
        public final Long getLimit() {
            return this.limit;
        }

        @Override
        public final XIterable<? extends I> getSource() {
            return this.source;
        }

        @Override
        public final Predicate<? super I> getSelector() {
            return this.selector;
        }

        @Override
        public Function<? super I, O> getProjector() {
            return this.projector;
        }

        @Override
        public final Comparator<? super O> getOrder() {
            return this.comparator;
        }

        @Override
        public final CqlResultor<O, R> getResultor() {
            return this.resultor;
        }
    }

    public static final class Default<I, O, R>
    extends Abstract<I, O, R> {
        Default(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator, CqlResultor<O, R> resultor) {
            super(source, skip, limit, selector, projector, comparator, resultor);
        }
    }
}

