/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.cql;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.types.XIterable;
import org.eclipse.serializer.collections.types.XSequence;
import org.eclipse.serializer.functional.Aggregator;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.cql.CQL;
import org.eclipse.serializer.util.cql.CqlQuery;
import org.eclipse.serializer.util.cql.CqlResultor;

public interface CqlIteration<I, O, R extends XIterable<O>>
extends CqlQuery<I, O, R>,
XIterable<O> {
    @Override
    default public CqlIteration<I, O, R> skip(Number count) {
        return CqlIteration.New(this.getSource(), CQL.asLong(count), this.getLimit(), this.getSelector(), this.getProjector(), this.getOrder(), this.getResultor());
    }

    @Override
    default public CqlIteration<I, O, R> limit(Number count) {
        return CqlIteration.New(this.getSource(), this.getSkip(), CQL.asLong(count), this.getSelector(), this.getProjector(), this.getOrder(), this.getResultor());
    }

    @Override
    default public CqlIteration<I, O, R> select(Predicate<? super I> selector) {
        return CqlIteration.New(this.getSource(), this.getSkip(), this.getLimit(), selector, this.getProjector(), this.getOrder(), this.getResultor());
    }

    @Override
    default public CqlIteration<I, O, R> orderBy(Comparator<? super O> order) {
        return CqlIteration.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getProjector(), order, this.getResultor());
    }

    @Override
    default public CqlIteration<I, O, R> from(XIterable<? extends I> source) {
        return CqlIteration.New(source, this.getSkip(), this.getLimit(), this.getSelector(), this.getProjector(), this.getOrder(), this.getResultor());
    }

    @Override
    default public <P extends Consumer<? super O>> P iterate(P procedure) {
        ((XIterable)this.execute()).iterate(procedure);
        return procedure;
    }

    public static <I, O, R extends XIterable<O>> CqlIteration<I, O, R> New() {
        return new Default(null, null, null, null, null, null, null);
    }

    public static <I, O> CqlQuery<I, O, XSequence<O>> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator) {
        return new Default(source, skip, limit, selector, X.notNull(projector), comparator, CqlResultor.New());
    }

    public static <I, O, R extends XIterable<O>> CqlQuery<I, O, R> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator, Aggregator<O, R> aggregator) {
        return new Default<I, O, R>(source, skip, limit, selector, projector, comparator, CqlResultor.NewFromAggregator(aggregator));
    }

    public static <I, O, R extends Consumer<O> & XIterable<O>> CqlQuery<I, O, R> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator, R target) {
        return new Default<I, O, R>(source, skip, limit, selector, projector, comparator, CqlResultor.New(target));
    }

    public static <I, O, R extends XIterable<O>> CqlIteration<I, O, R> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator, CqlResultor<O, R> resultor) {
        return new Default<I, O, R>(source, skip, limit, selector, projector, comparator, resultor);
    }

    public static final class Default<I, O, R extends XIterable<O>>
    extends CqlQuery.Abstract<I, O, R>
    implements CqlIteration<I, O, R> {
        Default(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator, CqlResultor<O, R> resultor) {
            super(source, skip, limit, selector, projector, comparator, resultor);
        }
    }
}

