/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.cql;

import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.collections.EqHashEnum;
import org.eclipse.serializer.collections.EqHashTable;
import org.eclipse.serializer.collections.HashEnum;
import org.eclipse.serializer.collections.HashTable;
import org.eclipse.serializer.collections.LimitList;
import org.eclipse.serializer.collections.XSort;
import org.eclipse.serializer.collections.interfaces.Sized;
import org.eclipse.serializer.collections.sorting.Sortable;
import org.eclipse.serializer.collections.sorting.SortableProcedure;
import org.eclipse.serializer.collections.types.XIterable;
import org.eclipse.serializer.collections.types.XSequence;
import org.eclipse.serializer.functional.Aggregate_doubleMin;
import org.eclipse.serializer.functional.Aggregate_doubleSum;
import org.eclipse.serializer.functional.Aggregator;
import org.eclipse.serializer.functional.To_double;
import org.eclipse.serializer.functional.XFunc;
import org.eclipse.serializer.hashing.HashEqualator;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.cql.ArrayProjector;
import org.eclipse.serializer.util.cql.CqlAggregation;
import org.eclipse.serializer.util.cql.CqlIteration;
import org.eclipse.serializer.util.cql.CqlProjection;
import org.eclipse.serializer.util.cql.CqlQuery;
import org.eclipse.serializer.util.cql.CqlResultor;
import org.eclipse.serializer.util.cql.CqlSelection;
import org.eclipse.serializer.util.cql.CqlTransfer;

public final class CQL {
    public static <I> CqlSelection<I> Selection() {
        return CqlSelection.New();
    }

    public static <I> CqlTransfer<I, XSequence<I>> Transfer() {
        return CqlTransfer.New();
    }

    public static <I, R> CqlAggregation<I, R> Aggregation() {
        return CqlAggregation.New();
    }

    public static <I, O> CqlProjection<I, O> Projection() {
        return CqlProjection.New();
    }

    public static <I, O, R extends XIterable<O>> CqlIteration<I, O, R> Iteration() {
        return CqlIteration.New();
    }

    public static <I, O, R> CqlQuery<I, O, R> Query() {
        return CqlQuery.New();
    }

    public static <T> boolean isNotNull(T instance) {
        return instance != null;
    }

    public static <T> boolean isNull(T instance) {
        return instance == null;
    }

    public static <I> CqlSelection<I> select(Predicate<? super I> predicate) {
        return CqlSelection.New(null, null, null, predicate, null);
    }

    public static <I, R> CqlAggregation<I, R> aggregate(CqlResultor<I, R> aggregator) {
        return CqlAggregation.New(null, null, null, null, null, aggregator);
    }

    public static <I, R> CqlAggregation<I, R> aggregate(Supplier<R> supplier, BiConsumer<I, R> linker) {
        return CQL.aggregate(CqlResultor.NewFromSupplier(supplier, linker));
    }

    public static <I, R extends Sortable<I>> CqlAggregation<I, R> aggregate(Supplier<R> supplier, BiConsumer<I, R> linker, Comparator<? super I> order) {
        return CQL.aggregate(CqlResultor.NewFromSupplier(supplier, linker, order));
    }

    public static <I, R> CqlAggregation<I, R> aggregate(Supplier<R> supplier, BiConsumer<I, R> linker, Consumer<? super R> finalizer) {
        return CQL.aggregate(CqlResultor.NewFromSupplier(supplier, linker, finalizer));
    }

    public static <I> CqlSelection<I> from(XIterable<? extends I> source) {
        return CqlSelection.New(source, null, null, null, null);
    }

    public static <I, O> CqlProjection<I, O> project(Function<? super I, O> projector) {
        return CqlProjection.New(null, null, null, null, projector, null);
    }

    @SafeVarargs
    public static <I> CqlProjection<I, Object[]> project(Function<? super I, Object> ... projectors) {
        return CqlProjection.New(null, null, null, null, ArrayProjector.New(projectors), null);
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static <T> Predicate<T> where(Predicate<T> predicate) {
        return predicate;
    }

    public static <T> Comparator<T> reversed(Comparator<T> order) {
        return order.reversed();
    }

    public static <T> Comparator<T> comparing(Comparator<T> order) {
        return order;
    }

    public static <E, T> Comparator<E> comparing(Function<E, T> getter, Comparator<T> order) {
        return (e1, e2) -> order.compare(getter.apply(e1), getter.apply(e2));
    }

    public static <I> Function<I, I> identity() {
        return Function.identity();
    }

    public static <I> XIterable<? extends I> prepareSource(XIterable<? extends I> source) {
        return X.coalesce(source, X.empty());
    }

    public static <E> XSequence<E> prepareTargetCollection(XIterable<?> source) {
        return source instanceof Sized ? new LimitList(XTypes.to_int(((Sized)((Object)source)).size())) : new BulkList();
    }

    public static <I> Consumer<I> prepareSourceIterator(Long skip, Long limit, Predicate<? super I> selector, Consumer<? super I> target) {
        if (selector == null) {
            return CQL.prepareSourceIterator(skip, limit, target);
        }
        if (CQL.isSkip(skip)) {
            return CQL.isLimit(limit) ? XFunc.wrapWithPredicateSkipLimit(target, selector, skip, limit) : XFunc.wrapWithPredicateSkip(target, selector, skip);
        }
        return CQL.isLimit(limit) ? XFunc.wrapWithPredicateLimit(target, selector, limit) : XFunc.wrapWithPredicate(target, selector);
    }

    public static <I> Consumer<I> prepareSourceIterator(Long skip, Long limit, Consumer<? super I> target) {
        if (CQL.isSkip(skip)) {
            return CQL.isLimit(limit) ? XFunc.wrapWithSkipLimit(target, skip, limit) : XFunc.wrapWithSkip(target, skip);
        }
        return CQL.isLimit(limit) ? XFunc.wrapWithLimit(target, limit) : i -> target.accept((Object)i);
    }

    public static <I, O> Consumer<I> prepareSourceIterator(Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Consumer<? super O> target) {
        if (selector == null) {
            return CQL.prepareSourceIterator(skip, limit, projector, target);
        }
        CQL.isNotNull(projector);
        if (CQL.isSkip(skip)) {
            return CQL.isLimit(limit) ? XFunc.wrapWithPredicateFunctionSkipLimit(target, selector, projector, skip, limit) : XFunc.wrapWithPredicateFunctionSkip(target, selector, projector, skip);
        }
        return CQL.isLimit(limit) ? XFunc.wrapWithPredicateFunctionLimit(target, selector, projector, limit) : XFunc.wrapWithPredicateFunction(target, selector, projector);
    }

    public static <I, O> Consumer<I> prepareSourceIterator(Long skip, Long limit, Function<? super I, O> projector, Consumer<? super O> target) {
        CQL.isNotNull(projector);
        if (CQL.isSkip(skip)) {
            return CQL.isLimit(limit) ? XFunc.wrapWithFunctionSkipLimit(target, projector, skip, limit) : XFunc.wrapWithFunctionSkip(target, projector, skip);
        }
        return CQL.isLimit(limit) ? XFunc.wrapWithFunctionLimit(target, projector, limit) : XFunc.wrapWithFunction(target, projector);
    }

    public static <E> XSequence<E> executeQuery(XIterable<? extends E> source) {
        return CQL.executeQuery(source, CQL.prepareTargetCollection(source));
    }

    public static <E, T extends Consumer<? super E>> T executeQuery(XIterable<? extends E> source, T target) {
        return source.iterate(target);
    }

    public static <I, P extends Consumer<? super I>> P executeQuery(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, P target) {
        CQL.executeQuery(source, CQL.prepareSourceIterator(skip, limit, selector, target));
        return target;
    }

    public static <I, P extends Consumer<I>> P executeQuery(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, P target, Comparator<? super I> order) {
        CQL.executeQuery(source, skip, limit, selector, target);
        SortableProcedure.sortIfApplicable(target, order);
        return target;
    }

    public static <I, R> R executeQuery(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, CqlResultor<I, R> resultor, Comparator<? super I> order) {
        Aggregator<I, R> collector = resultor.prepareCollector(source);
        CQL.executeQuery(source, skip, limit, selector, collector, order);
        return collector.yield();
    }

    public static <I, O, R> R executeQuery(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, CqlResultor<O, R> resultor, Comparator<? super O> order) {
        Aggregator<O, R> collector = resultor.prepareCollector(source);
        CQL.executeQuery(source, skip, limit, selector, projector, collector, order);
        return collector.yield();
    }

    public static <I, O, P extends Consumer<O>> P executeQuery(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, P target, Comparator<? super O> order) {
        CQL.executeQuery(source, CQL.prepareSourceIterator(skip, limit, selector, projector, target));
        SortableProcedure.sortIfApplicable(target, order);
        return target;
    }

    public static <O, T extends Consumer<O>> CqlResultor<O, T> resulting(Supplier<T> supplier) {
        return CqlResultor.NewFromSupplier(supplier);
    }

    public static <O, T extends Consumer<O> & XIterable<O>> CqlResultor<O, T> resultingIterable(Supplier<T> supplier) {
        return CqlResultor.NewFromSupplier(supplier);
    }

    public static <O> CqlResultor<O, BulkList<O>> resultingBulkList() {
        return CqlResultor.NewFromSupplier(BulkList::New);
    }

    public static <O> CqlResultor<O, BulkList<O>> resultingBulkList(int initialCapacity) {
        return CqlResultor.NewFromSupplier(() -> BulkList.New(initialCapacity));
    }

    public static <O> CqlResultor<O, LimitList<O>> resultingLimitList(int initialCapacity) {
        return CqlResultor.NewFromSupplier(() -> LimitList.New(initialCapacity));
    }

    public static <O> CqlResultor<O, HashEnum<O>> resultingHashEnum() {
        return CqlResultor.NewFromSupplier(() -> HashEnum.New());
    }

    public static <O> CqlResultor<O, EqHashEnum<O>> resultingEqHashEnum() {
        return CqlResultor.NewFromSupplier(() -> EqHashEnum.New());
    }

    public static <O> CqlResultor<O, EqHashEnum<O>> resultingEqHashEnum(HashEqualator<? super O> hashEqualator) {
        return CqlResultor.NewFromSupplier(() -> EqHashEnum.New(hashEqualator));
    }

    public static <K, V> CqlResultor<KeyValue<K, V>, HashTable<K, V>> resultingHashTable() {
        return CqlResultor.NewFromSupplier(() -> HashTable.New());
    }

    public static <K, V> CqlResultor<KeyValue<K, V>, EqHashTable<K, V>> resultingEqHashTable() {
        return CqlResultor.NewFromSupplier(() -> EqHashTable.New());
    }

    public static <K, V> CqlResultor<KeyValue<K, V>, EqHashTable<K, V>> resultingEqHashTable(HashEqualator<? super K> hashEqualator) {
        return CqlResultor.NewFromSupplier(() -> EqHashTable.New(hashEqualator));
    }

    public static <O> CqlResultor<O, Double> sum(To_double<? super O> getter) {
        return e -> new Aggregate_doubleSum(getter);
    }

    public static <O> CqlResultor<O, Double> min(To_double<? super O> getter) {
        return e -> new Aggregate_doubleMin(getter);
    }

    @SafeVarargs
    public static final <E> Comparator<? super E> chain(Comparator<? super E> ... comparators) {
        return XSort.chain(comparators);
    }

    static Long asLong(Number number) {
        return number instanceof Long ? ((Long)number).longValue() : number.longValue();
    }

    static boolean isSkip(Long skip) {
        return skip != null && skip != 0L;
    }

    static boolean isLimit(Long limit) {
        return limit != null && limit != 0L;
    }

    private CQL() {
        throw new UnsupportedOperationException();
    }
}

