/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util;

import java.util.function.Consumer;
import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.util.X;

public interface BufferingCollector<E> {
    public void accept(E var1);

    public void resetElements();

    public void finalizeElements();

    public long size();

    default public boolean isEmpty() {
        return this.size() == 0L;
    }

    public static <E> BufferingCollector<E> New(Consumer<? super E> finalizingLogic) {
        return new Default<E>(X.notNull(finalizingLogic), null);
    }

    public static <E> BufferingCollector<E> New(Consumer<? super E> finalizingLogic, Consumer<? super E> collectingListener) {
        return new Default<E>(X.notNull(finalizingLogic), collectingListener);
    }

    public static final class Default<E>
    implements BufferingCollector<E> {
        private final BulkList<E> buffer = BulkList.New();
        private final Consumer<? super E> finalizingLogic;
        private final Consumer<? super E> collectingListener;

        Default(Consumer<? super E> finalizingLogic, Consumer<? super E> collectingListener) {
            this.finalizingLogic = finalizingLogic;
            this.collectingListener = collectingListener;
        }

        @Override
        public void accept(E element) {
            if (this.collectingListener != null) {
                this.collectingListener.accept(element);
            }
            this.buffer.accept(element);
        }

        @Override
        public void resetElements() {
            this.buffer.clear();
        }

        @Override
        public void finalizeElements() {
            this.buffer.iterate(this.finalizingLogic);
        }

        @Override
        public long size() {
            return this.buffer.size();
        }
    }
}

