/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.typing;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.serializer.exceptions.NumberRangeException;
import org.eclipse.serializer.typing.TypeMapping;
import org.eclipse.serializer.typing.ValueType;
import org.eclipse.serializer.util.X;

public final class XTypes {
    private static final Class<?> CLASS_DirectByteBuffer = ByteBuffer.allocateDirect(8).getClass();

    public static Class<?> directByteBufferClass() {
        return CLASS_DirectByteBuffer;
    }

    public static boolean isDirectByteBuffer(ByteBuffer byteBuffer) {
        X.notNull(byteBuffer);
        return CLASS_DirectByteBuffer.isInstance(byteBuffer);
    }

    public static ByteBuffer guaranteeDirectByteBuffer(ByteBuffer directBuffer) {
        if (XTypes.isDirectByteBuffer(directBuffer)) {
            return directBuffer;
        }
        throw new ClassCastException(String.valueOf(directBuffer.getClass().getName()) + " cannot be cast to " + CLASS_DirectByteBuffer.getName());
    }

    public static boolean isBooleanType(Class<?> c) {
        return c == Boolean.TYPE || c == Boolean.class;
    }

    public static boolean isByteType(Class<?> c) {
        return c == Byte.TYPE || c == Byte.class;
    }

    public static boolean isShortType(Class<?> c) {
        return c == Short.TYPE || c == Short.class;
    }

    public static boolean isIntegerType(Class<?> c) {
        return c == Integer.TYPE || c == Integer.class;
    }

    public static boolean isLongType(Class<?> c) {
        return c == Long.TYPE || c == Long.class;
    }

    public static boolean isFloatType(Class<?> c) {
        return c == Float.TYPE || c == Float.class;
    }

    public static boolean isDoubleType(Class<?> c) {
        return c == Double.TYPE || c == Double.class;
    }

    public static boolean isCharacterType(Class<?> c) {
        return c == Character.TYPE || c == Character.class;
    }

    public static boolean isStringType(Class<?> c) {
        return c == String.class;
    }

    public static boolean isCharSequenceType(Class<?> c) {
        return CharSequence.class.isAssignableFrom(c);
    }

    public static boolean isNaturalNumberType(Class<?> c) {
        return c == Byte.TYPE || c == Byte.class || c == Short.TYPE || c == Short.class || c == Integer.TYPE || c == Integer.class || c == Long.TYPE || c == Long.class || c == BigInteger.class || c == AtomicInteger.class || c == AtomicLong.class;
    }

    public static boolean isDecimalType(Class<?> c) {
        return c == Float.TYPE || c == Float.class || c == Double.TYPE || c == Double.class || c == BigDecimal.class;
    }

    public static boolean isNumberType(Class<?> c) {
        return c == Byte.TYPE || c == Short.TYPE || c == Integer.TYPE || c == Long.TYPE || c == Float.TYPE || c == Double.TYPE || Number.class.isAssignableFrom(c);
    }

    public static boolean isLiteralType(Class<?> c) {
        return c == String.class || c == Character.TYPE || c == Character.class;
    }

    public static boolean isValueType(Class<?> c) {
        return c == String.class || Number.class.isAssignableFrom(c) || ValueType.class.isAssignableFrom(c) || c == Field.class;
    }

    public static boolean isNaturalNumber(Object o) {
        return o instanceof Integer || o instanceof Short || o instanceof Long || o instanceof Byte || o instanceof BigInteger || o instanceof AtomicInteger || o instanceof AtomicLong;
    }

    public static boolean isNumber(Object o) {
        return o instanceof Number;
    }

    public static boolean isDecimal(Object o) {
        return o instanceof Float || o instanceof Double || o instanceof BigDecimal;
    }

    public static boolean isLiteral(Object o) {
        return o instanceof String || o instanceof Character;
    }

    public static boolean isBoolean(Object o) {
        return o instanceof Boolean;
    }

    public static boolean isValueType(Object o) {
        return o instanceof String || o instanceof Number || o instanceof ValueType;
    }

    public static boolean isPrimitiveWrapper(Object o) {
        return o instanceof Integer || o instanceof Long || o instanceof Double || o instanceof Character || o instanceof Boolean || o instanceof Float || o instanceof Byte || o instanceof Short;
    }

    public static byte to_byte(boolean value) {
        return value ? (byte)1 : 0;
    }

    public static boolean to_boolean(byte value) {
        return value != 0;
    }

    public static int to_int(boolean value) {
        return value ? 1 : 0;
    }

    public static int to_int(long value) throws NumberRangeException {
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.valueOf(value) + " > " + Integer.MAX_VALUE);
        }
        if (value < Integer.MIN_VALUE) {
            throw new IllegalArgumentException(String.valueOf(value) + " < " + Integer.MIN_VALUE);
        }
        return (int)value;
    }

    public static int to_int(float value) throws NumberRangeException {
        if (value > 2.1474836E9f) {
            throw new IllegalArgumentException(String.valueOf(value) + " > " + Integer.MAX_VALUE);
        }
        if (value < -2.1474836E9f) {
            throw new IllegalArgumentException(String.valueOf(value) + " < " + Integer.MIN_VALUE);
        }
        return (int)value;
    }

    public static int to_int(double value) throws NumberRangeException {
        if (value > 2.147483647E9) {
            throw new IllegalArgumentException(String.valueOf(value) + " > " + Integer.MAX_VALUE);
        }
        if (value < -2.147483648E9) {
            throw new IllegalArgumentException(String.valueOf(value) + " < " + Integer.MIN_VALUE);
        }
        return (int)value;
    }

    public static int to_int(Number value) throws NumberRangeException, NullPointerException {
        return XTypes.to_int(value.longValue());
    }

    public static Byte asByte(Number value) {
        return value == null ? null : (value instanceof Byte ? (Byte)value : Byte.valueOf(value.byteValue()));
    }

    public static Short asShort(Number value) {
        return value == null ? null : (value instanceof Short ? (Short)value : Short.valueOf(value.shortValue()));
    }

    public static Integer asInteger(Number value) {
        return value == null ? null : (value instanceof Integer ? (Integer)value : Integer.valueOf(value.intValue()));
    }

    public static Float asFloat(Number value) {
        return value == null ? null : (value instanceof Float ? (Float)value : Float.valueOf(value.floatValue()));
    }

    public static Long asLong(Number value) {
        return value == null ? null : (value instanceof Long ? (Long)value : Long.valueOf(value.longValue()));
    }

    public static Double asDouble(Number value) {
        return value == null ? null : (value instanceof Double ? (Double)value : Double.valueOf(value.doubleValue()));
    }

    public static TypeMapping<Float> createDefaultTypeSimilarity() {
        Class[] primitives = new Class[]{Byte.TYPE, Boolean.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Float.TYPE, Long.TYPE, Double.TYPE};
        Class[] wrappers = new Class[]{Byte.class, Boolean.class, Short.class, Character.class, Integer.class, Float.class, Long.class, Double.class};
        int[][] primSims = new int[][]{{100, 50, 80, 70, 60, 30, 40, 30}, {50, 100, 40, 10, 30, 20, 20, 10}, {80, 40, 100, 50, 80, 50, 60, 50}, {70, 10, 50, 100, 50, 40, 30, 20}, {60, 30, 80, 50, 100, 70, 80, 60}, {30, 20, 50, 40, 70, 100, 60, 80}, {40, 20, 60, 30, 80, 60, 100, 70}, {30, 10, 50, 20, 60, 80, 70, 100}};
        Function percent = value -> (float)value * 0.01f;
        Function prim2Wrap = value -> (float)value * 0.008f;
        TypeMapping<Float> typeSimilarities = TypeMapping.New();
        int x = 0;
        while (x < primitives.length) {
            XTypes.registerDual(typeSimilarities, primitives[x], percent, primitives, primSims[x]);
            XTypes.registerDual(typeSimilarities, wrappers[x], percent, wrappers, primSims[x]);
            XTypes.registerDual(typeSimilarities, wrappers[x], prim2Wrap, primitives, primSims[x]);
            XTypes.registerDual(typeSimilarities, primitives[x], prim2Wrap, wrappers, primSims[x]);
            ++x;
        }
        XTypes.registerDual(typeSimilarities, BigInteger.class, percent, primitives, 30, 10, 50, 20, 70, 50, 90, 60);
        XTypes.registerDual(typeSimilarities, BigDecimal.class, percent, primitives, 20, 5, 40, 10, 50, 70, 60, 90);
        XTypes.registerDual(typeSimilarities, String.class, percent, primitives, 20, 10, 20, 60, 20, 30, 20, 30);
        XTypes.registerDual(typeSimilarities, Date.class, percent, primitives, 10, 0, 20, 0, 30, 0, 60, 0);
        XTypes.registerDual(typeSimilarities, BigInteger.class, percent, wrappers, 30, 10, 50, 20, 70, 50, 90, 60);
        XTypes.registerDual(typeSimilarities, BigDecimal.class, percent, wrappers, 20, 5, 40, 10, 50, 70, 60, 90);
        XTypes.registerDual(typeSimilarities, String.class, percent, wrappers, 20, 10, 20, 60, 20, 30, 20, 30);
        XTypes.registerDual(typeSimilarities, Date.class, percent, wrappers, 10, 0, 20, 0, 30, 0, 60, 0);
        XTypes.registerDual(typeSimilarities, BigInteger.class, percent, BigDecimal.class, 80);
        XTypes.registerDual(typeSimilarities, BigInteger.class, percent, String.class, 20);
        XTypes.registerDual(typeSimilarities, BigInteger.class, percent, Date.class, 60);
        XTypes.registerDual(typeSimilarities, BigDecimal.class, percent, String.class, 30);
        XTypes.registerDual(typeSimilarities, BigDecimal.class, percent, Date.class, 20);
        XTypes.registerDual(typeSimilarities, String.class, percent, Date.class, 40);
        return typeSimilarities;
    }

    static void registerDual(TypeMapping<Float> typeSimilarities, Class<?> type, Function function, Class<?>[] types, int ... values) {
        int i = 0;
        while (i < types.length) {
            XTypes.registerDual(typeSimilarities, type, function, types[i], values[i]);
            ++i;
        }
    }

    static void registerDual(TypeMapping<Float> typeSimilarities, Class<?> type1, Function function, Class<?> type2, int value) {
        float similarity = function.apply(value);
        typeSimilarities.register(type1, type2, Float.valueOf(similarity));
        typeSimilarities.register(type2, type1, Float.valueOf(similarity));
    }

    private XTypes() {
        throw new UnsupportedOperationException();
    }

    static interface Function {
        public float apply(int var1);
    }
}

