/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.typing;

import org.eclipse.serializer.hashing.HashEqualator;
import org.eclipse.serializer.util.X;

public interface TypePair {
    public Class<?> type1();

    public Class<?> type2();

    public static int hash(TypePair tp) {
        return tp.type1().hashCode() | tp.type2().hashCode();
    }

    public static boolean equal(TypePair tp1, TypePair tp2) {
        return tp1 == tp2 || tp1 != null && tp2 != null && TypePair.equalNonTrivial(tp1, tp2);
    }

    public static boolean equalNonTrivial(TypePair tp1, TypePair tp2) {
        return tp1.type1() == tp2.type1() && tp1.type2() == tp2.type2();
    }

    public static HashEquality HashEquality() {
        return new HashEquality();
    }

    public static TypePair New(Class<?> type1, Class<?> type2) {
        return new Default(X.notNull(type1), X.notNull(type2));
    }

    public static final class Default
    implements TypePair {
        private final Class<?> type1;
        private final Class<?> type2;
        private final int hash;

        Default(Class<?> type1, Class<?> type2) {
            this.type1 = type1;
            this.type2 = type2;
            this.hash = TypePair.hash(this);
        }

        @Override
        public final Class<?> type1() {
            return this.type1;
        }

        @Override
        public final Class<?> type2() {
            return this.type2;
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object other) {
            return other == this || other instanceof Default && this.type1 == ((Default)other).type1 && this.type2 == ((Default)other).type2;
        }
    }

    public static final class HashEquality
    implements HashEqualator<TypePair> {
        @Override
        public final int hash(TypePair tp) {
            return TypePair.hash(tp);
        }

        @Override
        public final boolean equal(TypePair tp1, TypePair tp2) {
            return TypePair.equal(tp1, tp2);
        }
    }
}

