/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.branching.ThrowBreak;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.collections.types.XReference;
import org.eclipse.serializer.exceptions.IllegalAccessRuntimeException;
import org.eclipse.serializer.exceptions.InstantiationRuntimeException;
import org.eclipse.serializer.exceptions.MemoryException;
import org.eclipse.serializer.exceptions.NoSuchFieldRuntimeException;
import org.eclipse.serializer.exceptions.NoSuchMethodRuntimeException;
import org.eclipse.serializer.functional.Instantiator;
import org.eclipse.serializer.functional.XFunc;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.reflect.CopyPredicate;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.UtilStackTrace;
import org.eclipse.serializer.util.X;

public final class XReflect {
    public static <T> T defaultInstantiate(Class<T> type) throws NoSuchMethodRuntimeException, InstantiationRuntimeException {
        Constructor<T> defaultConstructor;
        try {
            defaultConstructor = type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodRuntimeException(e);
        }
        try {
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new InstantiationRuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Field setAccessible(Class<?> actualClass, Field field) {
        try {
            return XReflect.setAccessible(field);
        }
        catch (SecurityException e) {
            throw new SecurityException(XReflect.toFullQualifiedFieldName(actualClass, field), e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(XReflect.toFullQualifiedFieldName(actualClass, field), e);
        }
        catch (Error e) {
            throw new Error(XReflect.toFullQualifiedFieldName(actualClass, field), e);
        }
    }

    public static Field setAccessible(Field field) throws SecurityException {
        field.setAccessible(true);
        return field;
    }

    public static Method setAccessible(Method method) throws SecurityException {
        method.setAccessible(true);
        return method;
    }

    public static <T> Constructor<T> setAccessible(Constructor<T> constructor) throws SecurityException {
        constructor.setAccessible(true);
        return constructor;
    }

    public static boolean isInstanceField(Field field) {
        return !Modifier.isStatic(field.getModifiers());
    }

    public static String toFieldName(Field field) {
        return field.getName();
    }

    public static boolean isInterfaceOfType(Class<?> interfaceClass, Class<?> implementedSuperInterface) {
        if (interfaceClass == implementedSuperInterface) {
            return true;
        }
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        boolean isInterfaceType = false;
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            isInterfaceType |= XReflect.isInterfaceOfType(i, implementedSuperInterface);
            ++n2;
        }
        return isInterfaceType;
    }

    public static boolean implementsInterface(Class<?> c, Class<?> interfaceClass) {
        Class<?>[] interfaces;
        if (c == null || interfaceClass == null || !interfaceClass.isInterface()) {
            return false;
        }
        Class<?>[] classArray = interfaces = XReflect.getClassHierarchyInterfaces(c);
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            if (XReflect.isInterfaceOfType(i, interfaceClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Class<?>[] getClassHierarchyInterfaces(Class<?> classClass) {
        if (classClass.isInterface() || classClass.isArray() || classClass.isPrimitive()) {
            throw new IllegalArgumentException("Can only handle actual classes.");
        }
        BulkList<Class<?>[]> hierarchy = new BulkList<Class<?>[]>();
        int interfaceCount = 0;
        Class<?> current = classClass;
        while (current != Object.class) {
            Class<?>[] currentClassInterfaces = current.getInterfaces();
            interfaceCount += currentClassInterfaces.length;
            hierarchy.add(currentClassInterfaces);
            current = current.getSuperclass();
        }
        Class[] allInterfaces = new Class[interfaceCount];
        int allInterfacesIndex = 0;
        int i = XTypes.to_int(hierarchy.size());
        while (i-- > 0) {
            Class[] currentClassInterfaces = (Class[])hierarchy.at(i);
            int j = 0;
            while (j < currentClassInterfaces.length) {
                allInterfaces[allInterfacesIndex++] = currentClassInterfaces[j];
                ++j;
            }
        }
        return allInterfaces;
    }

    public static boolean isOfClassType(Class<?> c, Class<?> superclass) {
        if (c.isInterface() || superclass.isInterface()) {
            return false;
        }
        return c == superclass || XReflect.isSubClassOf(c, superclass);
    }

    public static boolean isSubClassOf(Class<?> c, Class<?> superclass) {
        if (c == null || superclass == null) {
            return false;
        }
        Class<?> currentType = c;
        while (currentType != null) {
            if ((currentType = currentType.getSuperclass()) != superclass) continue;
            return true;
        }
        return false;
    }

    public static boolean isActualClass(Class<?> type) {
        return !type.isInterface() && !type.isPrimitive() && !type.isAnnotation() && !type.isArray() && !type.isSynthetic();
    }

    public static boolean isEnum(Class<?> c) {
        return Enum.class.isAssignableFrom(c);
    }

    public static boolean isDeclaredEnum(Class<?> c) {
        return c != null && c.isEnum();
    }

    public static boolean isSubEnum(Class<?> c) {
        return c != null && XReflect.isDeclaredEnum(c.getSuperclass());
    }

    public static Class<?> getDeclaredEnumClass(Class<?> c) {
        return !XReflect.isEnum(c) ? null : (XReflect.isDeclaredEnum(c) ? c : c.getSuperclass());
    }

    public static Object resolveEnumConstantInstance(Class<?> type, int ordinal) {
        XReflect.validateIsEnum(type);
        ?[] jvmEnumConstants = XReflect.getDeclaredEnumClass(type).getEnumConstants();
        return jvmEnumConstants[ordinal];
    }

    public static <T> T resolveEnumConstantInstanceTyped(Class<T> type, int ordinal) {
        Object enumConstantInstance;
        Object enumConstantinstance = enumConstantInstance = XReflect.resolveEnumConstantInstance(type, ordinal);
        return (T)enumConstantinstance;
    }

    public static <T> Class<T> validateIsEnum(Class<T> type) {
        if (XReflect.isEnum(type)) {
            return type;
        }
        throw new IllegalArgumentException("Not an enum type: " + type);
    }

    public static <L extends Consumer<Field>> L iterateDeclaredFieldsUpwards(Class<?> startingClass, L logic) {
        return XReflect.iterateDeclaredFieldsUpwards(startingClass, Object.class, logic);
    }

    public static <L extends Consumer<Field>> L iterateDeclaredFieldsUpwards(Class<?> startingClass, Class<?> boundingClass, L logic) {
        if (startingClass.isArray() || startingClass.getSuperclass() == null) {
            return logic;
        }
        try {
            Class<?> currentClass = startingClass;
            while (currentClass != Object.class) {
                Field[] fields = currentClass.getDeclaredFields();
                int i = fields.length;
                while (i-- > 0) {
                    logic.accept((Field)fields[i]);
                }
                currentClass = currentClass.getSuperclass();
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return logic;
    }

    public static Field getDeclaredField(Class<?> c, String name) throws NoSuchFieldRuntimeException {
        try {
            return c.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldRuntimeException(e);
        }
    }

    public static Method getDeclaredMethod(Class<?> c, String name, Class<?> ... parameterTypes) throws NoSuchFieldRuntimeException {
        try {
            return c.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodRuntimeException(e);
        }
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> c, Class<?> ... parameterTypes) throws NoSuchFieldRuntimeException {
        try {
            return c.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodRuntimeException(e);
        }
    }

    public static Field getField(Class<?> c, String name) throws NoSuchFieldRuntimeException {
        try {
            return c.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldRuntimeException(e);
        }
    }

    public static Field getAnyField(Class<?> c, String name) throws NoSuchFieldRuntimeException {
        X.notNull(name);
        try {
            return XReflect.getAnyField(c, (? super Field field) -> name.equals(field.getName()));
        }
        catch (NoSuchFieldRuntimeException e) {
            throw new NoSuchFieldRuntimeException(new NoSuchFieldException("No field with name " + name + " found in type " + c));
        }
    }

    public static Field getAnyField(Class<?> c, Predicate<? super Field> predicate) throws NoSuchFieldRuntimeException {
        XReference<Object> result = X.Reference(null);
        XReflect.iterateDeclaredFieldsUpwards(c, field -> {
            if (predicate.test((Field)field)) {
                result.set(field);
                throw X.BREAK();
            }
        });
        if (result.get() != null) {
            return (Field)result.get();
        }
        throw new NoSuchFieldRuntimeException(new NoSuchFieldException());
    }

    public static Field getInstanceFieldOfType(Class<?> declaringType, Class<?> fieldType) throws NoSuchFieldRuntimeException {
        try {
            return XReflect.getAnyField(declaringType, (? super Field f) -> XReflect.isInstanceField(f) && fieldType.isAssignableFrom(f.getType()));
        }
        catch (NoSuchFieldRuntimeException e) {
            throw new NoSuchFieldRuntimeException(new NoSuchFieldException("No instance field of type " + fieldType.getName() + " found in type " + declaringType));
        }
    }

    public static Method getAnyMethod(Class<?> c, String name) throws NoSuchMethodRuntimeException {
        X.notNull(name);
        try {
            return XReflect.getAnyMethod(c, (? super Method method) -> name.equals(method.getName()));
        }
        catch (NoSuchFieldRuntimeException e) {
            throw new NoSuchMethodRuntimeException(new NoSuchMethodException("No method with name " + name + " found in type " + c));
        }
    }

    public static Method getAnyMethod(Class<?> c, Predicate<? super Method> predicate) throws NoSuchMethodRuntimeException {
        XReference<Object> result = X.Reference(null);
        XReflect.iterateAllClassMethods(c, field -> {
            if (predicate.test((Method)field)) {
                result.set(field);
                throw X.BREAK();
            }
        });
        if (result.get() != null) {
            return (Method)result.get();
        }
        throw new NoSuchMethodRuntimeException(new NoSuchMethodException());
    }

    public static <C extends Consumer<? super Method>> C iterateAllClassMethods(Class<?> clazz, C logic) {
        return XReflect.iterateAllClassMethods(clazz, Object.class, logic);
    }

    public static <C extends Consumer<? super Method>> C iterateAllClassMethods(Class<?> clazz, Class<?> bound, C logic) {
        if (clazz.isArray() || clazz.getSuperclass() == null) {
            return logic;
        }
        try {
            Class<?> currentClass = clazz;
            while (currentClass != bound) {
                Method[] methodArray = currentClass.getDeclaredMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    logic.accept((Method)method);
                    ++n2;
                }
                currentClass = currentClass.getSuperclass();
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return logic;
    }

    public static boolean isFinal(Member field) {
        return Modifier.isFinal(field.getModifiers());
    }

    public static boolean isStatic(Member field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static boolean isSynthetic(Member field) {
        return Modifier.isSynchronized(field.getModifiers());
    }

    public static boolean isStaticFinal(Member field) {
        return XReflect.isStatic(field) && XReflect.isFinal(field);
    }

    public static boolean isPrimitive(Field field) {
        return field.getType().isPrimitive();
    }

    public static boolean isReference(Field field) {
        return !field.getType().isPrimitive();
    }

    public static boolean isTransient(Field field) {
        return Modifier.isTransient(field.getModifiers());
    }

    public static boolean isNotTransient(Field field) {
        return !Modifier.isTransient(field.getModifiers());
    }

    public static boolean isPrivate(Member field) {
        return Modifier.isPrivate(field.getModifiers());
    }

    public static boolean isProtected(Member field) {
        return Modifier.isProtected(field.getModifiers());
    }

    public static boolean isPublic(Member field) {
        return Modifier.isPublic(field.getModifiers());
    }

    public static boolean isDefaultVisible(Member field) {
        int modifiers = field.getModifiers();
        return !Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPublic(modifiers);
    }

    public static boolean isAbstract(Class<?> type) {
        return Modifier.isAbstract(type.getModifiers());
    }

    public static boolean isAbstract(Method method) {
        return Modifier.isAbstract(method.getModifiers());
    }

    public static Object getFieldValue(Field field, Object obj) {
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(e);
        }
    }

    public static <T> T invoke(Constructor<T> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invoke(Method method, Object instance, Object ... args) {
        try {
            return (T)method.invoke(instance, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldValue(Field field, Object obj, Object value) {
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(e);
        }
    }

    public static int getField_int(Field f, Object obj) throws IllegalAccessRuntimeException {
        try {
            return f.getInt(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(e);
        }
    }

    public static Class<?> resolveType(String typeName, ClassLoader classLoader) throws LinkageError, ExceptionInInitializerError, ClassNotFoundException {
        Class<?> type = XReflect.tryResolvePrimitiveType(typeName);
        return type != null ? type : Class.forName(typeName, true, classLoader);
    }

    public static Class<?> resolveTypeForName(String typeName) throws LinkageError, ExceptionInInitializerError, ClassNotFoundException {
        Class<?> type = XReflect.tryResolvePrimitiveType(typeName);
        return type != null ? type : Class.forName(typeName);
    }

    public static Class<?> tryResolveType(String typeName, ClassLoader classLoader) {
        try {
            return XReflect.resolveType(typeName, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class<?> iterativeResolveType(ClassLoader classLoader, String ... typeNames) throws ClassNotFoundException {
        Class<?> type = XReflect.tryIterativeResolveType(classLoader, typeNames);
        if (type != null) {
            return type;
        }
        throw new ClassNotFoundException(Arrays.toString(typeNames));
    }

    public static Class<?> tryIterativeResolveType(ClassLoader classLoader, String ... typeNames) {
        X.notNull(typeNames);
        X.notEmpty(typeNames);
        String[] stringArray = typeNames;
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String typeName = stringArray[n2];
            try {
                Class<?> type = XReflect.resolveType(typeName, classLoader);
                return type;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++n2;
            }
        }
        return null;
    }

    public static ClassLoader defaultTypeResolvingClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public static Class<?> resolveType(String typeName) throws LinkageError, ExceptionInInitializerError, ClassNotFoundException {
        return XReflect.resolveType(typeName, XReflect.defaultTypeResolvingClassLoader());
    }

    public static Class<?> tryResolveType(String typeName) {
        return XReflect.tryResolveType(typeName, XReflect.defaultTypeResolvingClassLoader());
    }

    public static Class<?> iterativeResolveType(String ... typeNames) throws ClassNotFoundException {
        return XReflect.iterativeResolveType(XReflect.defaultTypeResolvingClassLoader(), typeNames);
    }

    public static Class<?> tryIterativeResolveType(String ... typeNames) {
        return XReflect.tryIterativeResolveType(XReflect.defaultTypeResolvingClassLoader(), typeNames);
    }

    public static Field tryGetDeclaredField(Class<?> declaringClass, String fieldName) {
        if (declaringClass == null) {
            return null;
        }
        try {
            return declaringClass.getDeclaredField(fieldName);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    public static Class<?> tryResolvePrimitiveType(String className) {
        switch (className) {
            case "byte": {
                return Byte.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        return null;
    }

    public static boolean isPrimitiveTypeName(String typeName) {
        return XReflect.tryResolvePrimitiveType(typeName) != null;
    }

    public static boolean isOfAnyType(Class<?> subject, Class<?> ... supertypes) {
        Class<?>[] classArray = supertypes;
        int n = supertypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> s = classArray[n2];
            if (s.isAssignableFrom(subject)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isOfAnyType(Class<?> subject, Iterable<Class<?>> supertypes) {
        for (Class<?> s : supertypes) {
            if (!s.isAssignableFrom(subject)) continue;
            return true;
        }
        return false;
    }

    public static <T> Class<T> getClass(T object) {
        return object.getClass();
    }

    public static char fieldIdentifierDelimiter() {
        return '#';
    }

    public static String typename_enum() {
        return "enum";
    }

    public static char nestedClassNameSeparator() {
        return '$';
    }

    public static String toFullQualifiedFieldName(Class<?> actualClass, Field field) {
        return actualClass == field.getDeclaringClass() ? XReflect.deriveFieldIdentifier(field) : XReflect.toFullQualifiedFieldName(actualClass, XReflect.deriveFieldIdentifier(field));
    }

    public static String deriveFieldIdentifier(Field field) {
        return XReflect.toFullQualifiedFieldName(field.getDeclaringClass(), field.getName());
    }

    public static String toFullQualifiedFieldName(Class<?> c, String fieldName) {
        return String.valueOf(c.getName()) + XReflect.fieldIdentifierDelimiter() + fieldName;
    }

    public static int getFieldIdentifierDelimiterIndex(String identifier) {
        int index = identifier.lastIndexOf(XReflect.fieldIdentifierDelimiter());
        if (index < 0) {
            throw new IllegalArgumentException("No delimiter found in identifier");
        }
        return index;
    }

    public static String getFieldIdentifierClassName(String fieldIdentifier) {
        return fieldIdentifier.substring(0, XReflect.getFieldIdentifierDelimiterIndex(fieldIdentifier));
    }

    public static String getFieldIdentifierFieldName(String fieldIdentifier) {
        return fieldIdentifier.substring(XReflect.getFieldIdentifierDelimiterIndex(fieldIdentifier) + 1);
    }

    public static <A> Class<A> validateInterfaceType(Class<A> type) {
        if (!type.isInterface()) {
            throw UtilStackTrace.cutStacktraceByOne(new IllegalArgumentException("Not an interface type:" + type));
        }
        return type;
    }

    public static <A> Class<A> validateNonInterfaceType(Class<A> type) {
        if (type.isInterface()) {
            throw UtilStackTrace.cutStacktraceByOne(new IllegalArgumentException("Interface type:" + type));
        }
        return type;
    }

    public static <A> Class<A> validateNonArrayType(Class<A> type) {
        if (type.isArray()) {
            throw UtilStackTrace.cutStacktraceByOne(new IllegalArgumentException("Array type:" + type));
        }
        return type;
    }

    public static <A> Class<A> validateArrayType(Class<A> arrayType) {
        if (!arrayType.isArray()) {
            throw UtilStackTrace.cutStacktraceByOne(new IllegalArgumentException("Not an array type:" + arrayType));
        }
        return arrayType;
    }

    public static <A> Class<A> validatePrimitiveType(Class<A> primitiveType) {
        if (!primitiveType.isPrimitive()) {
            throw UtilStackTrace.cutStacktraceByOne(new IllegalArgumentException("Not a primitive type:" + primitiveType));
        }
        return primitiveType;
    }

    public static <A> Class<A> validateNonPrimitiveType(Class<A> primitiveType) {
        if (primitiveType.isPrimitive()) {
            throw UtilStackTrace.cutStacktraceByOne(new IllegalArgumentException("Primitive type:" + primitiveType));
        }
        return primitiveType;
    }

    public static <T> Instantiator<T> WrapDefaultConstructor(Class<T> type) throws NoSuchMethodRuntimeException {
        try {
            return Instantiator.WrapDefaultConstructor(type.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodRuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isJavaUtilCollectionType(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type);
    }

    public static boolean hasEnumeratedTypeName(Class<?> type) {
        String typeName = type.getName();
        int lastIndex = typeName.length() - 1;
        int i = 0;
        while (i < lastIndex) {
            i = typeName.indexOf(XReflect.nestedClassNameSeparator(), i);
            if (i < 0) {
                return false;
            }
            char c = typeName.charAt(i + 1);
            if (XChars.isDigit(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isProxyClass(Class<?> c) {
        return Proxy.class.isAssignableFrom(c);
    }

    public static boolean isValidProxyClass(Class<?> c) {
        return Proxy.isProxyClass(c);
    }

    public static Field[] collectPrimitiveFieldsByByteSize(Field[] fields, int byteSize) {
        if (byteSize != XMemory.byteSize_byte() && byteSize != XMemory.byteSize_short() && byteSize != XMemory.byteSize_int() && byteSize != XMemory.byteSize_long()) {
            throw new IllegalArgumentException("Invalid Java primitive byte size: " + byteSize);
        }
        Field[] primFields = new Field[fields.length];
        int primFieldsCount = 0;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getType().isPrimitive() && XMemory.byteSizePrimitive(fields[i].getType()) == byteSize) {
                primFields[primFieldsCount++] = fields[i];
            }
            ++i;
        }
        return Arrays.copyOf(primFields, primFieldsCount);
    }

    public static Field[] collectInstanceFields(Class<?> objectClass) {
        return XReflect.collectInstanceFields(objectClass, XFunc.all());
    }

    public static Field[] collectInstanceFields(Class<?> objectClass, Predicate<? super Field> selector) {
        BulkList<Field> objectFields = BulkList.New(20L);
        XReflect.iterateDeclaredFieldsUpwards(objectClass, field -> {
            if (!XReflect.isInstanceField(field)) {
                return;
            }
            if (selector != null && !selector.test((Field)field)) {
                return;
            }
            objectFields.add((Field)field);
        });
        Field[] array = XArrays.reverse(objectFields.toArray(Field.class));
        return array;
    }

    public static int calculatePrimitivesLength(Field[] primFields) {
        int length = 0;
        int i = 0;
        while (i < primFields.length) {
            if (!primFields[i].getType().isPrimitive()) {
                throw new IllegalArgumentException("Not a primitive field: " + primFields[i]);
            }
            length += XMemory.byteSizePrimitive(primFields[i].getType());
            ++i;
        }
        return length;
    }

    public static <T, S extends T> S copyFields(T source, S target) {
        return XReflect.copyFields(source, target, XFunc.all(), CopyPredicate::all);
    }

    public static <T, S extends T> S copyFields(T source, S target, Predicate<? super Field> fieldSelector) {
        return XReflect.copyFields(source, target, fieldSelector, CopyPredicate::all);
    }

    public static <T, S extends T> S copyFields(T source, S target, Predicate<? super Field> fieldSelector, CopyPredicate copySelector) {
        Field[] copyFields;
        XReflect.validateFamiliarClass(source, target);
        Field[] fieldArray = copyFields = XReflect.collectInstanceFields(source.getClass(), fieldSelector);
        int n = copyFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                XReflect.copyFieldValue(source, target, field, copySelector);
            }
            catch (Exception e) {
                throw new MemoryException("Cannot copy value of field " + field + " from source instance " + XChars.systemString(source) + " to target instance " + XChars.systemString(target) + ".", e);
            }
            ++n2;
        }
        return target;
    }

    static <T, S extends T> S copyFields(T source, S target, Field[] copyFields, CopyPredicate copySelector) {
        XReflect.validateFamiliarClass(source, target);
        Field[] fieldArray = copyFields;
        int n = copyFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                XReflect.copyFieldValue(source, target, field, copySelector);
            }
            catch (Exception e) {
                throw new MemoryException("Cannot copy value of field " + field + " from source instance " + XChars.systemString(source) + " to target instance " + XChars.systemString(target) + ".", e);
            }
            ++n2;
        }
        return target;
    }

    private static <T, S extends T> void copyFieldValue(T source, S target, Field field, CopyPredicate copySelector) throws IllegalArgumentException, IllegalAccessException {
        long fieldOffset = XMemory.objectFieldOffset(field);
        if (field.getType().isPrimitive()) {
            XReflect.copyPrimitiveFieldValue(source, target, field, fieldOffset, copySelector);
            return;
        }
        Object value = XMemory.getObject(source, fieldOffset);
        if (!copySelector.test(source, target, field, value)) {
            return;
        }
        XMemory.setObject(target, fieldOffset, value);
    }

    private static <T, S extends T> void copyPrimitiveFieldValue(T source, S target, Field primitiveField, long fieldOffset, CopyPredicate copySelector) throws IllegalArgumentException, IllegalAccessException {
        if (!copySelector.test(source, target, primitiveField, null)) {
            return;
        }
        Class<?> primitiveType = primitiveField.getType();
        if (primitiveType == Integer.TYPE) {
            XMemory.set_int(target, fieldOffset, XMemory.get_int(source, fieldOffset));
        } else if (primitiveType == Double.TYPE) {
            XMemory.set_double(target, fieldOffset, XMemory.get_double(source, fieldOffset));
        } else if (primitiveType == Long.TYPE) {
            XMemory.set_long(target, fieldOffset, XMemory.get_long(source, fieldOffset));
        } else if (primitiveType == Boolean.TYPE) {
            XMemory.set_boolean(target, fieldOffset, XMemory.get_boolean(source, fieldOffset));
        } else if (primitiveType == Float.TYPE) {
            XMemory.set_float(target, fieldOffset, XMemory.get_float(source, fieldOffset));
        } else if (primitiveType == Character.TYPE) {
            XMemory.set_char(target, fieldOffset, XMemory.get_char(source, fieldOffset));
        } else if (primitiveType == Short.TYPE) {
            XMemory.set_short(target, fieldOffset, XMemory.get_short(source, fieldOffset));
        } else if (primitiveType == Byte.TYPE) {
            XMemory.set_byte(target, fieldOffset, XMemory.get_byte(source, fieldOffset));
        } else {
            throw new MemoryException("Field with unhandled primitive type: " + primitiveField);
        }
    }

    public static <T, S extends T> void validateFamiliarClass(T superClassInstance, S sameOrSubClassInstance) {
        if (superClassInstance.getClass().isAssignableFrom(sameOrSubClassInstance.getClass())) {
            return;
        }
        throw new IllegalArgumentException(String.valueOf(XChars.systemString(sameOrSubClassInstance)) + " is not of the same class or a sub class of " + XChars.systemString(superClassInstance));
    }

    public static Class<?> getSuperClassNonNull(Class<?> c) {
        return c == Object.class ? c : c.getSuperclass();
    }

    private XReflect() {
        throw new UnsupportedOperationException();
    }
}

