/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.reference;

import java.util.Iterator;
import org.eclipse.serializer.collections.Singleton;
import org.eclipse.serializer.reference.LinkingReference;
import org.eclipse.serializer.reference.LinkingReferencing;

public interface LinkReference<T>
extends LinkingReference<T> {
    @Override
    public LinkReference<T> next();

    public LinkReference<T> setNext(LinkReference<T> var1);

    public LinkReference<T> link(LinkReference<T> var1);

    public LinkReference<T> link(T var1);

    public LinkReference<T> insert(LinkReference<T> var1);

    public LinkReference<T> removeNext();

    @SafeVarargs
    public static <T> LinkReference<T> New(T ... objects) {
        if (objects == null) {
            return null;
        }
        Default<T> chain = new Default<T>(objects[0]);
        if (objects.length > 1) {
            LinkReference<T> loopRef = chain;
            int i = 1;
            while (i < objects.length) {
                loopRef = loopRef.link(objects[i]);
                ++i;
            }
        }
        return chain;
    }

    public static final class ChainIterator<T>
    implements Iterator<T> {
        private LinkReference<T> current;

        ChainIterator(LinkReference<T> current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current.next() != null;
        }

        @Override
        public T next() {
            LinkReference<T> currentCurrent = this.current;
            this.current = currentCurrent.next();
            return currentCurrent.get();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Can't remove current element in a one directional chain");
        }
    }

    public static class Default<T>
    extends Singleton<T>
    implements LinkReference<T> {
        private LinkReference<T> next;

        public Default(T ref) {
            super(ref);
        }

        @Override
        public LinkReference<T> next() {
            return this.next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public boolean isNext(LinkingReferencing<T> linkedReference) {
            return this.next == linkedReference;
        }

        @Override
        public LinkReference<T> link(LinkReference<T> linkedReference) {
            this.next = linkedReference;
            return linkedReference;
        }

        @Override
        public LinkReference<T> setNext(LinkReference<T> linkedReference) {
            LinkReference<T> old = this.next;
            this.next = linkedReference;
            return old;
        }

        @Override
        public LinkReference<T> link(T nextRef) {
            return this.link((T)new Default<T>(nextRef));
        }

        @Override
        public LinkReference<T> insert(LinkReference<T> linkedReference) {
            LinkReference<T> next = this.next;
            this.next = linkedReference;
            if (next != null) {
                linkedReference.setNext(next);
            }
            return this;
        }

        @Override
        public LinkReference<T> removeNext() {
            LinkReference<T> next = this.next;
            this.next = next == null ? null : next.next();
            return next;
        }

        @Override
        public Object[] toArray() {
            LinkingReferencing<T> loopNext = this;
            int i = 1;
            while ((loopNext = loopNext.next()) != null) {
                ++i;
            }
            Object[] array = new Object[i];
            loopNext = this;
            i = 0;
            do {
                array[i++] = loopNext.get();
            } while ((loopNext = loopNext.next()) != null);
            return array;
        }

        @Override
        public Iterator<T> iterator() {
            return new ChainIterator(this);
        }

        @Override
        public String toString() {
            String e = String.valueOf(this.get());
            return String.valueOf('(') + e + ')' + (this.hasNext() ? (char)'-' : 'x');
        }

        @Override
        public String toChainString() {
            StringBuilder sb = new StringBuilder(1024);
            sb.append('(').append(this.get()).append(')');
            LinkingReferencing<T> r = this.next;
            while (r != null) {
                sb.append('-').append('(').append(r.get()).append(')');
                r = r.next();
            }
            return sb.toString();
        }
    }
}

