/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.monitoring;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.eclipse.serializer.monitoring.MetricMonitor;
import org.eclipse.serializer.util.logging.Logging;
import org.slf4j.Logger;

public interface MonitoringManager {
    public void registerMonitor(MetricMonitor var1);

    public void shutdown();

    public static MonitoringManager New() {
        return new JMX();
    }

    public static MonitoringManager New(String name) {
        return new JMX(name);
    }

    public static class JMX
    implements MonitoringManager {
        private static final Logger logger = Logging.getLogger(MonitoringManager.class);
        private static AtomicInteger instanceID = new AtomicInteger();
        private final List<ObjectInstance> beans = new ArrayList<ObjectInstance>();
        private final String storageName;

        public JMX() {
            this.storageName = "storage" + instanceID.getAndIncrement();
            logger.debug("create MonitoringManager for storage: " + this.storageName);
        }

        public JMX(String storageName) {
            this.storageName = storageName;
        }

        @Override
        public void registerMonitor(MetricMonitor metric) {
            try {
                ObjectInstance bean = ManagementFactory.getPlatformMBeanServer().registerMBean(metric, this.createObjectName(metric));
                this.beans.add(bean);
                logger.debug("Registered JMX bean {}", (Object)bean.getObjectName());
            }
            catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
                logger.warn("Failed to register JMX Bean", (Throwable)e);
            }
        }

        @Override
        public void shutdown() {
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            this.beans.forEach(bean -> {
                try {
                    beanServer.unregisterMBean(bean.getObjectName());
                    logger.debug("Unregistered JMX bean {}", (Object)bean.getObjectName());
                }
                catch (InstanceNotFoundException | MBeanRegistrationException e) {
                    logger.warn("Failed to unregister JMX Bean", (Throwable)e);
                }
            });
            this.beans.clear();
        }

        private ObjectName createObjectName(MetricMonitor metric) throws MalformedObjectNameException {
            return new ObjectName("org.eclipse.store:" + (this.storageName != null ? "storage=" + this.storageName + "," : "") + metric.getName());
        }
    }
}

