/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.monitoring;

import java.lang.ref.WeakReference;
import org.eclipse.serializer.monitoring.LazyReferenceManagerMonitorMBean;
import org.eclipse.serializer.monitoring.MetricMonitor;
import org.eclipse.serializer.reference.LazyReferenceManager;

public class LazyReferenceManagerMonitor
implements LazyReferenceManagerMonitorMBean,
MetricMonitor {
    private final WeakReference<LazyReferenceManager> lazyReferenceManager;
    int lazyRefCount;
    int lazyRefLoadedCount;

    public LazyReferenceManagerMonitor(LazyReferenceManager lazyReferenceManager) {
        this.lazyReferenceManager = new WeakReference<LazyReferenceManager>(lazyReferenceManager);
    }

    @Override
    public int getRegisteredLazyReferencesCount() {
        return this.lazyRefCount;
    }

    @Override
    public int getLoadedLazyReferencesCount() {
        return this.lazyRefLoadedCount;
    }

    @Override
    public int getUnLoadedLazyReferencesCount() {
        return this.lazyRefCount - this.lazyRefLoadedCount;
    }

    @Override
    public void unloadAll() {
        ((LazyReferenceManager)this.lazyReferenceManager.get()).clear();
    }

    @Override
    public String getName() {
        return "name=LazyReferenceManager";
    }

    public void update(int lazyReferences, int loadedLazyReferences) {
        this.lazyRefCount = lazyReferences;
        this.lazyRefLoadedCount = loadedLazyReferences;
    }
}

