/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.memory.sun;

import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.serializer.exceptions.InstantiationRuntimeException;
import org.eclipse.serializer.memory.DirectBufferAddressGetter;
import org.eclipse.serializer.memory.DirectBufferDeallocator;
import org.eclipse.serializer.memory.MemoryStatistics;
import org.eclipse.serializer.memory.XMemory;
import org.eclipse.serializer.memory.sun.JdkDirectBufferAddressGetter;
import org.eclipse.serializer.memory.sun.JdkDirectBufferDeallocator;
import org.eclipse.serializer.reflect.XReflect;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;
import sun.misc.Unsafe;

public final class JdkInternals {
    private static final Unsafe VM = JdkInternals.getMemoryAccess();
    private static final int BYTE_SIZE_OBJECT_HEADER = JdkInternals.calculateByteSizeObjectHeader();
    private static final int MEMORY_ALIGNMENT_FACTOR = 8;
    private static final int MEMORY_ALIGNMENT_MODULO = 7;
    private static final int MEMORY_ALIGNMENT_MASK = -8;
    private static final long ARRAY_BYTE_BASE_OFFSET = Unsafe.ARRAY_BYTE_BASE_OFFSET;
    private static final long ARRAY_BOOLEAN_BASE_OFFSET = Unsafe.ARRAY_BOOLEAN_BASE_OFFSET;
    private static final long ARRAY_SHORT_BASE_OFFSET = Unsafe.ARRAY_SHORT_BASE_OFFSET;
    private static final long ARRAY_CHAR_BASE_OFFSET = Unsafe.ARRAY_CHAR_BASE_OFFSET;
    private static final long ARRAY_INT_BASE_OFFSET = Unsafe.ARRAY_INT_BASE_OFFSET;
    private static final long ARRAY_FLOAT_BASE_OFFSET = Unsafe.ARRAY_FLOAT_BASE_OFFSET;
    private static final long ARRAY_LONG_BASE_OFFSET = Unsafe.ARRAY_LONG_BASE_OFFSET;
    private static final long ARRAY_DOUBLE_BASE_OFFSET = Unsafe.ARRAY_DOUBLE_BASE_OFFSET;
    private static final long ARRAY_OBJECT_BASE_OFFSET = Unsafe.ARRAY_OBJECT_BASE_OFFSET;
    static final ArrayList<Warning> INITIALIZATION_WARNINGS = new ArrayList();
    static final Class<?> CLASS_Cleaner = JdkInternals.tryIterativeResolveType("sun.misc.Cleaner", "jdk.internal.ref.Cleaner");
    static final String FIELD_NAME_address = "address";
    static final String FIELD_NAME_cleaner = "cleaner";
    static final String FIELD_NAME_thunk = "thunk";
    static final long FIELD_OFFSET_Buffer_address = JdkInternals.tryGetFieldOffset(Buffer.class, "address");
    static final long FIELD_OFFSET_DirectByteBuffer_cleaner = JdkInternals.tryGetFieldOffset(XTypes.directByteBufferClass(), "cleaner");
    static final long FIELD_OFFSET_Cleaner_thunk = JdkInternals.tryGetFieldOffset(CLASS_Cleaner, "thunk");
    private static DirectBufferDeallocator directBufferDeallocator = JdkInternals.initializeDirectBufferDeallocator();
    private static DirectBufferAddressGetter directBufferAddressGetter = JdkInternals.initializeDirectBufferAddressGetter();
    private static Object internalVM;
    private static Method internalObjectFieldOffsetMethod;

    public static Unsafe VM() {
        return VM;
    }

    static final String fieldNameUnsafe() {
        return "theUnsafe";
    }

    public static final Unsafe getMemoryAccess() {
        if (JdkInternals.class.getClassLoader() == null) {
            return Unsafe.getUnsafe();
        }
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField(JdkInternals.fieldNameUnsafe());
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new Error("Could not obtain access to \"" + JdkInternals.fieldNameUnsafe() + "\"", e);
        }
    }

    static final Class<?> tryIterativeResolveType(String ... typeNames) {
        Class<?> type = XReflect.tryIterativeResolveType(ClassLoader.getSystemClassLoader(), typeNames);
        if (type != null) {
            return type;
        }
        JdkInternals.addInitializationWarning("No runtime type could have been found for the given type name list " + Arrays.toString(typeNames));
        return null;
    }

    public static void guaranteeUsability() {
        if (directBufferAddressGetter == null) {
            throw new Error("No means to obtain the DirectByteBuffer address value. Use #setDirectBufferAddressGetter.");
        }
        if (directBufferDeallocator == null) {
            throw new Error("No means to deallocate the DirectBuffer off-heap memory. Use #setDirectBufferDeallocator.");
        }
    }

    static final String localWarningHeader() {
        return "WARNING (" + JdkInternals.class.getName() + "): ";
    }

    private static void addInitializationWarning(String message) {
        JdkInternals.addInitializationWarning(message, null);
    }

    private static void addInitializationWarning(String message, Throwable cause) {
        INITIALIZATION_WARNINGS.add(new Warning.Default(message, cause));
    }

    static final long tryGetFieldOffset(Class<?> type, String declaredFieldName) {
        if (type == null) {
            JdkInternals.addInitializationWarning("Cannot resolve declared field \"" + declaredFieldName + "\" in an unresolved type.");
            return -1L;
        }
        Exception cause = null;
        Class<?> c = type;
        while (c != null && c != Object.class) {
            try {
                Field[] fieldArray = c.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (field.getName().equals(declaredFieldName)) {
                        return XMemory.objectFieldOffset(field);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                cause = e;
            }
            c = c.getSuperclass();
        }
        JdkInternals.addInitializationWarning("No declared field with name \"" + declaredFieldName + "\" could have been found in the class hierarchy beginning at " + type, cause);
        return -1L;
    }

    private static DirectBufferAddressGetter initializeDirectBufferAddressGetter() {
        if (FIELD_OFFSET_Buffer_address < 0L) {
            return null;
        }
        return new JdkDirectBufferAddressGetter();
    }

    private static DirectBufferDeallocator initializeDirectBufferDeallocator() {
        if (FIELD_OFFSET_DirectByteBuffer_cleaner < 0L || FIELD_OFFSET_Cleaner_thunk < 0L || FIELD_OFFSET_Buffer_address < 0L) {
            return DirectBufferDeallocator.NoOp();
        }
        return new JdkDirectBufferDeallocator();
    }

    public static final long internalGetDirectByteBufferAddress(ByteBuffer directBuffer) {
        XTypes.guaranteeDirectByteBuffer(directBuffer);
        return JdkInternals.get_long(directBuffer, FIELD_OFFSET_Buffer_address);
    }

    public static final long getDirectByteBufferAddress(ByteBuffer directBuffer) {
        if (directBufferAddressGetter == null) {
            throw new Error("No means to get a DirectByteBuffer's address available.");
        }
        return directBufferAddressGetter.getDirectBufferAddress(directBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean internalDeallocateDirectBuffer(ByteBuffer directBuffer) {
        if (directBuffer == null) {
            return false;
        }
        XTypes.guaranteeDirectByteBuffer(directBuffer);
        Object cleaner = JdkInternals.getObject(directBuffer, FIELD_OFFSET_DirectByteBuffer_cleaner);
        Object cleanerThunkDeallocatorRunnable = JdkInternals.getObject(cleaner, FIELD_OFFSET_Cleaner_thunk);
        if (!(cleanerThunkDeallocatorRunnable instanceof Runnable)) {
            return false;
        }
        Object object = cleanerThunkDeallocatorRunnable;
        synchronized (object) {
            ((Runnable)cleanerThunkDeallocatorRunnable).run();
            JdkInternals.set_long(directBuffer, FIELD_OFFSET_Buffer_address, 0L);
        }
        return true;
    }

    public static final boolean deallocateDirectBuffer(ByteBuffer directBuffer) {
        if (directBuffer == null) {
            return false;
        }
        return directBufferDeallocator.deallocateDirectBuffer(directBuffer);
    }

    public static final long allocateMemory(long bytes) {
        return VM.allocateMemory(bytes);
    }

    public static final long reallocateMemory(long address, long bytes) {
        return VM.reallocateMemory(address, bytes);
    }

    public static final void freeMemory(long address) {
        VM.freeMemory(address);
    }

    public static final void fillMemory(long address, long length, byte value) {
        VM.setMemory(address, length, value);
    }

    public static final byte get_byte(long address) {
        return VM.getByte(address);
    }

    public static final boolean get_boolean(long address) {
        return VM.getBoolean(null, address);
    }

    public static final short get_short(long address) {
        return VM.getShort(address);
    }

    public static final char get_char(long address) {
        return VM.getChar(address);
    }

    public static final int get_int(long address) {
        return VM.getInt(address);
    }

    public static final float get_float(long address) {
        return VM.getFloat(address);
    }

    public static final long get_long(long address) {
        return VM.getLong(address);
    }

    public static final double get_double(long address) {
        return VM.getDouble(address);
    }

    public static byte get_byte(Object instance, long offset) {
        return VM.getByte(instance, offset);
    }

    public static boolean get_boolean(Object instance, long offset) {
        return VM.getBoolean(instance, offset);
    }

    public static short get_short(Object instance, long offset) {
        return VM.getShort(instance, offset);
    }

    public static char get_char(Object instance, long offset) {
        return VM.getChar(instance, offset);
    }

    public static int get_int(Object instance, long offset) {
        return VM.getInt(instance, offset);
    }

    public static float get_float(Object instance, long offset) {
        return VM.getFloat(instance, offset);
    }

    public static long get_long(Object instance, long offset) {
        return VM.getLong(instance, offset);
    }

    public static double get_double(Object instance, long offset) {
        return VM.getDouble(instance, offset);
    }

    public static Object getObject(Object instance, long offset) {
        return VM.getObject(instance, offset);
    }

    public static void set_byte(long address, byte value) {
        VM.putByte(address, value);
    }

    public static void set_boolean(long address, boolean value) {
        VM.putBoolean(null, address, value);
    }

    public static void set_short(long address, short value) {
        VM.putShort(address, value);
    }

    public static void set_char(long address, char value) {
        VM.putChar(address, value);
    }

    public static void set_int(long address, int value) {
        VM.putInt(address, value);
    }

    public static void set_float(long address, float value) {
        VM.putFloat(address, value);
    }

    public static void set_long(long address, long value) {
        VM.putLong(address, value);
    }

    public static void set_double(long address, double value) {
        VM.putDouble(address, value);
    }

    public static final void set_byte(Object instance, long offset, byte value) {
        VM.putByte(instance, offset, value);
    }

    public static final void set_boolean(Object instance, long offset, boolean value) {
        VM.putBoolean(instance, offset, value);
    }

    public static void set_short(Object instance, long offset, short value) {
        VM.putShort(instance, offset, value);
    }

    public static final void set_char(Object instance, long offset, char value) {
        VM.putChar(instance, offset, value);
    }

    public static final void set_int(Object instance, long offset, int value) {
        VM.putInt(instance, offset, value);
    }

    public static final void set_float(Object instance, long offset, float value) {
        VM.putFloat(instance, offset, value);
    }

    public static final void set_long(Object instance, long offset, long value) {
        VM.putLong(instance, offset, value);
    }

    public static final void set_double(Object instance, long offset, double value) {
        VM.putDouble(instance, offset, value);
    }

    public static final void setObject(Object instance, long offset, Object value) {
        VM.putObject(instance, offset, value);
    }

    public static final void set_byteInBytes(byte[] bytes, int index, byte value) {
        VM.putByte(bytes, ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static final void set_booleanInBytes(byte[] bytes, int index, boolean value) {
        VM.putBoolean(bytes, ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static final void set_shortInBytes(byte[] bytes, int index, short value) {
        VM.putShort(bytes, ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static final void set_charInBytes(byte[] bytes, int index, char value) {
        VM.putChar(bytes, ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static final void set_intInBytes(byte[] bytes, int index, int value) {
        VM.putInt(bytes, ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static final void set_floatInBytes(byte[] bytes, int index, float value) {
        VM.putFloat(bytes, ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static final void set_longInBytes(byte[] bytes, int index, long value) {
        VM.putLong(bytes, ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static final void set_doubleInBytes(byte[] bytes, int index, double value) {
        VM.putDouble(bytes, ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static final void copyRange(long sourceAddress, long targetAddress, long length) {
        VM.copyMemory(sourceAddress, targetAddress, length);
    }

    public static final void copyRangeToArray(long sourceAddress, byte[] target) {
        VM.copyMemory(null, sourceAddress, target, ARRAY_BYTE_BASE_OFFSET, target.length);
    }

    public static final void copyRangeToArray(long sourceAddress, boolean[] target) {
        VM.copyMemory(null, sourceAddress, target, ARRAY_BOOLEAN_BASE_OFFSET, target.length);
    }

    public static final void copyRangeToArray(long sourceAddress, short[] target) {
        VM.copyMemory(null, sourceAddress, target, ARRAY_SHORT_BASE_OFFSET, (long)target.length * 2L);
    }

    public static final void copyRangeToArray(long sourceAddress, char[] target) {
        VM.copyMemory(null, sourceAddress, target, ARRAY_CHAR_BASE_OFFSET, (long)target.length * 2L);
    }

    public static final void copyRangeToArray(long sourceAddress, int[] target) {
        VM.copyMemory(null, sourceAddress, target, ARRAY_INT_BASE_OFFSET, (long)target.length * 4L);
    }

    public static final void copyRangeToArray(long sourceAddress, float[] target) {
        VM.copyMemory(null, sourceAddress, target, ARRAY_FLOAT_BASE_OFFSET, (long)target.length * 4L);
    }

    public static final void copyRangeToArray(long sourceAddress, long[] target) {
        VM.copyMemory(null, sourceAddress, target, ARRAY_LONG_BASE_OFFSET, (long)target.length * 8L);
    }

    public static final void copyRangeToArray(long sourceAddress, double[] target) {
        VM.copyMemory(null, sourceAddress, target, ARRAY_DOUBLE_BASE_OFFSET, (long)target.length * 8L);
    }

    public static final void copyArrayToAddress(byte[] array, long targetAddress) {
        VM.copyMemory(array, ARRAY_BYTE_BASE_OFFSET, null, targetAddress, array.length);
    }

    public static final void copyArrayToAddress(boolean[] array, long targetAddress) {
        VM.copyMemory(array, ARRAY_BOOLEAN_BASE_OFFSET, null, targetAddress, array.length);
    }

    public static final void copyArrayToAddress(short[] array, long targetAddress) {
        VM.copyMemory(array, ARRAY_SHORT_BASE_OFFSET, null, targetAddress, (long)array.length * 2L);
    }

    public static final void copyArrayToAddress(char[] array, long targetAddress) {
        VM.copyMemory(array, ARRAY_CHAR_BASE_OFFSET, null, targetAddress, (long)array.length * 2L);
    }

    public static final void copyArrayToAddress(int[] array, long targetAddress) {
        VM.copyMemory(array, ARRAY_INT_BASE_OFFSET, null, targetAddress, (long)array.length * 4L);
    }

    public static final void copyArrayToAddress(float[] array, long targetAddress) {
        VM.copyMemory(array, ARRAY_FLOAT_BASE_OFFSET, null, targetAddress, (long)array.length * 4L);
    }

    public static final void copyArrayToAddress(long[] array, long targetAddress) {
        VM.copyMemory(array, ARRAY_LONG_BASE_OFFSET, null, targetAddress, (long)array.length * 8L);
    }

    public static final void copyArrayToAddress(double[] array, long targetAddress) {
        VM.copyMemory(array, ARRAY_DOUBLE_BASE_OFFSET, null, targetAddress, (long)array.length * 8L);
    }

    public static final byte[] asByteArray(long[] longArray) {
        byte[] bytes = new byte[JdkInternals.checkArrayRange((long)longArray.length * 8L)];
        VM.copyMemory(longArray, ARRAY_LONG_BASE_OFFSET, bytes, ARRAY_BYTE_BASE_OFFSET, bytes.length);
        return bytes;
    }

    public static final byte[] asByteArray(long value) {
        byte[] bytes = new byte[XMemory.byteSize_long()];
        JdkInternals.set_long(bytes, ARRAY_BYTE_BASE_OFFSET, value);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object internalVM() {
        Object internalVM = JdkInternals.internalVM;
        if (internalVM != null) return internalVM;
        Class<JdkInternals> clazz = JdkInternals.class;
        synchronized (JdkInternals.class) {
            internalVM = JdkInternals.internalVM;
            if (internalVM != null) return internalVM;
            JdkInternals.internalVM = JdkInternals.createInternalVM();
            return JdkInternals.internalVM;
        }
    }

    private static Object createInternalVM() {
        try {
            return Class.forName("jdk.internal.misc.Unsafe").getMethod("getUnsafe", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new Error("Could not obtain access to \"jdk.internal.misc.Unsafe\", please start the VM with --add-exports java.base/jdk.internal.misc=ALL-UNNAMED", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Method internalObjectFieldOffsetMethod() {
        Method internalObjectFieldOffsetMethod = JdkInternals.internalObjectFieldOffsetMethod;
        if (internalObjectFieldOffsetMethod != null) return internalObjectFieldOffsetMethod;
        Class<JdkInternals> clazz = JdkInternals.class;
        synchronized (JdkInternals.class) {
            internalObjectFieldOffsetMethod = JdkInternals.internalObjectFieldOffsetMethod;
            if (internalObjectFieldOffsetMethod != null) return internalObjectFieldOffsetMethod;
            JdkInternals.internalObjectFieldOffsetMethod = JdkInternals.lookupInternalObjectFieldOffsetMethod();
            return JdkInternals.internalObjectFieldOffsetMethod;
        }
    }

    private static Method lookupInternalObjectFieldOffsetMethod() {
        try {
            return JdkInternals.internalVM().getClass().getMethod("objectFieldOffset", Field.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new Error("Could not obtain access to \"jdk.internal.misc.Unsafe#objectFieldOffset\"", e);
        }
    }

    public static final long objectFieldOffset(Field field) {
        try {
            return VM.objectFieldOffset(field);
        }
        catch (UnsupportedOperationException uoe) {
            try {
                return (Long)JdkInternals.internalObjectFieldOffsetMethod().invoke(JdkInternals.internalVM(), field);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new Error("Error invoking \"jdk.internal.misc.Unsafe#objectFieldOffset\"", e);
            }
        }
    }

    public static final long[] objectFieldOffsets(Field ... fields) {
        long[] offsets = new long[fields.length];
        int i = 0;
        while (i < fields.length) {
            if (Modifier.isStatic(fields[i].getModifiers())) {
                throw new IllegalArgumentException("Not an object field: " + fields[i]);
            }
            offsets[i] = JdkInternals.objectFieldOffset(fields[i]);
            ++i;
        }
        return offsets;
    }

    public static final void ensureClassInitialized(Class<?> c) {
        VM.ensureClassInitialized(c);
    }

    public static final <T> T instantiateBlank(Class<T> c) throws InstantiationRuntimeException {
        try {
            return (T)VM.allocateInstance(c);
        }
        catch (InstantiationException e) {
            throw new InstantiationRuntimeException(e);
        }
    }

    public static int pageSize() {
        return VM.pageSize();
    }

    public static final int byteSizeReference() {
        return Unsafe.ARRAY_OBJECT_INDEX_SCALE;
    }

    public static int byteSizeInstance(Class<?> type) {
        if (type.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        if (type.isArray()) {
            return VM.arrayBaseOffset(type);
        }
        if (type == Object.class) {
            return JdkInternals.byteSizeObjectHeader();
        }
        Field[] declaredFields = type.getDeclaredFields();
        long maxInstanceFieldOffset = 0L;
        Field maxInstanceField = null;
        int i = 0;
        while (i < declaredFields.length) {
            long fieldOffset;
            if (!Modifier.isStatic(declaredFields[i].getModifiers()) && (fieldOffset = VM.objectFieldOffset(declaredFields[i])) >= maxInstanceFieldOffset) {
                maxInstanceField = declaredFields[i];
                maxInstanceFieldOffset = fieldOffset;
            }
            ++i;
        }
        if (maxInstanceField == null) {
            return JdkInternals.byteSizeInstance(type.getSuperclass());
        }
        return (int)JdkInternals.alignAddress(maxInstanceFieldOffset + (long)JdkInternals.byteSizeFieldValue(maxInstanceField.getType()));
    }

    public static final int byteSizeObjectHeader() {
        return BYTE_SIZE_OBJECT_HEADER;
    }

    private static final int calculateByteSizeObjectHeader() {
        Field[] declaredFields;
        long minOffset = Long.MAX_VALUE;
        Field[] fieldArray = declaredFields = ObjectHeaderSizeDummy.class.getDeclaredFields();
        int n = declaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!Modifier.isStatic(field.getModifiers()) && VM.objectFieldOffset(field) < minOffset) {
                minOffset = VM.objectFieldOffset(field);
            }
            ++n2;
        }
        if (minOffset == Long.MAX_VALUE) {
            throw new Error("Could not find object header dummy field in class " + ObjectHeaderSizeDummy.class);
        }
        return (int)minOffset;
    }

    public static final int byteSizeFieldValue(Class<?> type) {
        return type.isPrimitive() ? XMemory.byteSizePrimitive(type) : JdkInternals.byteSizeReference();
    }

    public static final long byteSizeArray_byte(long elementCount) {
        return ARRAY_BYTE_BASE_OFFSET + elementCount;
    }

    public static final long byteSizeArray_boolean(long elementCount) {
        return ARRAY_BOOLEAN_BASE_OFFSET + elementCount;
    }

    public static final long byteSizeArray_short(long elementCount) {
        return ARRAY_SHORT_BASE_OFFSET + elementCount * 2L;
    }

    public static final long byteSizeArray_char(long elementCount) {
        return ARRAY_CHAR_BASE_OFFSET + elementCount * 2L;
    }

    public static final long byteSizeArray_int(long elementCount) {
        return ARRAY_INT_BASE_OFFSET + elementCount * 4L;
    }

    public static final long byteSizeArray_float(long elementCount) {
        return ARRAY_FLOAT_BASE_OFFSET + elementCount * 4L;
    }

    public static final long byteSizeArray_long(long elementCount) {
        return ARRAY_LONG_BASE_OFFSET + elementCount * 8L;
    }

    public static final long byteSizeArray_double(long elementCount) {
        return ARRAY_DOUBLE_BASE_OFFSET + elementCount * 8L;
    }

    public static final long byteSizeArrayObject(long elementCount) {
        return ARRAY_OBJECT_BASE_OFFSET + elementCount * (long)JdkInternals.byteSizeReference();
    }

    public static final long alignAddress(long address) {
        if ((address & 7L) == 0L) {
            return address;
        }
        return (address & 0xFFFFFFFFFFFFFFF8L) + 8L;
    }

    private static MemoryStatistics createMemoryStatistics(MemoryUsage usage) {
        return MemoryStatistics.New(usage.getMax(), usage.getCommitted(), usage.getUsed());
    }

    public static MemoryStatistics createHeapMemoryStatistics() {
        return JdkInternals.createMemoryStatistics(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage());
    }

    public static MemoryStatistics createNonHeapMemoryStatistics() {
        return JdkInternals.createMemoryStatistics(ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage());
    }

    private static final int checkArrayRange(long capacity) {
        if (capacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid array length: " + capacity);
        }
        return (int)capacity;
    }

    private JdkInternals() {
        throw new UnsupportedOperationException();
    }

    static final class ObjectHeaderSizeDummy {
        Object calculateByteSizeObjectHeaderFieldOffsetDummy;

        ObjectHeaderSizeDummy() {
        }
    }

    public static interface Warning {
        public String message();

        public Throwable cause();

        public void print(PrintStream var1);

        public static final class Default
        implements Warning {
            final String message;
            final Throwable cause;

            Default(String message, Throwable cause) {
                this.message = message;
                this.cause = cause;
            }

            @Override
            public String message() {
                return this.message;
            }

            @Override
            public Throwable cause() {
                return this.cause;
            }

            @Override
            public final void print(PrintStream printStream) {
                String printMessage = String.valueOf(JdkInternals.localWarningHeader()) + X.coalesce(this.message, "");
                printStream.println(printMessage);
                if (this.cause != null) {
                    this.cause.printStackTrace(printStream);
                }
            }
        }
    }
}

